/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.checkin.ImportClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;

public class SvnKitImportClient
extends BaseSvnClient
implements ImportClient {
    @Override
    public long doImport(@NotNull File path, @NotNull SVNURL url, @Nullable Depth depth, @NotNull String message, boolean noIgnore, @Nullable CommitEventHandler handler, @Nullable ISVNCommitHandler commitHandler) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/checkin/SvnKitImportClient", "doImport"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/checkin/SvnKitImportClient", "doImport"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/checkin/SvnKitImportClient", "doImport"));
        }
        SVNCommitClient client = this.myVcs.getSvnKitManager().createCommitClient();
        client.setEventHandler(SvnKitImportClient.toEventHandler(handler));
        client.setCommitHandler(commitHandler);
        try {
            SVNCommitInfo info = client.doImport(path, url, message, null, !noIgnore, false, SvnKitImportClient.toDepth(depth));
            return info.getNewRevision();
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }
}

