/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.change;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdChangeListClient
extends BaseSvnClient
implements ChangeListClient {
    @Override
    public void add(@NotNull String changeList, @NotNull File path, @Nullable String[] changeListsToOperate) throws VcsException {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/change/CmdChangeListClient", "add"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/change/CmdChangeListClient", "add"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(changeList);
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, Depth.EMPTY);
        if (changeListsToOperate != null) {
            CommandUtil.putChangeLists(parameters, Arrays.asList(changeListsToOperate));
        }
        this.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.changelist, parameters, null);
    }

    @Override
    public void remove(@NotNull File path) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/change/CmdChangeListClient", "remove"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("--remove");
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, Depth.EMPTY);
        this.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.changelist, parameters, null);
    }
}

