/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FileStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.status.PortableStatus;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnStatusConvertor {
    private SvnStatusConvertor() {
    }

    @NotNull
    public static FileStatus convertStatus(@Nullable StatusType itemStatus, @Nullable StatusType propertiesStatus) {
        PortableStatus status = new PortableStatus();
        status.setContentsStatus(itemStatus);
        status.setPropertiesStatus(propertiesStatus);
        FileStatus fileStatus = SvnStatusConvertor.convertStatus(status);
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
        }
        return fileStatus;
    }

    @NotNull
    public static FileStatus convertStatus(@Nullable Status status) {
        if (status == null) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_UNVERSIONED)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_MISSING)) {
            FileStatus fileStatus = FileStatus.DELETED_FROM_FS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_EXTERNAL)) {
            FileStatus fileStatus = SvnFileStatus.EXTERNAL;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_OBSTRUCTED)) {
            FileStatus fileStatus = SvnFileStatus.OBSTRUCTED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_IGNORED)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_ADDED)) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.is(StatusType.STATUS_REPLACED)) {
            FileStatus fileStatus = SvnFileStatus.REPLACED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == StatusType.STATUS_CONFLICTED) {
            if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED && status.getPropertiesStatus() == StatusType.STATUS_CONFLICTED) {
                FileStatus fileStatus = FileStatus.MERGED_WITH_BOTH_CONFLICTS;
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
                }
                return fileStatus;
            }
            if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED) {
                FileStatus fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
                }
                return fileStatus;
            }
            FileStatus fileStatus = FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.getContentsStatus() == StatusType.STATUS_MODIFIED || status.getPropertiesStatus() == StatusType.STATUS_MODIFIED) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.isSwitched()) {
            FileStatus fileStatus = FileStatus.SWITCHED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.isCopied()) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
        }
        return fileStatus;
    }

    @NotNull
    public static FileStatus convertPropertyStatus(StatusType status) {
        if (status == null) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_UNVERSIONED.equals((Object)status)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_MISSING.equals((Object)status)) {
            FileStatus fileStatus = FileStatus.DELETED_FROM_FS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_EXTERNAL.equals((Object)status)) {
            FileStatus fileStatus = SvnFileStatus.EXTERNAL;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_OBSTRUCTED.equals((Object)status)) {
            FileStatus fileStatus = SvnFileStatus.OBSTRUCTED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_IGNORED.equals((Object)status)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_ADDED.equals((Object)status)) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_DELETED.equals((Object)status)) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (StatusType.STATUS_REPLACED.equals((Object)status)) {
            FileStatus fileStatus = SvnFileStatus.REPLACED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (status == StatusType.STATUS_CONFLICTED) {
            FileStatus fileStatus = FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (status == StatusType.STATUS_MODIFIED) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
        }
        return fileStatus;
    }
}

