/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;

public class JavaFxPropertyElement
extends BeanPropertyElement {
    private final JavaFxPropertyReference myPropertyReference;

    private JavaFxPropertyElement(PsiMethod method, String propertyName, JavaFxPropertyReference propertyReference) {
        super(method, propertyName);
        this.myPropertyReference = propertyReference;
    }

    @Nullable
    public PsiType getPropertyType() {
        return this.myPropertyReference.getType();
    }

    public String getTypeName() {
        return "property";
    }

    @NotNull
    public JavaFxPropertyReference getPropertyReference() {
        JavaFxPropertyReference javaFxPropertyReference = this.myPropertyReference;
        if (javaFxPropertyReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyElement", "getPropertyReference"));
        }
        return javaFxPropertyReference;
    }

    @Nullable
    static PsiElement fromReference(@NotNull JavaFxPropertyReference propertyReference) {
        String propertyName;
        if (propertyReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReference", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyElement", "fromReference"));
        }
        PsiElement element = propertyReference.resolve();
        if (element instanceof PsiMethod && (propertyName = propertyReference.getPropertyName()) != null) {
            return new JavaFxPropertyElement((PsiMethod)element, propertyName, propertyReference);
        }
        if (element instanceof PsiField) {
            return element;
        }
        return null;
    }
}

