/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxCommonNames;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxPsiUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxPsiUtil.class.getName()));
    private static final Key<CachedValue<PsiClass>> INJECTED_CONTROLLER = Key.create((String)"javafx.injected.controller");
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"javafx.controller");

    public static XmlProcessingInstruction createSingleImportInstruction(String qualifiedName, Project project) {
        String importText = "<?import " + qualifiedName + "?>";
        PsiElement child = PsiFileFactory.getInstance((Project)project).createFileFromText("a.fxml", (Language)XMLLanguage.INSTANCE, (CharSequence)importText).getFirstChild();
        return (XmlProcessingInstruction)PsiTreeUtil.findChildOfType((PsiElement)child, XmlProcessingInstruction.class);
    }

    public static List<String> parseImports(XmlFile file) {
        return JavaFxPsiUtil.parseInstructions(file, "import");
    }

    public static List<String> parseInjectedLanguages(XmlFile file) {
        return JavaFxPsiUtil.parseInstructions(file, "language");
    }

    private static List<String> parseInstructions(XmlFile file, String instructionName) {
        ArrayList<String> definedImports = new ArrayList<String>();
        XmlDocument document = file.getDocument();
        if (document != null) {
            XmlProlog prolog = document.getProlog();
            ArrayList instructions = new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class));
            for (XmlProcessingInstruction instruction : instructions) {
                String instructionTarget = JavaFxPsiUtil.getInstructionTarget(instructionName, instruction);
                if (instructionTarget == null) continue;
                definedImports.add(instructionTarget);
            }
        }
        return definedImports;
    }

    @Nullable
    public static String getInstructionTarget(String instructionName, XmlProcessingInstruction instruction) {
        ASTNode node = instruction.getNode();
        ASTNode xmlNameNode = node.findChildByType(XmlTokenType.XML_NAME);
        ASTNode importNode = node.findChildByType(XmlTokenType.XML_TAG_CHARACTERS);
        if (xmlNameNode != null && instructionName.equals(xmlNameNode.getText()) && importNode != null) {
            return importNode.getText();
        }
        return null;
    }

    public static PsiClass findPsiClass(String name, PsiElement context) {
        Project project = context.getProject();
        if (!StringUtil.getShortName((String)name).equals(name)) {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
            if (psiClass != null) {
                return psiClass;
            }
            return JavaFxPsiUtil.findNestedPsiClass(name, context, project);
        }
        return JavaFxPsiUtil.findPsiClass(name, JavaFxPsiUtil.parseImports((XmlFile)context.getContainingFile()), context, project);
    }

    private static PsiClass findNestedPsiClass(String name, PsiElement context, Project project) {
        String outerName;
        PsiClass outerClass;
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0 && (outerClass = JavaFxPsiUtil.findPsiClass(outerName = name.substring(0, dotIndex), JavaFxPsiUtil.parseImports((XmlFile)context.getContainingFile()), context, project)) != null) {
            List nameChain = StringUtil.split((String)name, (String)".", (boolean)true, (boolean)false);
            List nestedNames = nameChain.subList(1, nameChain.size());
            PsiClass aClass = outerClass;
            for (String nestedName : nestedNames) {
                if ((aClass = aClass.findInnerClassByName(nestedName, true)) != null) continue;
                return null;
            }
            return aClass;
        }
        return null;
    }

    private static PsiClass findPsiClass(String name, List<String> imports, PsiElement context, Project project) {
        PsiClass psiClass = null;
        if (imports != null) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiFile file = context.getContainingFile();
            for (String anImport : imports) {
                if (StringUtil.getShortName((String)anImport).equals(name)) {
                    psiClass = psiFacade.findClass(anImport, file.getResolveScope());
                } else if (StringUtil.endsWith((CharSequence)anImport, (CharSequence)".*")) {
                    psiClass = psiFacade.findClass(StringUtil.trimEnd((String)anImport, (String)"*") + name, file.getResolveScope());
                }
                if (psiClass == null) continue;
                return psiClass;
            }
        }
        return null;
    }

    public static void insertImportWhenNeeded(XmlFile xmlFile, String shortName, String qualifiedName) {
        XmlDocument document;
        if (shortName != null && qualifiedName != null && JavaFxPsiUtil.findPsiClass(shortName, (PsiElement)xmlFile.getRootTag()) == null && (document = xmlFile.getDocument()) != null) {
            XmlProcessingInstruction processingInstruction = JavaFxPsiUtil.createSingleImportInstruction(qualifiedName, xmlFile.getProject());
            XmlProlog prolog = document.getProlog();
            if (prolog != null) {
                prolog.add((PsiElement)processingInstruction);
            } else {
                document.addBefore((PsiElement)processingInstruction, (PsiElement)document.getRootTag());
            }
            PostprocessReformattingAspect.getInstance((Project)xmlFile.getProject()).doPostponedFormatting(xmlFile.getViewProvider());
        }
    }

    public static PsiClass getPropertyClass(PsiElement member) {
        PsiClassType classType = JavaFxPsiUtil.getPropertyClassType(member);
        return classType != null ? classType.resolve() : null;
    }

    public static PsiClassType getPropertyClassType(PsiElement member) {
        return JavaFxPsiUtil.getPropertyClassType(member, "javafx.beans.property.ObjectProperty");
    }

    public static PsiClassType getPropertyClassType(PsiElement member, String superTypeFQN) {
        PsiClass objectProperty;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass attributeClass;
        PsiType type;
        if (member instanceof PsiMember && (type = PropertyUtil.getPropertyType((PsiMember)((PsiMember)member))) instanceof PsiClassType && (attributeClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null && (objectProperty = JavaPsiFacade.getInstance((Project)attributeClass.getProject()).findClass(superTypeFQN, attributeClass.getResolveScope())) != null) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)objectProperty, (PsiClass)attributeClass, (PsiSubstitutor)resolveResult.getSubstitutor());
            if (superClassSubstitutor != null) {
                PsiType propertyType = superClassSubstitutor.substitute(objectProperty.getTypeParameters()[0]);
                if (propertyType instanceof PsiClassType) {
                    return (PsiClassType)propertyType;
                }
            } else {
                return (PsiClassType)type;
            }
        }
        return null;
    }

    public static PsiMethod findStaticPropertySetter(String attributeName, XmlTag context) {
        PsiClass classWithStaticProperty;
        String packageName = StringUtil.getPackageName((String)attributeName);
        if (context != null && !StringUtil.isEmptyOrSpaces((String)packageName) && (classWithStaticProperty = JavaFxPsiUtil.findPsiClass(packageName, (PsiElement)context)) != null) {
            return JavaFxPsiUtil.findStaticPropertySetter(attributeName, classWithStaticProperty);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findStaticPropertySetter(@NotNull String attributeName, @Nullable PsiClass classWithStaticProperty) {
        PsiMethod[] setters;
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findStaticPropertySetter"));
        }
        if (classWithStaticProperty == null) {
            return null;
        }
        String setterName = PropertyUtil.suggestSetterName((String)StringUtil.getShortName((String)attributeName));
        for (PsiMethod setter : setters = classWithStaticProperty.findMethodsByName(setterName, true)) {
            if (!setter.hasModifierProperty("public") || !setter.hasModifierProperty("static") || setter.getParameterList().getParametersCount() != 2) continue;
            return setter;
        }
        return null;
    }

    public static PsiMethod findPropertyGetter(@NotNull PsiClass psiClass, @Nullable String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findPropertyGetter"));
        }
        if (StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        PsiMethod getter = JavaFxPsiUtil.findPropertyGetter(psiClass, propertyName, null);
        if (getter != null) {
            return getter;
        }
        return JavaFxPsiUtil.findPropertyGetter(psiClass, propertyName, (PsiType)PsiType.BOOLEAN);
    }

    private static PsiMethod findPropertyGetter(PsiClass psiClass, String propertyName, PsiType propertyType) {
        PsiMethod[] getters;
        String getterName = PropertyUtil.suggestGetterName((String)propertyName, (PsiType)propertyType);
        for (PsiMethod getter : getters = psiClass.findMethodsByName(getterName, true)) {
            if (!getter.hasModifierProperty("public") || getter.hasModifierProperty("static") || !PropertyUtil.isSimplePropertyGetter((PsiMethod)getter)) continue;
            return getter;
        }
        return null;
    }

    public static PsiMethod findObservablePropertyGetter(@NotNull PsiClass psiClass, @Nullable String propertyName) {
        PsiMethod[] getters;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findObservablePropertyGetter"));
        }
        if (StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        for (PsiMethod getter : getters = psiClass.findMethodsByName(propertyName + "Property", true)) {
            if (!getter.hasModifierProperty("public") || getter.hasModifierProperty("static") || getter.getParameterList().getParametersCount() != 0 || !InheritanceUtil.isInheritor((PsiType)getter.getReturnType(), (String)"javafx.beans.value.ObservableValue")) continue;
            return getter;
        }
        return null;
    }

    public static PsiClass getControllerClass(PsiFile containingFile) {
        if (containingFile instanceof XmlFile) {
            XmlAttribute rootTypeAttr;
            CachedValuesManager manager;
            PsiClass injectedControllerClass;
            PsiClass controllerClass;
            XmlAttribute attribute;
            XmlTag rootTag = ((XmlFile)containingFile).getRootTag();
            Project project = containingFile.getProject();
            if (rootTag != null && (attribute = rootTag.getAttribute("fx:controller")) != null && (controllerClass = JavaFxPsiUtil.findControllerClass(containingFile, project, attribute)) != null) {
                return controllerClass;
            }
            if (Registry.is((String)"javafx.fxml.controller.from.loader", (boolean)false) && (injectedControllerClass = (PsiClass)(manager = CachedValuesManager.getManager((Project)containingFile.getProject())).getCachedValue((UserDataHolder)containingFile, INJECTED_CONTROLLER, () -> JavaFxPsiUtil.computeInjectedControllerClass(containingFile), true)) != null) {
                return injectedControllerClass;
            }
            if (rootTag != null && "fx:root".equals(rootTag.getName()) && (rootTypeAttr = rootTag.getAttribute("type")) != null) {
                return JavaFxPsiUtil.findControllerClass(containingFile, project, rootTypeAttr);
            }
        }
        return null;
    }

    private static PsiClass findControllerClass(PsiFile containingFile, Project project, XmlAttribute attribute) {
        String attributeValue = attribute.getValue();
        if (!StringUtil.isEmptyOrSpaces((String)attributeValue)) {
            GlobalSearchScope customScope = GlobalSearchScope.projectScope((Project)project).intersectWith(containingFile.getResolveScope());
            return JavaPsiFacade.getInstance((Project)project).findClass(attributeValue, customScope);
        }
        return null;
    }

    public static boolean isEventHandlerProperty(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isEventHandlerProperty"));
        }
        PsiClass tagClass = JavaFxPsiUtil.getTagClass(attribute.getParent());
        return tagClass != null && JavaFxPsiUtil.getEventHandlerPropertyType(tagClass, attribute.getName()) != null;
    }

    @Nullable
    public static PsiClass getTagClass(@Nullable XmlAttributeValue xmlAttributeValue) {
        PsiElement parent;
        if (xmlAttributeValue != null && (parent = xmlAttributeValue.getParent()) instanceof XmlAttribute) {
            XmlTag xmlTag = ((XmlAttribute)parent).getParent();
            return JavaFxPsiUtil.getTagClass(xmlTag);
        }
        return null;
    }

    @Nullable
    public static PsiClass getTagClass(@Nullable XmlTag xmlTag) {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        if (xmlTag != null && (descriptor = xmlTag.getDescriptor()) != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass) {
            return (PsiClass)declaration;
        }
        return null;
    }

    @Nullable
    public static PsiElement getAttributeDeclaration(@Nullable XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor;
        PsiElement parent;
        if (xmlAttributeValue != null && (parent = xmlAttributeValue.getParent()) instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) != null) {
            return descriptor.getDeclaration();
        }
        return null;
    }

    public static boolean isVisibleInFxml(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isVisibleInFxml"));
        }
        return psiMember.hasModifierProperty("public") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javafx.fxml.FXML", (boolean)false);
    }

    @Nullable
    public static PsiMethod findValueOfMethod(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findValueOfMethod"));
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        return psiClass != null ? JavaFxPsiUtil.findValueOfMethod(psiClass) : null;
    }

    @Nullable
    public static PsiMethod findValueOfMethod(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findValueOfMethod"));
        }
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            PsiMethod[] methods;
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$findValueOfMethod$1"));
            }
            for (PsiMethod method : methods = psiClass.findMethodsByName("valueOf", true)) {
                PsiType type;
                PsiParameter[] parameters;
                if (!method.hasModifierProperty("static") || (parameters = method.getParameterList().getParameters()).length != 1 || !(type = parameters[0].getType()).equalsToText("java.lang.String") && !type.equalsToText("java.lang.Object") || !psiClass.equals(PsiUtil.resolveClassInType((PsiType)method.getReturnType()))) continue;
                return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean isReadOnly(String attributeName, XmlTag tag) {
        if (JavaFxPsiUtil.findStaticPropertySetter(attributeName, tag) != null) {
            return false;
        }
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor instanceof JavaFxClassTagDescriptorBase) {
            return ((JavaFxClassTagDescriptorBase)descriptor).isReadOnlyAttribute(attributeName);
        }
        return false;
    }

    public static boolean isExpressionBinding(@Nullable String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }

    public static boolean isIncorrectExpressionBinding(@Nullable String value) {
        if (value == null || !value.startsWith("$")) {
            return false;
        }
        if (value.length() == 1) {
            return true;
        }
        boolean expressionStarts = value.startsWith("${");
        boolean expressionEnds = value.endsWith("}");
        if (expressionStarts && expressionEnds && value.length() == 3) {
            return true;
        }
        if (expressionStarts != expressionEnds) {
            return true;
        }
        if (expressionStarts && value.indexOf(123, 2) >= 2) {
            return true;
        }
        return expressionEnds && value.indexOf(125) < value.length() - 1;
    }

    @Nullable
    public static PsiType getWritablePropertyType(@Nullable PsiType type, @NotNull Project project) {
        PsiSubstitutor substitutor;
        PsiClass propertyClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getWritablePropertyType"));
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (propertyClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.beans.property.Property", GlobalSearchScope.allScope((Project)project))) != null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)propertyClass, (PsiClass)psiClass, (PsiSubstitutor)resolveResult.getSubstitutor())) != null) {
            return substitutor.substitute(propertyClass.getTypeParameters()[0]);
        }
        return null;
    }

    @Nullable
    private static PsiType getDefaultPropertyExpectedType(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            String propertyName;
            PsiMethod getter;
            PsiAnnotationMemberValue memberValue;
            PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton("javafx.beans.DefaultProperty"));
            if (annotation != null && (memberValue = annotation.findAttributeValue(null)) != null && (getter = JavaFxPsiUtil.findPropertyGetter(aClass, propertyName = StringUtil.unquoteString((String)memberValue.getText()))) != null) {
                PsiType propertyType = JavaFxPsiUtil.eraseFreeTypeParameters(getter.getReturnType(), (PsiMember)getter);
                return CachedValueProvider.Result.create((Object)propertyType, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static String getDefaultPropertyName(@Nullable PsiClass aClass) {
        PsiAnnotationMemberValue memberValue;
        if (aClass == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton("javafx.beans.DefaultProperty"));
        if (annotation != null && (memberValue = annotation.findAttributeValue(null)) != null) {
            return StringUtil.unquoteString((String)memberValue.getText());
        }
        return null;
    }

    public static boolean isAbleToInstantiate(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isAbleToInstantiate"));
        }
        return JavaFxPsiUtil.isAbleToInstantiate(psiClass, message -> {});
    }

    public static boolean isAbleToInstantiate(@NotNull PsiClass psiClass, @NotNull Consumer<String> messageConsumer) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isAbleToInstantiate"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isAbleToInstantiate"));
        }
        if (psiClass.isEnum() || JavaFxPsiUtil.hasNamedArgOrNoArgConstructor(psiClass)) {
            return true;
        }
        PsiMethod valueOf = JavaFxPsiUtil.findValueOfMethod(psiClass);
        if (valueOf == null && !JavaFxPsiUtil.hasBuilder(psiClass)) {
            messageConsumer.accept("Unable to instantiate");
            return false;
        }
        return true;
    }

    private static boolean hasNamedArgOrNoArgConstructor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "hasNamedArgOrNoArgConstructor"));
        }
        if (psiClass.getConstructors().length == 0) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$hasNamedArgOrNoArgConstructor$4"));
            }
            for (PsiMethod constructor : psiClass.getConstructors()) {
                PsiParameter[] parameters = constructor.getParameterList().getParameters();
                if (parameters.length == 0) {
                    return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
                boolean annotated = true;
                for (PsiParameter parameter : parameters) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javafx.beans.NamedArg", (boolean)false)) continue;
                    annotated = false;
                    break;
                }
                if (!annotated) continue;
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean hasBuilder(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "hasBuilder"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            PsiMethod[] buildMethods;
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$hasBuilder$6"));
            }
            Project project = psiClass.getProject();
            PsiClass builderClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.util.Builder", GlobalSearchScope.allScope((Project)project));
            if (builderClass != null && (buildMethods = builderClass.findMethodsByName("build", false)).length == 1 && buildMethods[0].getParameterList().getParametersCount() == 0 && ClassInheritorsSearch.search((PsiClass)builderClass).forEach(aClass -> {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$null$5"));
                }
                PsiType returnType = null;
                PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)buildMethods[0], (boolean)false);
                if (method != null) {
                    returnType = method.getReturnType();
                }
                return !Comparing.equal((Object)psiClass, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType));
            })) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean isClassAcceptable(@Nullable XmlTag targetTag, @Nullable PsiClass fromClass) {
        return JavaFxPsiUtil.isClassAcceptable(targetTag, fromClass, (message, type) -> {});
    }

    public static boolean isClassAcceptable(@Nullable XmlTag targetTag, @Nullable PsiClass fromClass, @NotNull BiConsumer<String, Validator.ValidationHost.ErrorType> messageConsumer) {
        PsiElement tagDeclaration;
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isClassAcceptable"));
        }
        if (targetTag == null || fromClass == null || !fromClass.isValid()) {
            return true;
        }
        XmlElementDescriptor tagDescriptor = targetTag.getDescriptor();
        if (tagDescriptor instanceof JavaFxPropertyTagDescriptor) {
            PsiClass containingClass = ((JavaFxPropertyTagDescriptor)tagDescriptor).getPsiClass();
            PsiType targetType = JavaFxPsiUtil.getWritablePropertyType(containingClass, tagDescriptor.getDeclaration());
            return JavaFxPsiUtil.canCoerce(targetType, fromClass, (PsiElement)targetTag, messageConsumer);
        }
        if (tagDescriptor instanceof JavaFxClassTagDescriptorBase && (tagDeclaration = tagDescriptor.getDeclaration()) instanceof PsiClass) {
            PsiType targetType;
            PsiClass defaultPropertyOwnerClass = (PsiClass)tagDeclaration;
            XmlAttribute factoryAttr = targetTag.getAttribute("fx:factory");
            if (factoryAttr != null) {
                defaultPropertyOwnerClass = JavaFxPsiUtil.getFactoryProducedClass((PsiClass)tagDeclaration, factoryAttr.getValue());
            }
            if ((targetType = JavaFxPsiUtil.getDefaultPropertyExpectedType(defaultPropertyOwnerClass)) != null) {
                return JavaFxPsiUtil.canCoerce(targetType, fromClass, (PsiElement)targetTag, messageConsumer);
            }
            if (!JavaFxPsiUtil.isObservableCollection(defaultPropertyOwnerClass)) {
                return JavaFxPsiUtil.noDefaultPropertyError(messageConsumer);
            }
        }
        return true;
    }

    private static boolean noDefaultPropertyError(@NotNull BiConsumer<String, Validator.ValidationHost.ErrorType> messageConsumer) {
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "noDefaultPropertyError"));
        }
        messageConsumer.accept("Parent tag has no default property", Validator.ValidationHost.ErrorType.ERROR);
        return false;
    }

    private static boolean canCoerce(@Nullable PsiType targetType, @NotNull PsiClass fromClass, @NotNull PsiElement context, @NotNull BiConsumer<String, Validator.ValidationHost.ErrorType> messageConsumer) {
        if (fromClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerce"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerce"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerce"));
        }
        if (targetType == null) {
            return true;
        }
        PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)targetType, (GlobalSearchScope)fromClass.getResolveScope());
        if (collectionItemType == null && InheritanceUtil.isInheritor((PsiType)targetType, (String)"javafx.beans.property.Property")) {
            collectionItemType = JavaFxPsiUtil.getWritablePropertyType(targetType, fromClass.getProject());
        }
        if (collectionItemType != null) {
            return JavaFxPsiUtil.canCoerceImpl(collectionItemType, fromClass, context, messageConsumer);
        }
        return JavaFxPsiUtil.canCoerceImpl(targetType, fromClass, context, messageConsumer);
    }

    @Nullable
    private static PsiType eraseFreeTypeParameters(@Nullable PsiType psiType, @NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "eraseFreeTypeParameters"));
        }
        PsiClass containingClass = member.getContainingClass();
        return JavaFxPsiUtil.eraseFreeTypeParameters(psiType, containingClass);
    }

    @Nullable
    private static PsiType eraseFreeTypeParameters(@Nullable PsiType psiType, @Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass).substitute(psiType);
    }

    private static boolean canCoerceImpl(@NotNull PsiType targetType, @NotNull PsiClass fromClass, @NotNull PsiElement context, @NotNull BiConsumer<String, Validator.ValidationHost.ErrorType> messageConsumer) {
        PsiType valueOfParameterType;
        PsiClassType boxedTargetClass;
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerceImpl"));
        }
        if (fromClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerceImpl"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerceImpl"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "canCoerceImpl"));
        }
        if (targetType.equalsToText("java.lang.Object") || targetType.equalsToText("java.lang.String") || targetType.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)fromClass))) {
            return true;
        }
        PsiClassType psiClassType = boxedTargetClass = targetType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)targetType).getBoxedType(context) : null;
        if (boxedTargetClass != null && InheritanceUtil.isInheritor((PsiType)boxedTargetClass, (String)"java.lang.Number") || InheritanceUtil.isInheritor((PsiType)targetType, (String)"java.lang.Number")) {
            if (Comparing.strEqual((String)fromClass.getQualifiedName(), (String)"java.lang.String") || InheritanceUtil.isInheritor((PsiClass)fromClass, (String)"java.lang.Number")) {
                return true;
            }
            return JavaFxPsiUtil.unrelatedTypesWarning(targetType, fromClass, messageConsumer);
        }
        PsiMethod valueOfMethod = JavaFxPsiUtil.findValueOfMethod(targetType);
        PsiType psiType = valueOfParameterType = valueOfMethod != null && valueOfMethod.getParameterList().getParametersCount() == 1 ? valueOfMethod.getParameterList().getParameters()[0].getType() : null;
        if (valueOfParameterType != null && valueOfParameterType.equalsToText("java.lang.Object")) {
            return true;
        }
        if (Comparing.strEqual((String)fromClass.getQualifiedName(), (String)"java.lang.String") && (JavaFxPsiUtil.isPrimitiveOrBoxed(targetType) || valueOfParameterType != null && valueOfParameterType.equalsToText("java.lang.String"))) {
            return true;
        }
        if (valueOfMethod != null) {
            return JavaFxPsiUtil.unrelatedTypesWarning(targetType, fromClass, messageConsumer);
        }
        return JavaFxPsiUtil.unableToCoerceError(targetType, fromClass, messageConsumer);
    }

    private static boolean unableToCoerceError(@NotNull PsiType targetType, @NotNull PsiClass fromClass, @NotNull BiConsumer<String, Validator.ValidationHost.ErrorType> messageConsumer) {
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "unableToCoerceError"));
        }
        if (fromClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "unableToCoerceError"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "unableToCoerceError"));
        }
        messageConsumer.accept("Unable to coerce " + HighlightUtil.formatClass((PsiClass)fromClass) + " to " + targetType.getCanonicalText(), Validator.ValidationHost.ErrorType.ERROR);
        return false;
    }

    private static boolean unrelatedTypesWarning(@NotNull PsiType targetType, @NotNull PsiClass fromClass, @NotNull BiConsumer<String, Validator.ValidationHost.ErrorType> messageConsumer) {
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "unrelatedTypesWarning"));
        }
        if (fromClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "unrelatedTypesWarning"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "unrelatedTypesWarning"));
        }
        messageConsumer.accept("Conversion between unrelated types, " + HighlightUtil.formatClass((PsiClass)fromClass) + " to " + targetType.getCanonicalText(), Validator.ValidationHost.ErrorType.WARNING);
        return true;
    }

    public static boolean isOutOfHierarchy(XmlAttributeValue element) {
        for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class); tag != null; tag = tag.getParentTag()) {
            if (!"fx:define".equals(tag.getName())) continue;
            return true;
        }
        return false;
    }

    public static PsiType getWrappedPropertyType(PsiField field, Project project, Map<String, PsiType> typeMap) {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)field, () -> {
            PsiType propertyType;
            PsiType fieldType = field.getType();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)fieldType);
            PsiClass fieldClass = resolveResult.getElement();
            if (fieldClass == null) {
                PsiType propertyType2 = JavaFxPsiUtil.eraseFreeTypeParameters(fieldType, (PsiMember)field);
                return CachedValueProvider.Result.create((Object)propertyType2, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            PsiType substitute = null;
            for (String typeName : typeMap.keySet()) {
                if (!InheritanceUtil.isInheritor((PsiType)fieldType, (String)typeName)) continue;
                substitute = (PsiType)typeMap.get(typeName);
                break;
            }
            if (substitute == null) {
                if (!InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.beans.value.ObservableValue")) {
                    propertyType = JavaFxPsiUtil.eraseFreeTypeParameters(fieldType, (PsiMember)field);
                    return CachedValueProvider.Result.create((Object)propertyType, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.beans.value.ObservableValue", GlobalSearchScope.allScope((Project)project));
                LOG.assertTrue(aClass != null);
                PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)fieldClass, (PsiSubstitutor)resolveResult.getSubstitutor());
                PsiMethod[] values = aClass.findMethodsByName("getValue", false);
                LOG.assertTrue(values.length == 1);
                substitute = substitutor.substitute(values[0].getReturnType());
            }
            propertyType = JavaFxPsiUtil.eraseFreeTypeParameters(substitute, (PsiMember)field);
            return CachedValueProvider.Result.create((Object)propertyType, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiType getWritablePropertyType(@Nullable PsiClass containingClass, @Nullable PsiElement declaration) {
        if (declaration instanceof PsiField) {
            return JavaFxPsiUtil.getWrappedPropertyType((PsiField)declaration, declaration.getProject(), JavaFxCommonNames.ourWritableMap);
        }
        if (declaration instanceof PsiMethod) {
            PsiType setterArgumentType;
            PsiMethod setter;
            PsiClass psiClass;
            PsiMethod method = (PsiMethod)declaration;
            if (method.getParameterList().getParametersCount() != 0) {
                return JavaFxPsiUtil.getSetterArgumentType(method);
            }
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
            PsiClass psiClass2 = psiClass = containingClass != null ? containingClass : method.getContainingClass();
            if (propertyName != null && containingClass != null && (setter = JavaFxPsiUtil.findInstancePropertySetter(psiClass, propertyName)) != null && (setterArgumentType = JavaFxPsiUtil.getSetterArgumentType(setter)) != null) {
                return setterArgumentType;
            }
            return JavaFxPsiUtil.getGetterReturnType(method);
        }
        return null;
    }

    @Nullable
    private static PsiType getSetterArgumentType(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getSetterArgumentType"));
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$getSetterArgumentType$9"));
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            boolean isStatic = method.hasModifierProperty("static");
            if (isStatic && parameters.length == 2 || !isStatic && parameters.length == 1) {
                PsiType argumentType = JavaFxPsiUtil.eraseFreeTypeParameters(parameters[parameters.length - 1].getType(), (PsiMember)method);
                return CachedValueProvider.Result.create((Object)argumentType, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static PsiType getGetterReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getGetterReturnType"));
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$getGetterReturnType$10"));
            }
            PsiType returnType = JavaFxPsiUtil.eraseFreeTypeParameters(method.getReturnType(), (PsiMember)method);
            return CachedValueProvider.Result.create((Object)returnType, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiType getReadablePropertyType(@Nullable PsiElement declaration) {
        PsiMethod psiMethod;
        if (declaration instanceof PsiField) {
            return JavaFxPsiUtil.getWrappedPropertyType((PsiField)declaration, declaration.getProject(), JavaFxCommonNames.ourReadOnlyMap);
        }
        if (declaration instanceof PsiMethod && (psiMethod = (PsiMethod)declaration).getParameterList().getParametersCount() == 0 && !psiMethod.hasModifierProperty("static")) {
            return JavaFxPsiUtil.getGetterReturnType(psiMethod);
        }
        return null;
    }

    @NotNull
    public static Map<String, XmlAttributeValue> collectFileIds(@Nullable XmlTag currentTag) {
        if (currentTag == null) {
            Map<String, XmlAttributeValue> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectFileIds"));
            }
            return map;
        }
        PsiFile containingFile = currentTag.getContainingFile();
        Map<String, XmlAttributeValue> map = JavaFxPsiUtil.collectFileIds(containingFile, false);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectFileIds"));
        }
        return map;
    }

    @NotNull
    public static Map<String, XmlAttributeValue> collectFileIds(@Nullable PsiFile psiFile, boolean skipController) {
        if (!(psiFile instanceof XmlFile)) {
            Map<String, XmlAttributeValue> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectFileIds"));
            }
            return map;
        }
        XmlTag rootTag = ((XmlFile)psiFile).getRootTag();
        if (rootTag == null) {
            Map<String, XmlAttributeValue> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectFileIds"));
            }
            return map;
        }
        Map cachedIds = (Map)CachedValuesManager.getCachedValue((PsiElement)rootTag, () -> new CachedValueProvider.Result(JavaFxPsiUtil.prepareFileIds(rootTag), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (skipController && cachedIds.containsKey("controller")) {
            THashMap filteredIds = new THashMap(cachedIds);
            filteredIds.remove("controller");
            THashMap tHashMap = filteredIds;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectFileIds"));
            }
            return tHashMap;
        }
        Map map = cachedIds;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectFileIds"));
        }
        return map;
    }

    @NotNull
    private static Map<String, XmlAttributeValue> prepareFileIds(XmlTag rootTag) {
        THashMap fileIds = new THashMap();
        for (XmlTag tag : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)rootTag)).filter(XmlTag.class)) {
            String idValue;
            XmlAttribute idAttribute = tag.getAttribute("fx:id");
            if (idAttribute == null || (idValue = idAttribute.getValue()) == null) continue;
            fileIds.put(idValue, idAttribute.getValueElement());
        }
        XmlAttribute controllerAttribute = rootTag.getAttribute("fx:controller");
        if (controllerAttribute != null) {
            fileIds.put("controller", controllerAttribute.getValueElement());
        }
        THashMap tHashMap = fileIds;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "prepareFileIds"));
        }
        return tHashMap;
    }

    @Nullable
    public static PsiClass getTagClassById(@Nullable XmlAttributeValue xmlAttributeValue, @Nullable String id, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagClassById"));
        }
        return "controller".equals(id) ? JavaFxPsiUtil.getControllerClass(context.getContainingFile()) : JavaFxPsiUtil.getTagClass(xmlAttributeValue);
    }

    @Nullable
    public static PsiClass getWritablePropertyClass(@Nullable XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue != null) {
            return JavaFxPsiUtil.getPropertyClass(JavaFxPsiUtil.getWritablePropertyType(xmlAttributeValue), (PsiElement)xmlAttributeValue);
        }
        return null;
    }

    @Nullable
    public static PsiType getWritablePropertyType(@Nullable XmlAttributeValue xmlAttributeValue) {
        PsiElement declaration;
        PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue);
        if (tagClass != null && (declaration = JavaFxPsiUtil.getAttributeDeclaration(xmlAttributeValue)) != null) {
            return JavaFxPsiUtil.getWritablePropertyType(tagClass, declaration);
        }
        return null;
    }

    @Nullable
    public static PsiClass getPropertyClass(@Nullable PsiType propertyType, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getPropertyClass"));
        }
        if (propertyType instanceof PsiPrimitiveType) {
            PsiClassType boxedType = ((PsiPrimitiveType)propertyType).getBoxedType(context);
            return boxedType != null ? boxedType.resolve() : null;
        }
        return PsiUtil.resolveClassInType((PsiType)propertyType);
    }

    public static boolean hasConversionFromAnyType(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "hasConversionFromAnyType"));
        }
        return Comparing.strEqual((String)targetClass.getQualifiedName(), (String)"java.lang.String") || JavaFxPsiUtil.findValueOfMethod(targetClass) != null;
    }

    @Nullable
    public static String getBoxedPropertyType(@Nullable PsiClass containingClass, @Nullable PsiMember declaration) {
        PsiClass psiClass;
        PsiType psiType = JavaFxPsiUtil.getWritablePropertyType(containingClass, (PsiElement)declaration);
        if (psiType instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)psiType).getBoxedTypeName();
        }
        if (PsiPrimitiveType.getUnboxedType((PsiType)psiType) != null && (psiClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null) {
            return psiClass.getQualifiedName();
        }
        return null;
    }

    @Contract(value="null->false")
    public static boolean isPrimitiveOrBoxed(@Nullable PsiType psiType) {
        return psiType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)psiType) != null;
    }

    @NotNull
    public static Map<String, PsiMember> collectReadableProperties(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(JavaFxPsiUtil.prepareReadableProperties(psiClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectReadableProperties"));
            }
            return map;
        }
        Map<String, PsiMember> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectReadableProperties"));
        }
        return map;
    }

    @NotNull
    private static Map<String, PsiMember> prepareReadableProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "prepareReadableProperties"));
        }
        THashMap acceptableMembers = new THashMap();
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (method.hasModifierProperty("static") || !method.hasModifierProperty("public") || !PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) continue;
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
            assert (propertyName != null);
            acceptableMembers.put(propertyName, method);
        }
        THashMap tHashMap = acceptableMembers;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "prepareReadableProperties"));
        }
        return tHashMap;
    }

    @NotNull
    public static Map<String, PsiMember> collectWritableProperties(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(JavaFxPsiUtil.prepareWritableProperties(psiClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectWritableProperties"));
            }
            return map;
        }
        Map<String, PsiMember> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "collectWritableProperties"));
        }
        return map;
    }

    @NotNull
    private static Map<String, PsiMember> prepareWritableProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "prepareWritableProperties"));
        }
        THashMap acceptableMembers = new THashMap();
        for (PsiMethod constructor : psiClass.getConstructors()) {
            PsiParameter[] parameters;
            if (!constructor.hasModifierProperty("public")) continue;
            for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
                PsiField field;
                String propertyName = JavaFxPsiUtil.getPropertyNameFromNamedArgAnnotation(parameter);
                if (propertyName == null || acceptableMembers.containsKey(propertyName) || (field = psiClass.findFieldByName(propertyName, true)) == null || field.hasModifierProperty("static")) continue;
                acceptableMembers.put(propertyName, field);
            }
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            PsiType fieldType;
            PsiField field;
            if (method.hasModifierProperty("static") || !method.hasModifierProperty("public") || !PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) continue;
            PsiMethod acceptableMember = method;
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
            assert (propertyName != null);
            PsiMethod setter = JavaFxPsiUtil.findInstancePropertySetter(psiClass, propertyName);
            if (setter != null) {
                PsiType setterArgType = setter.getParameterList().getParameters()[0].getType();
                field = psiClass.findFieldByName(propertyName, true);
                if (field != null && !field.hasModifierProperty("static") && ((fieldType = JavaFxPsiUtil.getWritablePropertyType(psiClass, (PsiElement)field)) == null || setterArgType.isConvertibleFrom(fieldType))) {
                    acceptableMember = field;
                }
            } else {
                PsiType returnType = method.getReturnType();
                if (returnType != null && JavaFxPsiUtil.isWritablePropertyType(psiClass, returnType)) {
                    field = psiClass.findFieldByName(propertyName, true);
                    if (field != null && !field.hasModifierProperty("static") && ((fieldType = JavaFxPsiUtil.getWritablePropertyType(psiClass, (PsiElement)field)) == null || returnType.isAssignableFrom(fieldType))) {
                        acceptableMember = field;
                    }
                } else {
                    acceptableMember = null;
                }
            }
            if (acceptableMember == null) continue;
            acceptableMembers.put(propertyName, acceptableMember);
        }
        THashMap tHashMap = acceptableMembers;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "prepareWritableProperties"));
        }
        return tHashMap;
    }

    @Nullable
    private static String getPropertyNameFromNamedArgAnnotation(@NotNull PsiParameter parameter) {
        Object value;
        PsiAnnotationMemberValue psiValue;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getPropertyNameFromNamedArgAnnotation"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{"javafx.beans.NamedArg"});
        if (annotation != null && (psiValue = annotation.findAttributeValue("value")) instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)psiValue).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findInstancePropertySetter(@NotNull PsiClass psiClass, @Nullable String propertyName) {
        PsiMethod[] setters;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findInstancePropertySetter"));
        }
        if (StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        String suggestedSetterName = PropertyUtil.suggestSetterName((String)propertyName);
        for (PsiMethod setter : setters = psiClass.findMethodsByName(suggestedSetterName, true)) {
            if (!setter.hasModifierProperty("public") || setter.hasModifierProperty("static") || !PropertyUtil.isSimplePropertySetter((PsiMethod)setter)) continue;
            return setter;
        }
        return null;
    }

    private static boolean isWritablePropertyType(@NotNull PsiClass psiClass, @NotNull PsiType fieldType) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isWritablePropertyType"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isWritablePropertyType"));
        }
        return JavaFxPsiUtil.isObservableCollection(PsiUtil.resolveClassInType((PsiType)fieldType)) && JavaGenericsUtil.getCollectionItemType((PsiType)fieldType, (GlobalSearchScope)psiClass.getResolveScope()) != null || InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.collections.ObservableMap");
    }

    public static boolean isObservableCollection(@Nullable PsiClass psiClass) {
        return psiClass != null && (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javafx.collections.ObservableList") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javafx.collections.ObservableSet") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javafx.collections.ObservableArray"));
    }

    @Nullable
    private static PsiSubstitutor getTagClassSubstitutor(@NotNull XmlAttribute xmlAttribute, @NotNull PsiClass controllerClass) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass resolvedClass;
        PsiField tagField;
        String tagFieldName;
        if (xmlAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagClassSubstitutor"));
        }
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagClassSubstitutor"));
        }
        XmlTag xmlTag = xmlAttribute.getParent();
        PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlTag);
        if (tagClass != null && !StringUtil.isEmpty((String)(tagFieldName = xmlTag.getAttributeValue("fx:id"))) && (tagField = controllerClass.findFieldByName(tagFieldName, true)) != null && !tagField.hasModifierProperty("static") && JavaFxPsiUtil.isVisibleInFxml((PsiMember)tagField) && (resolvedClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)tagField.getType())).getElement()) != null) {
            return TypeConversionUtil.getClassSubstitutor((PsiClass)tagClass, (PsiClass)resolvedClass, (PsiSubstitutor)resolveResult.getSubstitutor());
        }
        return null;
    }

    @Nullable
    public static PsiClassType getDeclaredEventType(@NotNull XmlAttribute xmlAttribute) {
        PsiClass controllerClass;
        PsiType eventHandlerPropertyType;
        if (xmlAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getDeclaredEventType"));
        }
        PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlAttribute.getParent());
        if (tagClass != null && (eventHandlerPropertyType = JavaFxPsiUtil.getEventHandlerPropertyType(tagClass, xmlAttribute.getName())) != null && (controllerClass = JavaFxPsiUtil.getControllerClass(xmlAttribute.getContainingFile())) != null) {
            PsiSubstitutor tagClassSubstitutor = JavaFxPsiUtil.getTagClassSubstitutor(xmlAttribute, controllerClass);
            PsiType handlerType = tagClassSubstitutor != null ? tagClassSubstitutor.substitute(eventHandlerPropertyType) : eventHandlerPropertyType;
            PsiClassType eventType = JavaFxPsiUtil.substituteEventType(handlerType, xmlAttribute.getProject());
            PsiType erasedType = JavaFxPsiUtil.eraseFreeTypeParameters((PsiType)eventType, tagClass);
            return erasedType instanceof PsiClassType ? (PsiClassType)erasedType : null;
        }
        return null;
    }

    @Nullable
    private static PsiType getEventHandlerPropertyType(@NotNull PsiClass tagClass, @NotNull String eventName) {
        PsiMethod[] handlerSetterCandidates;
        if (tagClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getEventHandlerPropertyType"));
        }
        if (eventName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventName", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getEventHandlerPropertyType"));
        }
        for (PsiMethod handlerSetter : handlerSetterCandidates = tagClass.findMethodsByName(PropertyUtil.suggestSetterName((String)eventName), true)) {
            PsiType propertyType;
            if (handlerSetter.hasModifierProperty("static") || !handlerSetter.hasModifierProperty("public") || !InheritanceUtil.isInheritor((PsiType)(propertyType = PropertyUtil.getPropertyType((PsiMember)handlerSetter)), (String)"javafx.event.EventHandler")) continue;
            return propertyType;
        }
        PsiField handlerField = tagClass.findFieldByName(eventName, true);
        PsiClassType propertyType = JavaFxPsiUtil.getPropertyClassType((PsiElement)handlerField);
        if (InheritanceUtil.isInheritor((PsiType)propertyType, (String)"javafx.event.EventHandler")) {
            return propertyType;
        }
        return null;
    }

    @Nullable
    private static PsiClassType substituteEventType(@Nullable PsiType eventHandlerType, @NotNull Project project) {
        PsiType boundType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "substituteEventType"));
        }
        if (!(eventHandlerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)eventHandlerType).resolveGenerics();
        PsiClass eventHandlerClass = resolveResult.getElement();
        if (eventHandlerClass == null) {
            return null;
        }
        PsiSubstitutor eventHandlerClassSubstitutor = resolveResult.getSubstitutor();
        PsiClass eventHandlerInterface = JavaPsiFacade.getInstance((Project)project).findClass("javafx.event.EventHandler", GlobalSearchScope.allScope((Project)project));
        if (eventHandlerInterface == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)eventHandlerClass, (PsiClass)eventHandlerInterface, (boolean)true)) {
            return null;
        }
        PsiTypeParameter[] typeParameters = eventHandlerInterface.getTypeParameters();
        if (typeParameters.length != 1) {
            return null;
        }
        PsiTypeParameter eventTypeParameter = typeParameters[0];
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)eventHandlerInterface, (PsiClass)eventHandlerClass, (PsiSubstitutor)eventHandlerClassSubstitutor);
        PsiType eventType = substitutor.substitute(eventTypeParameter);
        if (eventType instanceof PsiClassType) {
            return (PsiClassType)eventType;
        }
        if (eventType instanceof PsiWildcardType && (boundType = ((PsiWildcardType)eventType).getBound()) instanceof PsiClassType) {
            return (PsiClassType)boundType;
        }
        return null;
    }

    @Nullable
    private static PsiClass getFactoryProducedClass(@Nullable PsiClass psiClass, @Nullable String factoryMethodName) {
        PsiMethod[] methods;
        if (psiClass == null || factoryMethodName == null) {
            return null;
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(factoryMethodName, true)) {
            if (method.getParameterList().getParametersCount() != 0 || !method.hasModifierProperty("static")) continue;
            return PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
        }
        return null;
    }

    @Nullable
    public static String validateEnumConstant(@NotNull PsiClass enumClass, @NonNls @Nullable String name) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "validateEnumConstant"));
        }
        if (!enumClass.isEnum() || name == null) {
            return null;
        }
        Set constantNames = (Set)CachedValuesManager.getCachedValue((PsiElement)enumClass, () -> {
            if (enumClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "lambda$validateEnumConstant$14"));
            }
            return CachedValueProvider.Result.create((Object)Arrays.stream(enumClass.getFields()).filter(PsiEnumConstant.class::isInstance).map(PomNamedTarget::getName).map(String::toUpperCase).collect(Collectors.toCollection(THashSet::new)), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (!constantNames.contains(name.toUpperCase())) {
            return "No enum constant '" + name + "' in " + enumClass.getQualifiedName();
        }
        return null;
    }

    @NotNull
    public static String getPropertyName(@NotNull String memberName, boolean isMethod) {
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getPropertyName"));
        }
        if (!isMethod) {
            String string = memberName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getPropertyName"));
            }
            return string;
        }
        String propertyName = PropertyUtil.getPropertyName((String)memberName);
        String string = propertyName != null ? propertyName : memberName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getPropertyName"));
        }
        return string;
    }

    @Nullable
    public static PsiClass getTagValueClass(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagValueClass"));
        }
        return (PsiClass)JavaFxPsiUtil.getTagValueClass(xmlTag, JavaFxPsiUtil.getTagClass(xmlTag)).getFirst();
    }

    @NotNull
    public static Pair<PsiClass, Boolean> getTagValueClass(@NotNull XmlTag xmlTag, @Nullable PsiClass tagClass) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagValueClass"));
        }
        if (tagClass != null) {
            XmlAttribute constAttr = xmlTag.getAttribute("fx:constant");
            if (constAttr != null) {
                PsiField constField = tagClass.findFieldByName(constAttr.getValue(), true);
                if (constField != null) {
                    PsiType constType = constField.getType();
                    Pair pair = Pair.create((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)(constType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)constType).getBoxedType((PsiElement)xmlTag) : constType)), (Object)true);
                    if (pair == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagValueClass"));
                    }
                    return pair;
                }
            } else {
                XmlAttribute factoryAttr = xmlTag.getAttribute("fx:factory");
                if (factoryAttr != null) {
                    Pair pair = Pair.create((Object)JavaFxPsiUtil.getFactoryProducedClass(tagClass, factoryAttr.getValue()), (Object)true);
                    if (pair == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagValueClass"));
                    }
                    return pair;
                }
            }
        }
        Pair pair = Pair.create((Object)tagClass, (Object)false);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "getTagValueClass"));
        }
        return pair;
    }

    public static boolean isControllerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isControllerClass"));
        }
        Project project = psiClass.getProject();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        if (JavaFxPsiUtil.isControllerClassName(project, psiClass.getQualifiedName(), resolveScope)) {
            return true;
        }
        Ref refFound = new Ref((Object)false);
        ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)resolveScope, (boolean)true, (boolean)true, (boolean)false).forEach(aClass -> {
            if (JavaFxPsiUtil.isControllerClassName(project, aClass.getQualifiedName(), resolveScope)) {
                refFound.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)refFound.get();
    }

    private static boolean isControllerClassName(@NotNull Project project, @Nullable String qualifiedName, @NotNull GlobalSearchScope resolveScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isControllerClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "isControllerClassName"));
        }
        return qualifiedName != null && !JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName, resolveScope).isEmpty();
    }

    @Nullable
    private static CachedValueProvider.Result<PsiClass> computeInjectedControllerClass(PsiFile containingFile) {
        return (CachedValueProvider.Result)ourGuard.doPreventingRecursion((Object)containingFile, true, () -> {
            PsiMethod[] injectControllerMethods;
            Project project = containingFile.getProject();
            Ref injectedController = new Ref();
            PsiClass fxmlLoader = JavaPsiFacade.getInstance((Project)project).findClass("javafx.fxml.FXMLLoader", GlobalSearchScope.allScope((Project)project));
            if (fxmlLoader != null && (injectControllerMethods = fxmlLoader.findMethodsByName("setController", false)).length == 1) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)containingFile.getResolveScope(), (FileType[])new FileType[]{StdFileTypes.JAVA});
                VirtualFile[] virtualFiles = CacheManager.SERVICE.getInstance((Project)project).getVirtualFilesWithWord(ClassUtil.extractClassName((String)"javafx.fxml.FXMLLoader"), (short)1, globalSearchScope, true);
                if (virtualFiles.length == 0) {
                    return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                GlobalSearchScope filesScope = GlobalSearchScope.filesScope((Project)project, Arrays.asList(virtualFiles));
                Processor processor = loaderReference -> JavaFxPsiUtil.findControllerClassInjection(loaderReference, (Ref<PsiClass>)injectedController, injectControllerMethods[0]);
                ReferencesSearch.search((PsiElement)containingFile, (SearchScope)filesScope).forEach(reference -> {
                    PsiElement parent;
                    PsiType type;
                    PsiNewExpression expression;
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiLiteralExpression && (expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class)) != null && (type = expression.getType()) != null && type.equalsToText("javafx.fxml.FXMLLoader") && (parent = expression.getParent()) instanceof PsiLocalVariable) {
                        ReferencesSearch.search((PsiElement)parent).forEach(processor);
                        PsiClass controller = (PsiClass)injectedController.get();
                        if (controller != null) {
                            return false;
                        }
                    }
                    return true;
                });
            }
            return new CachedValueProvider.Result(injectedController.get(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean findControllerClassInjection(@NotNull PsiReference loaderReference, @NotNull Ref<PsiClass> injectedController, PsiMethod injectControllerMethod) {
        PsiClass psiClass;
        PsiExpression[] expressions;
        PsiMethodCallExpression methodCallExpression;
        if (loaderReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loaderReference", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findControllerClassInjection"));
        }
        if (injectedController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedController", "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil", "findControllerClassInjection"));
        }
        PsiElement element = loaderReference.getElement();
        if (element instanceof PsiReferenceExpression && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) != null && methodCallExpression.resolveMethod() == injectControllerMethod && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0 && (psiClass = PsiUtil.resolveClassInType((PsiType)expressions[0].getType())) != null) {
            injectedController.set((Object)psiClass);
            return false;
        }
        return true;
    }
}

