/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeReconstructionResult;

public class TypeReconstructionUtil {
    @NotNull
    public static KotlinType reconstructBareType(@NotNull KtTypeReference right, @NotNull PossiblyBareType possiblyBareTarget, @Nullable KotlinType subjectType, @NotNull BindingTrace trace, @NotNull KotlinBuiltIns builtIns) {
        KotlinType targetType;
        TypeReconstructionResult reconstructionResult;
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (possiblyBareTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possiblyBareTarget", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        if (subjectType == null) {
            subjectType = builtIns.getAnyType();
        }
        if (!(reconstructionResult = possiblyBareTarget.reconstruct(subjectType)).isAllArgumentsInferred()) {
            TypeConstructor typeConstructor2 = possiblyBareTarget.getBareTypeConstructor();
            trace.report(Errors.NO_TYPE_ARGUMENTS_ON_RHS.on(right, typeConstructor2.getParameters().size(), TypeReconstructionUtil.allStarProjectionsString(typeConstructor2)));
        }
        if ((targetType = reconstructionResult.getResultingType()) != null) {
            if (possiblyBareTarget.isBare()) {
                trace.record(BindingContext.TYPE, right, targetType);
            }
            KotlinType kotlinType = targetType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = ErrorUtils.createErrorType("Failed to reconstruct type: " + right.getText());
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "reconstructBareType"));
        }
        return kotlinType;
    }

    @NotNull
    private static String allStarProjectionsString(@NotNull TypeConstructor constructor2) {
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "allStarProjectionsString"));
        }
        int size = constructor2.getParameters().size();
        assert (size != 0) : "No projections possible for a nilary type constructor" + constructor2;
        ClassifierDescriptor declarationDescriptor = constructor2.getDeclarationDescriptor();
        assert (declarationDescriptor != null) : "No declaration descriptor for type constructor " + constructor2;
        String name2 = declarationDescriptor.getName().asString();
        String string = TypeReconstructionUtil.getTypeNameAndStarProjectionsString(name2, size);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "allStarProjectionsString"));
        }
        return string;
    }

    @NotNull
    public static String getTypeNameAndStarProjectionsString(@NotNull String name2, int size) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "getTypeNameAndStarProjectionsString"));
        }
        StringBuilder builder = new StringBuilder(name2);
        builder.append("<");
        for (int i = 0; i < size; ++i) {
            builder.append("*");
            if (i == size - 1) break;
            builder.append(", ");
        }
        builder.append(">");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/TypeReconstructionUtil", "getTypeNameAndStarProjectionsString"));
        }
        return string;
    }
}

