/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupport;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupportKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinEnum;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Predicate<KotlinType> VALID_SUPERTYPE = new Predicate<KotlinType>(){

        public boolean apply(KotlinType type2) {
            assert (!type2.isError()) : "Error types must be filtered out in DescriptorResolver";
            return TypeUtils.getClassDescriptor(type2) != null;
        }
    };
    private final LazyClassContext c;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final boolean isData;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<LazyClassDescriptor> companionObjectDescriptor;
    private final MemoizedFunctionToNotNull<KtObjectDeclaration, ClassDescriptor> extraCompanionObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final MemberScope staticScope;
    private final NullableLazyValue<Void> forceResolveAllContents;
    private final boolean isCompanionObject;
    private final ClassResolutionScopesSupport resolutionScopesSupport;
    private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
    private final NotNullLazyValue<LexicalScope> scopeForInitializerResolution;

    public LazyClassDescriptor(final @NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name2, final @NotNull KtClassLikeInfo classLikeInfo) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        super(c.getStorageManager(), containingDeclaration, name2, KotlinSourceElementKt.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()));
        this.c = c;
        KtClassOrObject classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        if (classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        StorageManager storageManager = c.getStorageManager();
        this.unsubstitutedMemberScope = this.createMemberScope(c, this.declarationProvider);
        this.kind = classLikeInfo.getClassKind();
        this.staticScope = this.kind == ClassKind.ENUM_CLASS ? new StaticScopeForKotlinEnum(storageManager, this) : MemberScope.Empty.INSTANCE;
        this.typeConstructor = new LazyClassTypeConstructor();
        this.isCompanionObject = classLikeInfo instanceof KtObjectInfo && ((KtObjectInfo)classLikeInfo).isCompanionObject();
        KtModifierList modifierList = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = Modality.FINAL;
        } else {
            Modality defaultModality = this.kind == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality, true);
        }
        boolean isLocal = classOrObject != null && KtPsiUtil.isLocal(classOrObject);
        Visibility defaultVisibility = this.kind == ClassKind.ENUM_ENTRY || this.kind == ClassKind.OBJECT && this.isCompanionObject ? Visibilities.PUBLIC : Visibilities.DEFAULT_VISIBILITY;
        this.visibility = isLocal ? Visibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, defaultVisibility);
        this.isInner = ModifiersChecker.isInnerClass(modifierList) && !ModifiersChecker.isIllegalInner(this);
        this.isData = modifierList != null && modifierList.hasModifier(KtTokens.DATA_KEYWORD);
        ArrayList<KtAnnotationEntry> annotationEntries = new ArrayList<KtAnnotationEntry>();
        if (classOrObject != null && classOrObject.getParent() instanceof KtObjectLiteralExpression) {
            annotationEntries.addAll(KtPsiUtilKt.getAnnotationEntries((KtObjectLiteralExpression)classOrObject.getParent()));
        }
        if (modifierList != null) {
            annotationEntries.addAll(modifierList.getAnnotationEntries());
        }
        this.annotations = !annotationEntries.isEmpty() ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getOuterScope();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$2", "getScope"));
                }
                return lexicalScope;
            }
        }, annotationEntries) : Annotations.Companion.getEMPTY();
        List<KtAnnotationEntry> jetDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = jetDanglingAnnotations.isEmpty() ? Annotations.Companion.getEMPTY() : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "getScope"));
                }
                return lexicalScope;
            }
        }, jetDanglingAnnotations);
        this.companionObjectDescriptor = storageManager.createNullableLazyValue(new Function0<LazyClassDescriptor>(){

            public LazyClassDescriptor invoke() {
                return LazyClassDescriptor.this.computeCompanionObjectDescriptor(LazyClassDescriptor.this.getCompanionObjectIfAllowed());
            }
        });
        this.extraCompanionObjectDescriptors = storageManager.createMemoizedFunction(new Function1<KtObjectDeclaration, ClassDescriptor>(){

            public ClassDescriptor invoke(KtObjectDeclaration companionObject) {
                return LazyClassDescriptor.this.computeCompanionObjectDescriptor(companionObject);
            }
        });
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(new Function0<Void>(){

            public Void invoke() {
                LazyClassDescriptor.this.doForceResolveAllContents();
                return null;
            }
        }, null);
        this.resolutionScopesSupport = new ClassResolutionScopesSupport(this, storageManager, (Function0<? extends LexicalScope>)new Function0<LexicalScope>(){

            public LexicalScope invoke() {
                return LazyClassDescriptor.this.getOuterScope();
            }
        });
        this.parameters = c.getStorageManager().createLazyValue(new Function0<List<TypeParameterDescriptor>>(){

            public List<TypeParameterDescriptor> invoke() {
                List<KtTypeParameter> typeParameters;
                KtClassLikeInfo classInfo = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                KtTypeParameterList typeParameterList = classInfo.getTypeParameterList();
                if (typeParameterList == null) {
                    return Collections.emptyList();
                }
                if (classInfo.getClassKind() == ClassKind.ENUM_CLASS) {
                    c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
                }
                if ((typeParameters = typeParameterList.getParameters()).isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<TypeParameterDescriptor> parameters2 = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
                for (int i = 0; i < typeParameters.size(); ++i) {
                    parameters2.add(new LazyTypeParameterDescriptor(c, LazyClassDescriptor.this, typeParameters.get(i), i));
                }
                return parameters2;
            }
        });
        this.scopeForInitializerResolution = storageManager.createLazyValue(new Function0<LexicalScope>(){

            public LexicalScope invoke() {
                return ClassResolutionScopesSupportKt.scopeForInitializerResolution(LazyClassDescriptor.this, LazyClassDescriptor.this.createInitializerScopeParent(), classLikeInfo.getPrimaryConstructorParameters());
            }
        });
    }

    @NotNull
    private DeclarationDescriptor createInitializerScopeParent() {
        ConstructorDescriptor primaryConstructor2 = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            ConstructorDescriptor constructorDescriptor = primaryConstructor2;
            if (constructorDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createInitializerScopeParent"));
            }
            return constructorDescriptor;
        }
        FunctionDescriptorImpl functionDescriptorImpl = new FunctionDescriptorImpl(this, null, Annotations.Companion.getEMPTY(), Name.special("<init-blocks>"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE){
            {
                this.initialize(null, null, Collections.emptyList(), Collections.<ValueParameterDescriptor>emptyList(), null, Modality.FINAL, Visibilities.PRIVATE);
            }

            @Override
            @NotNull
            protected FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2, @Nullable Name newName2, boolean preserveSource) {
                if (newOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$10", "createSubstitutedCopy"));
                }
                if (kind2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$10", "createSubstitutedCopy"));
                }
                throw new UnsupportedOperationException();
            }
        };
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createInitializerScopeParent"));
        }
        return functionDescriptorImpl;
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        LazyClassMemberScope lazyClassMemberScope = new LazyClassMemberScope(c, declarationProvider, this, c.getTrace());
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        LazyClassMemberScope lazyClassMemberScope = this.unsubstitutedMemberScope;
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getUnsubstitutedMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @NotNull
    protected LexicalScope getOuterScope() {
        LexicalScope lexicalScope = this.c.getDeclarationScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getOuterScope"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForClassHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForClassHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForClassHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForConstructorHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForConstructorHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForConstructorHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForCompanionObjectHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForCompanionObjectHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForCompanionObjectHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberDeclarationResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForStaticMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForStaticMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForStaticMemberDeclarationResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForInitializerResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.scopeForInitializerResolution.invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForInitializerResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List list2 = CollectionsKt.filter(DescriptorUtils.getAllDescriptors(this.unsubstitutedMemberScope), (Function1)new Function1<DeclarationDescriptor, Boolean>(){

            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredCallableMembers"));
        }
        return list2;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2 = this.staticScope;
        if (memberScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getStaticScope"));
        }
        return memberScope2;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Collection<ConstructorDescriptor> collection = this.unsubstitutedMemberScope.getConstructors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getConstructors"));
        }
        return collection;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getTypeConstructor"));
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public LazyClassDescriptor getCompanionObjectDescriptor() {
        return (LazyClassDescriptor)this.companionObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraCompanionObjects() {
        final KtObjectDeclaration allowedCompanionObject = this.getCompanionObjectIfAllowed();
        List list2 = CollectionsKt.map((Iterable)CollectionsKt.filter(this.declarationProvider.getOwnerInfo().getCompanionObjects(), (Function1)new Function1<KtObjectDeclaration, Boolean>(){

            public Boolean invoke(KtObjectDeclaration companionObject) {
                return companionObject != allowedCompanionObject;
            }
        }), (Function1)new Function1<KtObjectDeclaration, ClassDescriptor>(){

            public ClassDescriptor invoke(KtObjectDeclaration companionObject) {
                return (ClassDescriptor)LazyClassDescriptor.this.extraCompanionObjectDescriptors.invoke(companionObject);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDescriptorsForExtraCompanionObjects"));
        }
        return list2;
    }

    @Nullable
    private LazyClassDescriptor computeCompanionObjectDescriptor(@Nullable KtObjectDeclaration companionObject) {
        KtClassLikeInfo companionObjectInfo = LazyClassDescriptor.getCompanionObjectInfo(companionObject);
        if (!(companionObjectInfo instanceof KtClassOrObjectInfo)) {
            return null;
        }
        Name name2 = ((KtClassOrObjectInfo)companionObjectInfo).getName();
        assert (name2 != null);
        this.getUnsubstitutedMemberScope().getContributedClassifier(name2, NoLookupLocation.WHEN_GET_COMPANION_OBJECT);
        ClassDescriptor companionObjectDescriptor2 = this.c.getTrace().get(BindingContext.CLASS, companionObject);
        if (companionObjectDescriptor2 instanceof LazyClassDescriptor) {
            assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Not a companion object: " + companionObjectDescriptor2;
            return (LazyClassDescriptor)companionObjectDescriptor2;
        }
        return null;
    }

    @Nullable
    private static KtClassLikeInfo getCompanionObjectInfo(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject != null) {
            return KtClassInfoUtil.createClassLikeInfo(companionObject);
        }
        return null;
    }

    @Nullable
    private KtObjectDeclaration getCompanionObjectIfAllowed() {
        KtObjectDeclaration companionObject = (KtObjectDeclaration)CollectionsKt.firstOrNull(this.declarationProvider.getOwnerInfo().getCompanionObjects());
        return companionObject != null && this.isCompanionObjectAllowed() ? companionObject : null;
    }

    private boolean isCompanionObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isData() {
        return this.isData;
    }

    @Override
    public boolean isCompanionObject() {
        return this.isCompanionObject;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        Annotations annotations2 = this.danglingAnnotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDanglingAnnotations"));
        }
        return annotations2;
    }

    public String toString() {
        return "lazy class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        LazyClassDescriptor companionObjectDescriptor2 = this.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(companionObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraCompanionObjects());
        ForceResolveUtil.forceResolveAllContents(this.getUnsubstitutedMemberScope());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getCompanionObjectDescriptor();
        this.getDescriptorsForExtraCompanionObjects();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        DescriptorUtils.getAllDescriptors(this.getUnsubstitutedMemberScope());
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        List list2 = (List)this.parameters.invoke();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredTypeParameters"));
        }
        return list2;
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor
    implements LazyEntity {
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
        private final NullableLazyValue<Void> forceResolveAllContents;

        public LazyClassTypeConstructor() {
            super(LazyClassDescriptor.this.c.getStorageManager());
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(new Function0<List<TypeParameterDescriptor>>(){

                public List<TypeParameterDescriptor> invoke() {
                    return TypeParameterUtilsKt.computeConstructorTypeParameters(LazyClassDescriptor.this);
                }
            });
            this.forceResolveAllContents = LazyClassDescriptor.this.c.getStorageManager().createRecursionTolerantNullableLazyValue(new Function0<Void>(){

                public Void invoke() {
                    LazyClassTypeConstructor.this.doForceResolveAllContents();
                    return null;
                }
            }, null);
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(LazyClassDescriptor.this)) {
                List<KotlinType> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "computeSupertypes"));
                }
                return list2;
            }
            KtClassOrObject classOrObject = LazyClassDescriptor.this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
            if (classOrObject == null) {
                Set<KotlinType> set = Collections.singleton(LazyClassDescriptor.this.c.getModuleDescriptor().getBuiltIns().getAnyType());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "computeSupertypes"));
                }
                return set;
            }
            List<KotlinType> allSupertypes = LazyClassDescriptor.this.c.getDescriptorResolver().resolveSupertypes(LazyClassDescriptor.this.getScopeForClassHeaderResolution(), LazyClassDescriptor.this, classOrObject, LazyClassDescriptor.this.c.getTrace());
            ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(allSupertypes, (Predicate)VALID_SUPERTYPE));
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "computeSupertypes"));
            }
            return arrayList;
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportSupertypeLoopError"));
            }
            ClassifierDescriptor supertypeDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (supertypeDescriptor instanceof ClassDescriptor) {
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (superclass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclass", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            Object elementToMark = null;
            if (psiElement instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)psiElement;
                for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
                    KotlinType supertype;
                    KtTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on((PsiElement)elementToMark));
            }
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            SupertypeLoopChecker supertypeLoopChecker = LazyClassDescriptor.this.c.getSupertypeLoopChecker();
            if (supertypeLoopChecker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getSupertypeLoopChecker"));
            }
            return supertypeLoopChecker;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list2 = (List)this.parameters.invoke();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getParameters"));
            }
            return list2;
        }

        @Override
        public boolean isFinal() {
            return LazyClassDescriptor.this.getModality() == Modality.FINAL;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassifierDescriptor getDeclarationDescriptor() {
            LazyClassDescriptor lazyClassDescriptor = LazyClassDescriptor.this;
            if (lazyClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getDeclarationDescriptor"));
            }
            return lazyClassDescriptor;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        @Override
        public void forceResolveAllContents() {
            this.forceResolveAllContents.invoke();
        }

        private void doForceResolveAllContents() {
            ForceResolveUtil.forceResolveAllContents(LazyClassDescriptor.this.getAnnotations());
            ForceResolveUtil.forceResolveAllContents(this.getSupertypes());
            ForceResolveUtil.forceResolveAllContents(this.getParameters());
        }
    }
}

