/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "", "()V", "cache", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/naming/SuggestedName;", "generate", "descriptor", "generateDefault", "getSuggestedName", "", "suggest", "Companion", "js.frontend"})
public final class NameSuggestion {
    private final Map<DeclarationDescriptor, SuggestedName> cache = new WeakHashMap();
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SuggestedName suggest(@NotNull DeclarationDescriptor descriptor2) {
        SuggestedName suggestedName;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Map<DeclarationDescriptor, SuggestedName> $receiver$iv = this.cache;
        SuggestedName value$iv = $receiver$iv.get(descriptor2);
        if (value$iv == null) {
            DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.original");
            SuggestedName answer$iv = this.generate(declarationDescriptor);
            $receiver$iv.put(descriptor2, answer$iv);
            suggestedName = answer$iv;
        } else {
            void var3_3;
            suggestedName = var3_3;
        }
        return suggestedName;
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generate(DeclarationDescriptor descriptor2) {
        if (AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isCompanionObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration!!");
            return this.suggest(declarationDescriptor);
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            List list2 = CollectionsKt.listOf((Object)descriptor2.getName().asString());
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration!!");
            return new SuggestedName(list2, true, descriptor2, declarationDescriptor);
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ModuleDescriptor) {
            return null;
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            SuggestedName suggestedName;
            if (!((PackageFragmentDescriptor)descriptor2).getFqName().isRoot()) {
                List list3;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                SuggestedName suggestedName2;
                Iterable iterable = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
                SuggestedName suggestedName3 = suggestedName2;
                SuggestedName suggestedName4 = suggestedName2;
                void var4_7 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Name name2 = (Name)item$iv$iv;
                    list3 = destination$iv$iv;
                    String string = it.asString();
                    list3.add(string);
                }
                list3 = (List)destination$iv$iv;
                suggestedName = suggestedName4;
                suggestedName3(list3, true, descriptor2, ((PackageFragmentDescriptor)descriptor2).getContainingDeclaration());
            } else {
                suggestedName = null;
            }
            return suggestedName;
        }
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            return this.suggest(((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor());
        }
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary() || AnnotationsUtils.isNativeObject(descriptor2)) {
                DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor.containingDeclaration");
                return this.suggest(declarationDescriptor2);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            String string = AnnotationsUtils.getNameForAnnotatedObject(descriptor2);
            if (string == null) {
                string = this.getSuggestedName(descriptor2);
            }
            String name3 = string;
            List list4 = CollectionsKt.listOf((Object)name3);
            DeclarationDescriptor declarationDescriptor3 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"descriptor.containingDeclaration");
            return new SuggestedName(list4, false, descriptor2, declarationDescriptor3);
        }
        return this.generateDefault(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generateDefault(DeclarationDescriptor descriptor2) {
        void stable;
        void id;
        String string;
        List parts = CollectionsKt.mutableListOf((Object[])new String[0]);
        DeclarationDescriptor current = descriptor2;
        if (current instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)current).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE))) {
            CallableDescriptor callableDescriptor = NameSuggestion.Companion.getOverridden((CallableDescriptor)current);
            if (callableDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            }
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)callableDescriptor;
            if (!ModalityKt.isOverridableOrOverrides(overridden)) {
                current = overridden;
            }
        }
        DeclarationDescriptor fixedDescriptor = current;
        do {
            Collection collection = parts;
            string = this.getSuggestedName(current);
            collection.add(string);
            DeclarationDescriptor last = current;
            if (current.getContainingDeclaration() == null) {
                Intrinsics.throwNpe();
            }
            if (!(last instanceof ConstructorDescriptor) || ((ConstructorDescriptor)last).isPrimary()) continue;
            last = current;
            parts.set(CollectionsKt.getLastIndex((List)parts), this.getSuggestedName(current) + "_init");
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            current = declarationDescriptor;
        } while (current instanceof FunctionDescriptor);
        if (current instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)current).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"current.containingDeclaration");
            current = declarationDescriptor;
        }
        CollectionsKt.reverse((List)parts);
        String unmangledName = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"$", null, null, (int)0, null, null, (int)62, null);
        Companion.NameAndStability nameAndStability = NameSuggestion.Companion.mangleNameIfNecessary(unmangledName, fixedDescriptor);
        string = nameAndStability.component1();
        boolean bl = nameAndStability.component2();
        nameAndStability = null;
        return new SuggestedName(CollectionsKt.listOf((Object)id), (boolean)stable, fixedDescriptor, current);
    }

    private final String getSuggestedName(DeclarationDescriptor descriptor2) {
        String string;
        Name name2 = descriptor2.getName();
        if (name2.isSpecial()) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyGetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("get_");
                DeclarationDescriptor declarationDescriptor2 = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor.correspondingProperty");
                string = stringBuilder.append(this.getSuggestedName(declarationDescriptor2)).toString();
            } else if (declarationDescriptor instanceof PropertySetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("set_");
                DeclarationDescriptor declarationDescriptor3 = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"descriptor.correspondingProperty");
                string = stringBuilder.append(this.getSuggestedName(declarationDescriptor3)).toString();
            } else {
                string = "f";
            }
        } else {
            String string2 = name2.asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name.asString()");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return Companion.getPrivateMangledName(baseName, descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
        Intrinsics.checkParameterIsNotNull((Object)suggestedName, (String)"suggestedName");
        Intrinsics.checkParameterIsNotNull((Object)forCalculateId, (String)"forCalculateId");
        return Companion.getStableMangledName(suggestedName, forCalculateId);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion;", "", "()V", "getArgumentTypesAsString", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getOverridden", "getPrivateMangledName", "baseName", "getStableMangledName", "suggestedName", "forCalculateId", "mangleNameIfNecessary", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "mangleRegularNameIfNecessary", "mangledId", "NameAndStability", "js.frontend"})
    public static final class Companion {
        private final NameAndStability mangleNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            DeclarationDescriptor overriddenDescriptor2 = descriptor2 instanceof CallableDescriptor ? (DeclarationDescriptor)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)descriptor2, (Function1)mangleNameIfNecessary.overriddenDescriptor.1.INSTANCE)) : descriptor2;
            String nativeName = AnnotationsUtils.getNameForAnnotatedObject(overriddenDescriptor2);
            if (nativeName != null) {
                return new NameAndStability(nativeName, true);
            }
            return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
        }

        private final CallableDescriptor getOverridden(CallableDescriptor descriptor2) {
            return (CallableDescriptor)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)descriptor2, (Function1)getOverridden.1.INSTANCE));
        }

        private final NameAndStability mangleRegularNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            Object object;
            if (descriptor2 instanceof ClassOrPackageFragmentDescriptor) {
                return new NameAndStability(baseName, !DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2));
            }
            Function0<NameAndStability> regularAndUnstable$ = new Function0<NameAndStability>(baseName){
                final /* synthetic */ String $baseName;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(this.$baseName, false);
                }
                {
                    this.$baseName = string;
                    super(0);
                }
            };
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return regularAndUnstable$.invoke();
            }
            Function0<NameAndStability> mangledAndStable$ = new Function0<NameAndStability>(baseName, descriptor2){
                final /* synthetic */ String $baseName;
                final /* synthetic */ DeclarationDescriptor $descriptor;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(NameSuggestion.Companion.getStableMangledName(this.$baseName, org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.access$getArgumentTypesAsString(NameSuggestion.Companion, (CallableDescriptor)this.$descriptor)), true);
                }
                {
                    this.$baseName = string;
                    this.$descriptor = declarationDescriptor;
                    super(0);
                }
            };
            Function0<NameAndStability> mangledPrivate$ = new Function0<NameAndStability>(baseName, descriptor2){
                final /* synthetic */ String $baseName;
                final /* synthetic */ DeclarationDescriptor $descriptor;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(NameSuggestion.Companion.getPrivateMangledName(this.$baseName, (CallableDescriptor)this.$descriptor), false);
                }
                {
                    this.$baseName = string;
                    this.$descriptor = declarationDescriptor;
                    super(0);
                }
            };
            DeclarationDescriptor containingDeclaration = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            DeclarationDescriptor declarationDescriptor = containingDeclaration;
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                object = ((CallableMemberDescriptor)descriptor2).getVisibility().isPublicAPI() ? mangledAndStable$.invoke() : regularAndUnstable$.invoke();
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                if (descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isEnumValueOfMethod((FunctionDescriptor)descriptor2)) {
                    return mangledAndStable$.invoke();
                }
                if (Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor2).getVisibility(), (Object)Visibilities.PUBLIC)) {
                    return mangledAndStable$.invoke();
                }
                if (descriptor2 instanceof CallableMemberDescriptor && ModalityKt.isOverridableOrOverrides((CallableMemberDescriptor)descriptor2)) {
                    return mangledAndStable$.invoke();
                }
                if (Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor2).getVisibility(), (Object)Visibilities.PROTECTED) && !ModalityKt.isFinalClass((ClassDescriptor)containingDeclaration) && ((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI()) {
                    return mangledAndStable$.invoke();
                }
                if (((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() && !ModalityKt.isFinalClass((ClassDescriptor)containingDeclaration)) {
                    return mangledPrivate$.invoke();
                }
                object = regularAndUnstable$.invoke();
            } else {
                boolean bl = containingDeclaration instanceof CallableMemberDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    String string = "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                object = regularAndUnstable$.invoke();
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            String ownerName = DescriptorUtilsKt.getFqNameUnsafe(descriptor2.getContainingDeclaration()).asString();
            return this.getStableMangledName(baseName, ownerName + ":" + this.getArgumentTypesAsString(descriptor2));
        }

        private final String getArgumentTypesAsString(CallableDescriptor descriptor2) {
            StringBuilder argTypes = new StringBuilder();
            ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                argTypes.append(org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getJetTypeFqName(receiverParameter.getType(), true)).append(".");
            }
            argTypes.append(CollectionsKt.joinToString$default((Iterable)descriptor2.getValueParameters(), (CharSequence)",", null, null, (int)0, null, (Function1)getArgumentTypesAsString.1.INSTANCE, (int)30, null));
            String string = argTypes.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"argTypes.toString()");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkParameterIsNotNull((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkParameterIsNotNull((Object)forCalculateId, (String)"forCalculateId");
            CharSequence charSequence = forCalculateId;
            String suffix = charSequence.length() == 0 ? "" : "_" + this.mangledId(forCalculateId) + "$";
            return suggestedName + suffix;
        }

        private final String mangledId(String forCalculateId) {
            String string;
            int absHashCode = Math.abs(forCalculateId.hashCode());
            if (absHashCode != 0) {
                String string2 = Integer.toString(absHashCode, 36);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Integer.toString(absHashCode, Character.MAX_RADIX)");
            } else {
                string = "";
            }
            return string;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getArgumentTypesAsString(Companion $this, @NotNull CallableDescriptor descriptor2) {
            return $this.getArgumentTypesAsString(descriptor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "", "name", "", "stable", "", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getStable", "()Z", "component1", "component2", "copy", "js.frontend"})
        public static final class NameAndStability {
            @NotNull
            private final String name;
            private final boolean stable;

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean getStable() {
                return this.stable;
            }

            public NameAndStability(@NotNull String name2, boolean stable) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                this.name = name2;
                this.stable = stable;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final boolean component2() {
                return this.stable;
            }

            @NotNull
            public final NameAndStability copy(@NotNull String name2, boolean stable) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return new NameAndStability(name2, stable);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ NameAndStability copy$default(NameAndStability nameAndStability, String string, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
                }
                if ((n & 1) != 0) {
                    string = nameAndStability.name;
                }
                if ((n & 2) != 0) {
                    bl = nameAndStability.stable;
                }
                return nameAndStability.copy(string, bl);
            }

            public String toString() {
                return "NameAndStability(name=" + this.name + ", stable=" + this.stable + ")";
            }

            public int hashCode() {
                String string = this.name;
                int n = (string != null ? string.hashCode() : 0) * 31;
                int n2 = this.stable ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof NameAndStability)) break block3;
                        NameAndStability nameAndStability = (NameAndStability)object;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)nameAndStability.name) || !(this.stable == nameAndStability.stable)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

