/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0017\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u001c\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010 \u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010!J\n\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010$\u001a\u00020\u0013H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010&\u001a\u00020\u0015H\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0002J\b\u0010(\u001a\u00020\u000fH\u0016R\u0011\u0010\u0007\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "T", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "expression", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtElement;", "bindToElement", "Lcom/intellij/psi/PsiElement;", "canRename", "", "getCanonicalText", "", "getLabelTargets", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getTargetDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getVariants", "", "", "()[Ljava/lang/Object;", "handleElementRename", "newElementName", "isReferenceTo", "isSoft", "multiResolve", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "resolve", "resolveToDescriptors", "bindingContext", "resolveToPsiElements", "targetDescriptor", "targetDescriptors", "toString", "idea-analysis"})
public abstract class AbstractKtReference<T extends KtElement>
extends PsiPolyVariantReferenceBase<T>
implements KtReference {
    @NotNull
    public final T getExpression() {
        KtElement ktElement = (KtElement)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"element");
        return (T)ktElement;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(this.resolveToPsiElements());
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"PsiElementResolveResult.\u2026s(resolveToPsiElements())");
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        Collection<PsiElement> psiElements = this.resolveToPsiElements();
        if (psiElements.size() == 1) {
            return psiElements.iterator().next();
        }
        return null;
    }

    public boolean isReferenceTo(@Nullable PsiElement element2) {
        return element2 != null && ReferenceUtilKt.matchesTarget((PsiReference)this, element2);
    }

    @NotNull
    public String getCanonicalText() {
        return "<TBD>";
    }

    public boolean canRename() {
        return false;
    }

    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        throw (Throwable)new IncorrectOperationException();
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        throw (Throwable)new IncorrectOperationException();
    }

    @NotNull
    public Object[] getVariants() {
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    private final Collection<PsiElement> resolveToPsiElements() {
        BindingContext bindingContext2 = ResolutionUtils.analyze(this.getExpression(), BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
        return this.resolveToPsiElements(bindingContext2, this.getTargetDescriptors(bindingContext2));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> resolveToDescriptors(@NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        return this.getTargetDescriptors(bindingContext2);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiElement> resolveToPsiElements(BindingContext context, Collection<? extends DeclarationDescriptor> targetDescriptors) {
        Collection<? extends DeclarationDescriptor> collection = targetDescriptors;
        if (!collection.isEmpty()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = targetDescriptors;
            Iterable iterable = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                DeclarationDescriptor target = (DeclarationDescriptor)element$iv$iv;
                Iterable list$iv$iv = this.resolveToPsiElements(target);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        Collection<PsiElement> labelTargets = this.getLabelTargets(context);
        if (labelTargets != null) {
            return labelTargets;
        }
        Collection collection3 = Collections.emptySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"Collections.emptySet()");
        return collection3;
    }

    private final Collection<PsiElement> resolveToPsiElements(DeclarationDescriptor targetDescriptor) {
        if (targetDescriptor instanceof PackageViewDescriptor) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.getExpression().getProject());
            String fqName2 = ((PackageViewDescriptor)targetDescriptor).getFqName().asString();
            return AddToStdlibKt.singletonOrEmptyList(psiFacade.findPackage(fqName2));
        }
        Project project = this.getExpression().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"expression.project");
        return DescriptorToSourceUtilsIde.INSTANCE.getAllDeclarations(project, targetDescriptor);
    }

    @NotNull
    protected abstract Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext var1);

    private final Collection<PsiElement> getLabelTargets(BindingContext context) {
        T reference2 = this.getExpression();
        if (!(reference2 instanceof KtReferenceExpression)) {
            return null;
        }
        PsiElement labelTarget = (PsiElement)context.get(BindingContext.LABEL_TARGET, reference2);
        if (labelTarget != null) {
            return CollectionsKt.listOf((Object)labelTarget);
        }
        return (Collection)context.get(BindingContext.AMBIGUOUS_LABEL_TARGET, reference2);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getExpression().getText();
    }

    public AbstractKtReference(@NotNull T element2) {
        Intrinsics.checkParameterIsNotNull(element2, (String)"element");
        super((PsiElement)element2);
    }
}

