/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\f"}, d2={"KOTLIN_DECOMPILED_FOLDER", "", "getKOTLIN_DECOMPILED_FOLDER", "()Ljava/lang/String;", "KOTLIN_DECOMPILED_ROOT", "getKOTLIN_DECOMPILED_ROOT", "getOrCreateDummyRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "showDecompiledCode", "", "sourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
public final class KotlinDecompilerAdapterKt {
    @NotNull
    private static final String KOTLIN_DECOMPILED_FOLDER = "kotlinDecompiled";
    @NotNull
    private static final String KOTLIN_DECOMPILED_ROOT = "dummy://kotlinDecompiled";

    public static final void showDecompiledCode(@NotNull KtFile sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        KotlinDecompilerService kotlinDecompilerService = KotlinDecompilerService.Companion.getInstance();
        if (kotlinDecompilerService == null) {
            return;
        }
        KotlinDecompilerService decompilerService = kotlinDecompilerService;
        String decompiledCode = decompilerService.decompile(sourceFile);
        if (decompiledCode == null) {
            Messages.showErrorDialog((String)("Cannot decompile " + sourceFile.getName()), (String)"Decompiler error");
            return;
        }
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(sourceFile, decompiledCode){
            final /* synthetic */ KtFile $sourceFile;
            final /* synthetic */ String $decompiledCode;

            public final void invoke() {
                VirtualFile root = KotlinDecompilerAdapterKt.getOrCreateDummyRoot();
                String decompiledFileName = FileUtil.getNameWithoutExtension((String)this.$sourceFile.getName()) + ".decompiled.java";
                VirtualFile result2 = DummyFileSystem.getInstance().createChildFile(null, root, decompiledFileName);
                VfsUtil.saveText((VirtualFile)result2, (String)this.$decompiledCode);
                new OpenFileDescriptor(this.$sourceFile.getProject(), result2).navigate(true);
            }
            {
                this.$sourceFile = ktFile;
                this.$decompiledCode = string;
                super(0);
            }
        });
    }

    @NotNull
    public static final String getKOTLIN_DECOMPILED_FOLDER() {
        return KOTLIN_DECOMPILED_FOLDER;
    }

    @NotNull
    public static final String getKOTLIN_DECOMPILED_ROOT() {
        return KOTLIN_DECOMPILED_ROOT;
    }

    @NotNull
    public static final VirtualFile getOrCreateDummyRoot() {
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().refreshAndFindFileByUrl(KOTLIN_DECOMPILED_ROOT);
        if (virtualFile2 == null) {
            VirtualFile virtualFile3 = DummyFileSystem.getInstance().createRoot(KOTLIN_DECOMPILED_FOLDER);
            virtualFile2 = virtualFile3;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"DummyFileSystem.getInsta\u2026KOTLIN_DECOMPILED_FOLDER)");
        }
        return virtualFile2;
    }

    static {
        KOTLIN_DECOMPILED_FOLDER = KOTLIN_DECOMPILED_FOLDER;
        KOTLIN_DECOMPILED_ROOT = "dummy://" + KOTLIN_DECOMPILED_FOLDER;
    }
}

