/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighterKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getSmartCastTarget", "Lcom/intellij/psi/PsiElement;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "highlightVariable", "", "elementToHighlight", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "visitExpression", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitVariableDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "idea-analysis"})
public final class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor target = declarationDescriptor;
        if (target instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)((Boolean)this.bindingContext.get(BindingContext.AUTO_CREATED_IT, target)), (Object)true)) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Automatically declared based on the expected type").setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER);
        }
        if (!(expression2.getParent() instanceof KtValueArgumentName)) {
            PsiElement psiElement = (PsiElement)expression2;
            DeclarationDescriptor declarationDescriptor2 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"target");
            this.highlightVariable(psiElement, declarationDescriptor2);
        }
        super.visitSimpleNameExpression(expression2);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        this.visitVariableDeclaration(property2);
        super.visitProperty(property2);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor == null) {
            this.visitVariableDeclaration(parameter);
        }
        super.visitParameter(parameter);
    }

    private final PsiElement getSmartCastTarget(KtExpression expression2) {
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement target = (PsiElement)expression2;
        if (target instanceof KtParenthesizedExpression) {
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)target);
            PsiElement psiElement3 = target = ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression2;
        }
        if ((psiElement2 = target) instanceof KtIfExpression) {
            PsiElement psiElement4 = ((KtIfExpression)target).getIfKeyword();
            psiElement = psiElement4;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"target.ifKeyword");
        } else if (psiElement2 instanceof KtWhenExpression) {
            PsiElement psiElement5 = ((KtWhenExpression)target).getWhenKeyword();
            psiElement = psiElement5;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"target.whenKeyword");
        } else if (psiElement2 instanceof KtBinaryExpression) {
            PsiElement psiElement6 = (PsiElement)((KtBinaryExpression)target).getOperationReference();
            psiElement = psiElement6;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"target.operationReference");
        } else {
            psiElement = target;
        }
        return psiElement;
    }

    @Override
    public void visitExpression(@NotNull KtExpression expression2) {
        KotlinType smartCast;
        boolean nullSmartCast;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KotlinType implicitSmartCast = (KotlinType)this.bindingContext.get(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, expression2);
        if (implicitSmartCast != null) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Implicit receiver smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(implicitSmartCast)).setTextAttributes(KotlinHighlightingColors.SMART_CAST_RECEIVER);
        }
        if (nullSmartCast = Intrinsics.areEqual((Object)((Boolean)this.bindingContext.get(BindingContext.SMARTCAST_NULL, expression2)), (Object)true)) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Always null").setTextAttributes(KotlinHighlightingColors.SMART_CONSTANT);
        }
        if ((smartCast = (KotlinType)this.bindingContext.get(BindingContext.SMARTCAST, expression2)) != null) {
            this.holder.createInfoAnnotation(this.getSmartCastTarget(expression2), "Smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(smartCast)).setTextAttributes(KotlinHighlightingColors.SMART_CAST_VALUE);
        }
        super.visitExpression(expression2);
    }

    private final void visitVariableDeclaration(KtNamedDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        PsiElement nameIdentifier = declaration.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private final void highlightVariable(PsiElement elementToHighlight, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            if (DynamicCallsKt.isDynamic(descriptor2)) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"DYNAMIC_PROPERTY_CALL");
                NameHighlighterKt.highlightName(this.holder, elementToHighlight, textAttributesKey);
                return;
            }
            if (((VariableDescriptor)descriptor2).isVar()) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
                NameHighlighterKt.highlightName(this.holder, elementToHighlight, textAttributesKey);
            }
            if (Intrinsics.areEqual((Object)((Object)((CaptureKind)((Object)this.bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, descriptor2)))), (Object)((Object)CaptureKind.NOT_INLINE))) {
                String msg = ((VariableDescriptor)descriptor2).isVar() ? "Wrapped into a reference object to be modified when captured in a closure" : "Value captured in a closure";
                PsiElement parent2 = elementToHighlight.getParent();
                if (!(parent2 instanceof PsiNameIdentifierOwner) || !Intrinsics.areEqual((Object)((PsiNameIdentifierOwner)parent2).getNameIdentifier(), (Object)elementToHighlight)) {
                    this.holder.createInfoAnnotation(elementToHighlight, msg).setTextAttributes(KotlinHighlightingColors.WRAPPED_INTO_REF);
                }
            }
            if (descriptor2 instanceof LocalVariableDescriptor && !(descriptor2 instanceof SyntheticFieldDescriptor)) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.LOCAL_VARIABLE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"LOCAL_VARIABLE");
                NameHighlighterKt.highlightName(this.holder, elementToHighlight, textAttributesKey);
            }
            if (descriptor2 instanceof ValueParameterDescriptor) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.PARAMETER;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"PARAMETER");
                NameHighlighterKt.highlightName(this.holder, elementToHighlight, textAttributesKey);
            }
        }
    }

    public VariablesHighlightingVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

