/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.coverage;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J3\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0011H\u0016\u00a2\u0006\u0002\u0010&R\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0006\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension;", "Lcom/intellij/coverage/JavaCoverageEngineExtension;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG$1", "collectOutputFiles", "", "srcFile", "Lcom/intellij/psi/PsiFile;", "output", "Lcom/intellij/openapi/vfs/VirtualFile;", "testoutput", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "classFiles", "", "Ljava/io/File;", "getSummaryCoverageInfo", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "element", "Lcom/intellij/psi/PsiNamedElement;", "isApplicableTo", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "keepCoverageInfoForClassWithoutSource", "bundle", "classFile", "suggestQualifiedName", "sourceFile", "classes", "", "Lcom/intellij/psi/PsiClass;", "names", "", "(Lcom/intellij/psi/PsiFile;[Lcom/intellij/psi/PsiClass;Ljava/util/Set;)Z", "Companion", "idea"})
public final class KotlinCoverageExtension
extends JavaCoverageEngineExtension {
    private final Logger LOG$1 = Logger.getInstance(KotlinCoverageExtension.class);
    private static final Logger LOG;
    public static final Companion Companion;

    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        return conf instanceof JetRunConfiguration;
    }

    public boolean suggestQualifiedName(@NotNull PsiFile sourceFile, @NotNull PsiClass[] classes2, @NotNull Set<String> names) {
        List<String> qNames;
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)classes2, (String)"classes");
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        if (sourceFile instanceof KtFile && (qNames = Companion.collectGeneratedClassQualifiedNames(KotlinCoverageExtension.Companion.findOutputRoot((KtFile)sourceFile), (KtFile)sourceFile)) != null) {
            names.addAll((Collection<String>)qNames);
            return true;
        }
        return false;
    }

    @Nullable
    public PackageAnnotator.ClassCoverageInfo getSummaryCoverageInfo(@NotNull JavaCoverageAnnotator coverageAnnotator, @NotNull PsiNamedElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)coverageAnnotator, (String)"coverageAnnotator");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!(element2 instanceof KtFile)) {
            return null;
        }
        this.LOG$1.info("Retrieving coverage for " + ((KtFile)element2).getName());
        List<String> qualifiedNames = Companion.collectGeneratedClassQualifiedNames(KotlinCoverageExtension.Companion.findOutputRoot((KtFile)element2), (KtFile)element2);
        return qualifiedNames == null ? (PackageAnnotator.ClassCoverageInfo)null : KotlinCoverageExtension.Companion.totalCoverageForQualifiedNames(coverageAnnotator, qualifiedNames);
    }

    public boolean keepCoverageInfoForClassWithoutSource(@NotNull CoverageSuitesBundle bundle, @NotNull File classFile) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        return true;
    }

    public boolean collectOutputFiles(@NotNull PsiFile srcFile, @Nullable VirtualFile output, @Nullable VirtualFile testoutput, @NotNull CoverageSuitesBundle suite, @NotNull Set<File> classFiles) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        Intrinsics.checkParameterIsNotNull(classFiles, (String)"classFiles");
        if (srcFile instanceof KtFile) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)srcFile.getProject()).getFileIndex();
            if (fileIndex.isInLibraryClasses(srcFile.getVirtualFile()) || fileIndex.isInLibrarySource(srcFile.getVirtualFile())) {
                return false;
            }
            ApplicationUtilsKt.runReadAction((Function0)new Function0<Set<File>>(srcFile, classFiles){
                final /* synthetic */ PsiFile $srcFile;
                final /* synthetic */ Set $classFiles;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Set<File> invoke() {
                    void destination$iv;
                    void $receiver$iv;
                    VirtualFile outputRoot = org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension$Companion.access$findOutputRoot(KotlinCoverageExtension.Companion, (KtFile)this.$srcFile);
                    List existingClassFiles = org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension$Companion.access$getClassesGeneratedFromFile(KotlinCoverageExtension.Companion, outputRoot, (KtFile)this.$srcFile);
                    Iterable iterable = existingClassFiles;
                    Collection collection = this.$classFiles;
                    for (T item$iv : $receiver$iv) {
                        void it;
                        VirtualFile virtualFile2 = (VirtualFile)item$iv;
                        void var10_8 = destination$iv;
                        File file2 = new File(it.getPath());
                        var10_8.add(file2);
                    }
                    return (Set)destination$iv;
                }
                {
                    this.$srcFile = psiFile;
                    this.$classFiles = set;
                    super(0);
                }
            });
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinCoverageExtension.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "collectClassFilePrefixes", "", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectGeneratedClassQualifiedNames", "", "outputRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "findOutputRoot", "getClassesGeneratedFromFile", "totalCoverageForQualifiedNames", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "qualifiedNames", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @Nullable
        public final List<String> collectGeneratedClassQualifiedNames(@Nullable VirtualFile outputRoot, @NotNull KtFile file2) {
            VirtualFile it;
            List list2;
            Collection destination$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            List<VirtualFile> existingClassFiles = this.getClassesGeneratedFromFile(outputRoot, file2);
            if (existingClassFiles.isEmpty()) {
                return null;
            }
            Iterable iterable = existingClassFiles;
            CharSequence charSequence = new StringBuilder().append("Classfiles: [");
            Object object = this.getLOG();
            void var5_7 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                list2 = destination$iv$iv;
                String string = it.getName();
                list2.add(string);
            }
            list2 = (List)destination$iv$iv;
            object.debug(charSequence.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).append("]").toString());
            $receiver$iv = existingClassFiles;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String relativePath;
                it = (VirtualFile)item$iv$iv;
                object = destination$iv$iv;
                VirtualFile virtualFile3 = outputRoot;
                if (virtualFile3 == null) {
                    Intrinsics.throwNpe();
                }
                if (VfsUtilCore.getRelativePath((VirtualFile)it, (VirtualFile)virtualFile3) == null) {
                    Intrinsics.throwNpe();
                }
                charSequence = StringsKt.replace$default((String)StringUtil.trimEnd((String)relativePath, (String)".class"), (String)"/", (String)".", (boolean)false, (int)4, null);
                object.add(charSequence);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final PackageAnnotator.ClassCoverageInfo totalCoverageForQualifiedNames(JavaCoverageAnnotator coverageAnnotator, List<String> qualifiedNames) {
            void $receiver$iv;
            PackageAnnotator.ClassCoverageInfo result2 = new PackageAnnotator.ClassCoverageInfo();
            result2.totalClassCount = 0;
            Iterable iterable = qualifiedNames;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                PackageAnnotator.ClassCoverageInfo classInfo = coverageAnnotator.getClassCoverageInfo(it);
                if (classInfo != null) {
                    result2.totalClassCount += classInfo.totalClassCount;
                    result2.coveredClassCount += classInfo.coveredClassCount;
                    result2.totalMethodCount += classInfo.totalMethodCount;
                    result2.coveredMethodCount += classInfo.coveredMethodCount;
                    result2.totalLineCount += classInfo.totalLineCount;
                    result2.fullyCoveredLineCount += classInfo.fullyCoveredLineCount;
                    result2.partiallyCoveredLineCount += classInfo.partiallyCoveredLineCount;
                    continue;
                }
                Companion.getLOG().debug("Found no coverage for " + it);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getClassesGeneratedFromFile(VirtualFile outputRoot, KtFile file2) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            VirtualFile packageOutputDir;
            String relativePath = StringsKt.replace$default((String)file2.getPackageFqName().asString(), (char)'.', (char)'/', (boolean)false, (int)4, null);
            VirtualFile virtualFile2 = outputRoot;
            Object object = packageOutputDir = virtualFile2 != null ? virtualFile2.findFileByRelativePath(relativePath) : null;
            if (packageOutputDir == null) {
                return CollectionsKt.emptyList();
            }
            Collection<String> prefixes = this.collectClassFilePrefixes(file2);
            this.getLOG().debug("Classfile prefixes: [" + CollectionsKt.joinToString$default((Iterable)prefixes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]");
            Object[] objectArray = packageOutputDir.getChildren();
            void var7_7 = $receiver$iv;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                boolean bl;
                void element$iv$iv;
                block3: {
                    void $receiver$iv2;
                    element$iv$iv = $receiver$iv$iv[i];
                    VirtualFile file3 = (VirtualFile)element$iv$iv;
                    Iterable iterable = prefixes;
                    for (Object element$iv : $receiver$iv2) {
                        String it = (String)element$iv;
                        if (!(StringsKt.startsWith$default((String)file3.getName(), (String)(it + "$"), (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)file3.getName()), (Object)"class") || Intrinsics.areEqual((Object)file3.getName(), (Object)(it + ".class")))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final VirtualFile findOutputRoot(KtFile file2) {
            VirtualFile virtualFile2;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file2));
            if (module == null) {
                return null;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex();
            boolean inTests = fileIndex.isInTestSourceContent(file2.getVirtualFile());
            CompilerModuleExtension compilerOutputExtension = CompilerModuleExtension.getInstance((Module)module);
            if (inTests) {
                CompilerModuleExtension compilerModuleExtension = compilerOutputExtension;
                if (compilerModuleExtension == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile2 = compilerModuleExtension.getCompilerOutputPathForTests();
            } else {
                CompilerModuleExtension compilerModuleExtension = compilerOutputExtension;
                if (compilerModuleExtension == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile2 = compilerModuleExtension.getCompilerOutputPath();
            }
            return virtualFile2;
        }

        private final Collection<String> collectClassFilePrefixes(KtFile file2) {
            Collection destination$iv$iv;
            PsiElement it;
            Object $receiver$iv$iv;
            Object $receiver$iv = file2.getChildren();
            Object[] objectArray = $receiver$iv;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                it = (PsiElement)element$iv$iv;
                if (!(it instanceof KtClassOrObject)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object item$iv$iv = iterator2.next();
                it = (PsiElement)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                PsiElement psiElement = it;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                }
                if (((KtClassOrObject)psiElement).getName() == null) {
                    Intrinsics.throwNpe();
                }
                collection2.add(string);
            }
            List result2 = (List)destination$iv$iv;
            FqName packagePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName();
            return CollectionsKt.union((Iterable)result2, (Iterable)CollectionsKt.arrayListOf((Object[])new String[]{packagePartFqName.shortName().asString()}));
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$getClassesGeneratedFromFile(Companion $this, @Nullable VirtualFile outputRoot, @NotNull KtFile file2) {
            return $this.getClassesGeneratedFromFile(outputRoot, file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

