/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinClassifierInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "qualifiedNameToInsert", "", "idea-completion"})
public final class KotlinClassifierInsertHandler
extends BaseDeclarationInsertHandler {
    public static final KotlinClassifierInsertHandler INSTANCE;

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context);
        super.handleInsert(context, item);
        PsiFile file2 = context.getFile();
        if (file2 instanceof KtFile && !CompletionUtilsKt.isAfterDot(context)) {
            boolean isAnnotation;
            KtNameReferenceExpression nameRef;
            PsiElement psiElement;
            PsiElement token;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
            psiDocumentManager.commitAllDocuments();
            int startOffset = context.getStartOffset();
            Document document = context.getDocument();
            String qualifiedName = this.qualifiedNameToInsert(item);
            PsiElement psiElement2 = token = file2.findElementAt(startOffset);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            if (!((psiElement = psiElement2.getParent()) instanceof KtNameReferenceExpression)) {
                psiElement = null;
            }
            if ((nameRef = (KtNameReferenceExpression)psiElement) != null) {
                ClassDescriptor target;
                BindingContext bindingContext2 = ResolutionUtils.analyze(nameRef, BodyResolveMode.PARTIAL);
                ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, nameRef);
                if (classDescriptor == null) {
                    Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, nameRef);
                    if (!(v instanceof ClassDescriptor)) {
                        v = null;
                    }
                    classDescriptor = target = (ClassDescriptor)v;
                }
                if (target != null && Intrinsics.areEqual((Object)IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName(target), (Object)qualifiedName)) {
                    return;
                }
            }
            String tempPrefix = nameRef != null ? ((isAnnotation = CallTypeAndReceiver.Companion.detect(nameRef) instanceof CallTypeAndReceiver.ANNOTATION) ? "" : " ") : "$;val v:";
            String tempSuffix = ".xxx";
            document.replaceString(startOffset, context.getTailOffset(), (CharSequence)(tempPrefix + qualifiedName + tempSuffix));
            psiDocumentManager.commitAllDocuments();
            int classNameStart = startOffset + tempPrefix.length();
            int classNameEnd = classNameStart + qualifiedName.length();
            RangeMarker rangeMarker = document.createRangeMarker(classNameStart, classNameEnd);
            RangeMarker wholeRangeMarker = document.createRangeMarker(startOffset, classNameEnd + tempSuffix.length());
            KtFile ktFile = (KtFile)file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
            ShortenReferences.DEFAULT.process(ktFile, classNameStart, classNameEnd);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            if (rangeMarker.isValid() && wholeRangeMarker.isValid()) {
                document.deleteString(wholeRangeMarker.getStartOffset(), rangeMarker.getStartOffset());
                document.deleteString(rangeMarker.getEndOffset(), wholeRangeMarker.getEndOffset());
            }
        }
    }

    private final String qualifiedNameToInsert(LookupElement item) {
        String string;
        String qualifiedName;
        Object object = item.getObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject");
        }
        DeclarationLookupObject lookupObject2 = (DeclarationLookupObject)object;
        if (lookupObject2.getDescriptor() != null) {
            DeclarationDescriptor declarationDescriptor = lookupObject2.getDescriptor();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
            }
            return IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName((ClassifierDescriptor)declarationDescriptor);
        }
        PsiElement psiElement = lookupObject2.getPsiElement();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
        }
        String string2 = ((PsiClass)psiElement).getQualifiedName();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (FqNameUnsafe.isValid(qualifiedName = string2)) {
            string = RenderingUtilsKt.render(new FqNameUnsafe(qualifiedName));
        } else {
            String string3 = qualifiedName;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"qualifiedName");
        }
        return string;
    }

    private KotlinClassifierInsertHandler() {
        INSTANCE = this;
    }

    static {
        new KotlinClassifierInsertHandler();
    }
}

