/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.actions.AutoImportVariant;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "variants", "", "Lorg/jetbrains/kotlin/idea/actions/AutoImportVariant;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "addImport", "", "variant", "execute", "", "getVariantSelectionPopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "showHint", "idea"})
public final class KotlinAddImportAction
implements QuestionAction {
    private final Project project;
    private final Editor editor;
    private final KtElement element;
    private final List<AutoImportVariant> variants;

    public final boolean showHint() {
        if (this.variants.isEmpty()) {
            return false;
        }
        String hintText = ShowAutoImportPass.getMessage((this.variants.size() > 1 ? 1 : 0) != 0, (String)((AutoImportVariant)CollectionsKt.first(this.variants)).getHint());
        HintManager hintManager = HintManager.getInstance();
        int n = this.element.getTextOffset();
        TextRange textRange = this.element.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        hintManager.showQuestionHint(this.editor, hintText, n, textRange.getEndOffset(), (QuestionAction)this);
        return true;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
        if (!this.element.isValid()) {
            return false;
        }
        if (this.variants.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.addImport((AutoImportVariant)CollectionsKt.first(this.variants));
            return true;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)this.getVariantSelectionPopup()).showInBestPositionFor(this.editor);
        return true;
    }

    private final BaseListPopupStep<AutoImportVariant> getVariantSelectionPopup() {
        return (BaseListPopupStep)new BaseListPopupStep<AutoImportVariant>(this, KotlinBundle.message("imports.chooser.title", new Object[0]), this.variants){
            final /* synthetic */ KotlinAddImportAction this$0;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @Nullable
            public PopupStep<String> onChosen(@Nullable AutoImportVariant selectedValue, boolean finalChoice) {
                if (selectedValue == null || KotlinAddImportAction.access$getProject$p(this.this$0).isDisposed()) {
                    return null;
                }
                if (finalChoice) {
                    KotlinAddImportAction.access$addImport(this.this$0, selectedValue);
                    return null;
                }
                List toExclude = AddImportAction.getAllExcludableStrings((String)selectedValue.getExcludeFqNameCheck().asString());
                return (PopupStep)new BaseListPopupStep<String>(this, toExclude, (String)null, toExclude){
                    final /* synthetic */ getVariantSelectionPopup.1 this$0;
                    final /* synthetic */ List $toExclude;

                    @NotNull
                    public String getTextFor(@NotNull String value2) {
                        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                        return "Exclude '" + value2 + "' from auto-import";
                    }

                    @Nullable
                    public PopupStep<Object> onChosen(@Nullable String selectedValue, boolean finalChoice) {
                        if (finalChoice && !KotlinAddImportAction.access$getProject$p(this.this$0.this$0).isDisposed()) {
                            AddImportAction.excludeFromImport((Project)KotlinAddImportAction.access$getProject$p(this.this$0.this$0), (String)selectedValue);
                        }
                        return null;
                    }
                    {
                        this.this$0 = $outer;
                        this.$toExclude = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                    }
                };
            }

            public boolean hasSubstep(@Nullable AutoImportVariant selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(@NotNull AutoImportVariant value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return value2.getHint();
            }

            @NotNull
            public Icon getIconFor(@NotNull AutoImportVariant value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return value2.icon(KotlinAddImportAction.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    private final void addImport(AutoImportVariant variant) {
        PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
        String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"add.import\")");
        ApplicationUtilsKt.executeWriteCommand(this.project, string, (Function0<Unit>)((Function0)new Function0<Unit>(this, variant){
            final /* synthetic */ KotlinAddImportAction this$0;
            final /* synthetic */ AutoImportVariant $variant;

            public final void invoke() {
                if (!KotlinAddImportAction.access$getElement$p(this.this$0).isValid()) {
                    return;
                }
                KtFile file2 = KotlinAddImportAction.access$getElement$p(this.this$0).getContainingKtFile();
                PsiElement psiElement = this.$variant.declarationToImport(KotlinAddImportAction.access$getProject$p(this.this$0));
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    PsiElement it = psiElement2;
                    ProximityLocation location2 = new ProximityLocation((PsiElement)KotlinAddImportAction.access$getElement$p(this.this$0), ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)KotlinAddImportAction.access$getElement$p(this.this$0))));
                    StatisticsManager.getInstance().incUseCount(PsiProximityComparator.STATISTICS_KEY, (Object)it, (Object)location2);
                }
                for (DeclarationDescriptor descriptor2 : this.$variant.getDescriptorsToImport()) {
                    if (descriptor2 instanceof ClassDescriptor || descriptor2 instanceof PackageViewDescriptor) {
                        if (!(KotlinAddImportAction.access$getElement$p(this.this$0) instanceof KtSimpleNameExpression)) continue;
                        KtSimpleNameReference ktSimpleNameReference = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(this.this$0));
                        FqName fqName2 = ImportsUtils.getImportableFqName(descriptor2);
                        if (fqName2 == null) {
                            Intrinsics.throwNpe();
                        }
                        ktSimpleNameReference.bindToFqName(fqName2, KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING);
                        continue;
                    }
                    ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(KotlinAddImportAction.access$getProject$p(this.this$0)), file2, descriptor2, false, 4, null);
                }
            }
            {
                this.this$0 = kotlinAddImportAction;
                this.$variant = autoImportVariant;
                super(0);
            }
        }));
    }

    public KotlinAddImportAction(@NotNull Project project, @NotNull Editor editor, @NotNull KtElement element2, @NotNull List<? extends AutoImportVariant> variants) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(variants, (String)"variants");
        this.project = project;
        this.editor = editor;
        this.element = element2;
        this.variants = variants;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(KotlinAddImportAction $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$addImport(KotlinAddImportAction $this, @NotNull AutoImportVariant variant) {
        $this.addImport(variant);
    }

    @NotNull
    public static final /* synthetic */ KtElement access$getElement$p(KotlinAddImportAction $this) {
        return $this.element;
    }
}

