/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.intrinsics.TypeIntrinsics;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\"\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u0014\u001a\u00020\t*\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u0017H\u0002\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\u0015\u001a\n\u0010\u001a\u001a\u00020\t*\u00020\u0015\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c\u00a8\u0006\u001f"}, d2={"generateAsCast", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "isSafe", "", "generateIsCheck", "generateNullCheckForNonSafeAs", "type", "populateCompanionBackingFieldNamesToOuterContextIfNeeded", "companion", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "outerContext", "Lorg/jetbrains/kotlin/codegen/context/FieldOwnerContext;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "isJvmStaticIn", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isJvmStaticInCompanionObject", "isJvmStaticInObjectOrClass", "replaceValueParametersIn", "", "Lorg/jetbrains/kotlin/load/java/BuiltinMethodsWithSpecialGenericSignature$SpecialSignatureInfo;", "sourceSignature", "backend"})
public final class CodegenUtilKt {
    /*
     * WARNING - void declaration
     */
    public static final void generateIsCheck(@NotNull InstructionAdapter v, @NotNull KotlinType kotlinType, @NotNull Type asmType) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
        if (TypeUtils.isNullableType(kotlinType)) {
            void $receiver;
            Label nope = new Label();
            Label end = new Label();
            InstructionAdapter instructionAdapter = v;
            $receiver.dup();
            $receiver.ifnull(nope);
            TypeIntrinsics.instanceOf((InstructionAdapter)$receiver, kotlinType, asmType);
            $receiver.goTo(end);
            $receiver.mark(nope);
            $receiver.pop();
            $receiver.iconst(1);
            $receiver.mark(end);
        } else {
            TypeIntrinsics.instanceOf(v, kotlinType, asmType);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateAsCast(@NotNull InstructionAdapter v, @NotNull KotlinType kotlinType, @NotNull Type asmType, boolean isSafe) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
        if (!isSafe) {
            if (!TypeUtils.isNullableType(kotlinType)) {
                CodegenUtilKt.generateNullCheckForNonSafeAs(v, kotlinType);
            }
        } else {
            void $receiver;
            InstructionAdapter instructionAdapter = v;
            $receiver.dup();
            TypeIntrinsics.instanceOf(v, kotlinType, asmType);
            Label ok = new Label();
            $receiver.ifne(ok);
            $receiver.pop();
            $receiver.aconst(null);
            $receiver.mark(ok);
        }
        TypeIntrinsics.checkcast(v, kotlinType, asmType, isSafe);
    }

    private static final void generateNullCheckForNonSafeAs(InstructionAdapter v, KotlinType type2) {
        InstructionAdapter $receiver = v;
        $receiver.dup();
        Label nonnull = new Label();
        $receiver.ifnonnull(nonnull);
        AsmUtil.genThrow(v, "kotlin/TypeCastException", "null cannot be cast to non-null type " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2));
        $receiver.mark(nonnull);
    }

    @Nullable
    public static final String replaceValueParametersIn(@NotNull BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo $receiver, @Nullable String sourceSignature) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        String string2 = $receiver.getValueParametersSignature();
        if (string2 != null) {
            String string3;
            String string4 = string2;
            String it = string4;
            String string5 = sourceSignature;
            if (string5 != null) {
                CharSequence charSequence = string5;
                String string6 = "^\\(.*\\)";
                string6 = new Regex(string6);
                String string7 = "(" + it + ")";
                string3 = string6.replace(charSequence, string7);
            } else {
                string3 = null;
            }
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final void populateCompanionBackingFieldNamesToOuterContextIfNeeded(@NotNull KtObjectDeclaration companion, @NotNull FieldOwnerContext<?> outerContext, @NotNull GenerationState state) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)companion, (String)"companion");
        Intrinsics.checkParameterIsNotNull(outerContext, (String)"outerContext");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ClassDescriptor descriptor2 = (ClassDescriptor)state.getBindingContext().get(BindingContext.CLASS, companion);
        if (descriptor2 == null || ErrorUtils.isError(descriptor2)) {
            return;
        }
        if (!JvmAbi.isCompanionObjectWithBackingFieldsInOuter(descriptor2)) {
            return;
        }
        Iterable iterable = companion.getDeclarations();
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properties2 = (List)destination$iv$iv;
        $receiver$iv = properties2;
        for (Object element$iv : $receiver$iv) {
            KtProperty it = (KtProperty)element$iv;
            VariableDescriptor variableDescriptor = (VariableDescriptor)state.getBindingContext().get(BindingContext.VARIABLE, it);
            if (!(variableDescriptor instanceof PropertyDescriptor)) continue;
            outerContext.getFieldName((PropertyDescriptor)variableDescriptor, it.hasDelegate());
        }
    }

    public static final boolean isJvmStaticInObjectOrClass(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CodegenUtilKt.isJvmStaticIn($receiver, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)isJvmStaticInObjectOrClass.1.INSTANCE));
    }

    public static final boolean isJvmStaticInCompanionObject(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CodegenUtilKt.isJvmStaticIn($receiver, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)isJvmStaticInCompanionObject.1.INSTANCE));
    }

    private static final boolean isJvmStaticIn(@NotNull CallableDescriptor $receiver, Function1<? super DeclarationDescriptor, Boolean> predicate) {
        boolean bl;
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"propertyDescriptor.containingDeclaration");
            bl = ((Boolean)predicate.invoke((Object)declarationDescriptor)).booleanValue() && (AnnotationUtilKt.hasJvmStaticAnnotation($receiver) || AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor));
        } else {
            DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration");
            bl = (Boolean)predicate.invoke((Object)declarationDescriptor) != false && AnnotationUtilKt.hasJvmStaticAnnotation($receiver);
        }
        return bl;
    }
}

