/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.PtyException;
import com.pty4j.WinSize;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.NamedPipe;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;

public class WinPty {
    private Pointer myWinpty;
    private WinNT.HANDLE myProcess = null;
    private NamedPipe myConinPipe;
    private NamedPipe myConoutPipe;
    private NamedPipe myConerrPipe;
    private boolean myChildExited = false;
    private int myStatus = -1;
    private boolean myClosed = false;
    private int openInputStreamCount = 0;
    public static final Kern32 KERNEL32 = (Kern32)Native.loadLibrary((String)"kernel32", Kern32.class);
    public static WinPtyLib INSTANCE = (WinPtyLib)Native.loadLibrary((String)WinPty.getLibraryPath(), WinPtyLib.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WinPty(String cmdline, String cwd, String env, boolean consoleMode) throws PtyException, IOException {
        int cols = Integer.getInteger("win.pty.cols", 80);
        int rows = Integer.getInteger("win.pty.rows", 25);
        PointerByReference errPtr = new PointerByReference(null);
        Pointer agentCfg = null;
        Pointer spawnCfg = null;
        Pointer winpty = null;
        WinNT.HANDLEByReference processHandle = new WinNT.HANDLEByReference();
        NamedPipe coninPipe = null;
        NamedPipe conoutPipe = null;
        NamedPipe conerrPipe = null;
        try {
            long agentFlags = 0L;
            if (consoleMode) {
                agentFlags |= 3L;
            }
            if ((agentCfg = INSTANCE.winpty_config_new(agentFlags, null)) == null) {
                throw new PtyException("winpty agent cfg is null");
            }
            INSTANCE.winpty_config_set_initial_size(agentCfg, cols, rows);
            winpty = INSTANCE.winpty_open(agentCfg, errPtr);
            if (winpty == null) {
                WString errMsg = INSTANCE.winpty_error_msg(errPtr.getValue());
                throw new PtyException("Error starting winpty: " + errMsg.toString());
            }
            coninPipe = NamedPipe.connectToServer(INSTANCE.winpty_conin_name(winpty).toString(), 0x40000000);
            conoutPipe = NamedPipe.connectToServer(INSTANCE.winpty_conout_name(winpty).toString(), Integer.MIN_VALUE);
            if (consoleMode) {
                conerrPipe = NamedPipe.connectToServer(INSTANCE.winpty_conerr_name(winpty).toString(), Integer.MIN_VALUE);
            }
            if ((spawnCfg = INSTANCE.winpty_spawn_config_new(3L, null, WinPty.toWString(cmdline), WinPty.toWString(cwd), WinPty.toWString(env), null)) == null) {
                throw new PtyException("winpty spawn cfg is null");
            }
            if (!INSTANCE.winpty_spawn(winpty, spawnCfg, processHandle, null, null, errPtr)) {
                WString errMsg = INSTANCE.winpty_error_msg(errPtr.getValue());
                throw new PtyException("Error running process: " + errMsg.toString());
            }
            this.myWinpty = winpty;
            this.myProcess = processHandle.getValue();
            this.myConinPipe = coninPipe;
            this.myConoutPipe = conoutPipe;
            this.myConerrPipe = conerrPipe;
            this.openInputStreamCount = consoleMode ? 2 : 1;
            WaitForExitThread waitForExit = new WaitForExitThread();
            waitForExit.setDaemon(true);
            waitForExit.start();
            winpty = null;
            processHandle.setValue(null);
            conerrPipe = null;
            conoutPipe = null;
            coninPipe = null;
            INSTANCE.winpty_error_free(errPtr.getValue());
            INSTANCE.winpty_config_free(agentCfg);
            INSTANCE.winpty_spawn_config_free(spawnCfg);
            INSTANCE.winpty_free(winpty);
        }
        catch (Throwable throwable) {
            INSTANCE.winpty_error_free(errPtr.getValue());
            INSTANCE.winpty_config_free(agentCfg);
            INSTANCE.winpty_spawn_config_free(spawnCfg);
            INSTANCE.winpty_free(winpty);
            if (processHandle.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(processHandle.getValue());
            }
            WinPty.closeNamedPipeQuietly(coninPipe);
            WinPty.closeNamedPipeQuietly(conoutPipe);
            WinPty.closeNamedPipeQuietly(conerrPipe);
            throw throwable;
        }
        if (processHandle.getValue() != null) {
            Kernel32.INSTANCE.CloseHandle(processHandle.getValue());
        }
        WinPty.closeNamedPipeQuietly(coninPipe);
        WinPty.closeNamedPipeQuietly(conoutPipe);
        WinPty.closeNamedPipeQuietly(conerrPipe);
    }

    private static void closeNamedPipeQuietly(NamedPipe pipe) {
        try {
            if (pipe != null) {
                pipe.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static WString toWString(String string) {
        return string == null ? null : new WString(string);
    }

    public synchronized void setWinSize(WinSize winSize) {
        if (this.myClosed) {
            return;
        }
        INSTANCE.winpty_set_size(this.myWinpty, winSize.ws_col, winSize.ws_row, null);
    }

    synchronized void decrementOpenInputStreamCount() {
        --this.openInputStreamCount;
        if (this.openInputStreamCount == 0) {
            this.close();
        }
    }

    public synchronized void close() {
        if (this.myClosed) {
            return;
        }
        INSTANCE.winpty_free(this.myWinpty);
        this.myWinpty = null;
        this.myClosed = true;
        this.closeUnusedProcessHandle();
    }

    private synchronized void closeUnusedProcessHandle() {
        if (this.myClosed && this.myChildExited && this.myProcess != null) {
            Kernel32.INSTANCE.CloseHandle(this.myProcess);
            this.myProcess = null;
        }
    }

    public synchronized boolean isRunning() {
        return !this.myChildExited;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.myChildExited) {
            this.wait();
        }
        return this.myStatus;
    }

    public synchronized int getChildProcessId() {
        if (this.myClosed) {
            return -1;
        }
        return Kernel32.INSTANCE.GetProcessId(this.myProcess);
    }

    public synchronized int exitValue() {
        if (!this.myChildExited) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.myStatus;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public NamedPipe getInputPipe() {
        return this.myConoutPipe;
    }

    public NamedPipe getOutputPipe() {
        return this.myConinPipe;
    }

    public NamedPipe getErrorPipe() {
        return this.myConerrPipe;
    }

    private static String getLibraryPath() {
        try {
            return PtyUtil.resolveNativeLibrary().getAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't detect jar containing folder", e);
        }
    }

    static interface WinPtyLib
    extends Library {
        public static final long WINPTY_FLAG_CONERR = 1L;
        public static final long WINPTY_FLAG_PLAIN_OUTPUT = 2L;
        public static final long WINPTY_FLAG_COLOR_ESCAPES = 4L;
        public static final long WINPTY_SPAWN_FLAG_AUTO_SHUTDOWN = 1L;
        public static final long WINPTY_SPAWN_FLAG_EXIT_AFTER_SHUTDOWN = 2L;

        public int winpty_error_code(Pointer var1);

        public WString winpty_error_msg(Pointer var1);

        public void winpty_error_free(Pointer var1);

        public Pointer winpty_config_new(long var1, PointerByReference var3);

        public void winpty_config_free(Pointer var1);

        public void winpty_config_set_initial_size(Pointer var1, int var2, int var3);

        public Pointer winpty_open(Pointer var1, PointerByReference var2);

        public WString winpty_conin_name(Pointer var1);

        public WString winpty_conout_name(Pointer var1);

        public WString winpty_conerr_name(Pointer var1);

        public Pointer winpty_spawn_config_new(long var1, WString var3, WString var4, WString var5, WString var6, PointerByReference var7);

        public void winpty_spawn_config_free(Pointer var1);

        public boolean winpty_spawn(Pointer var1, Pointer var2, WinNT.HANDLEByReference var3, WinNT.HANDLEByReference var4, IntByReference var5, PointerByReference var6);

        public boolean winpty_set_size(Pointer var1, int var2, int var3, PointerByReference var4);

        public void winpty_free(Pointer var1);
    }

    static interface Kern32
    extends Library {
        public boolean PeekNamedPipe(WinNT.HANDLE var1, Pointer var2, int var3, IntByReference var4, IntByReference var5, IntByReference var6);

        public boolean ReadFile(WinNT.HANDLE var1, Pointer var2, int var3, IntByReference var4, Pointer var5);

        public boolean WriteFile(WinNT.HANDLE var1, Pointer var2, int var3, IntByReference var4, Pointer var5);

        public boolean GetOverlappedResult(WinNT.HANDLE var1, Pointer var2, IntByReference var3, boolean var4);

        public WinNT.HANDLE CreateNamedPipeA(String var1, int var2, int var3, int var4, int var5, int var6, int var7, WinBase.SECURITY_ATTRIBUTES var8);

        public boolean ConnectNamedPipe(WinNT.HANDLE var1, WinBase.OVERLAPPED var2);

        public boolean CloseHandle(WinNT.HANDLE var1);

        public WinNT.HANDLE CreateEventA(WinBase.SECURITY_ATTRIBUTES var1, boolean var2, boolean var3, String var4);

        public int GetLastError();

        public int WaitForSingleObject(WinNT.HANDLE var1, int var2);

        public boolean CancelIo(WinNT.HANDLE var1);

        public int GetCurrentProcessId();
    }

    private class WaitForExitThread
    extends Thread {
        private IntByReference myStatusByRef = new IntByReference(-1);

        private WaitForExitThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Kernel32.INSTANCE.WaitForSingleObject(WinPty.this.myProcess, -1);
            Kernel32.INSTANCE.GetExitCodeProcess(WinPty.this.myProcess, this.myStatusByRef);
            WinPty winPty = WinPty.this;
            synchronized (winPty) {
                WinPty.this.myChildExited = true;
                WinPty.this.myStatus = this.myStatusByRef.getValue();
                WinPty.this.closeUnusedProcessHandle();
                WinPty.this.notifyAll();
            }
        }
    }
}

