/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm;

import org.jetbrains.org.objectweb.asm.ByteVector;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

final class ModuleWriter
extends ModuleVisitor {
    private final ClassWriter cw;
    private int size;
    private int requireCount;
    private ByteVector requires;
    private int exportCount;
    private ByteVector exports;
    private int useCount;
    private ByteVector uses;
    private int provideCount;
    private ByteVector provides;

    ModuleWriter(ClassWriter cw) {
        super(393216);
        this.cw = cw;
        this.size = 8;
    }

    public void visitRequire(String module, int access) {
        if (this.requires == null) {
            this.requires = new ByteVector();
        }
        if ((access & 1) != 0) {
            access = access & 0xFFFFFFFE | 0x20;
        }
        this.requires.putShort(this.cw.newUTF8(module)).putShort(access);
        ++this.requireCount;
        this.size += 4;
    }

    public void visitExport(String packaze, String ... modules) {
        if (this.exports == null) {
            this.exports = new ByteVector();
        }
        this.exports.putShort(this.cw.newUTF8(packaze));
        if (modules == null) {
            this.exports.putShort(0);
            this.size += 4;
        } else {
            this.exports.putShort(modules.length);
            for (String to : modules) {
                this.exports.putShort(this.cw.newUTF8(to));
            }
            this.size += 4 + 2 * modules.length;
        }
        ++this.exportCount;
    }

    public void visitUse(String service) {
        if (this.uses == null) {
            this.uses = new ByteVector();
        }
        this.uses.putShort(this.cw.newClass(service));
        ++this.useCount;
        this.size += 2;
    }

    public void visitProvide(String service, String impl) {
        if (this.provides == null) {
            this.provides = new ByteVector();
        }
        this.provides.putShort(this.cw.newClass(service)).putShort(this.cw.newClass(impl));
        ++this.provideCount;
        this.size += 4;
    }

    public void visitEnd() {
    }

    int getSize() {
        return this.size;
    }

    void put(ByteVector out) {
        out.putInt(this.size);
        out.putShort(this.requireCount);
        if (this.requires != null) {
            out.putByteArray(this.requires.data, 0, this.requires.length);
        }
        out.putShort(this.exportCount);
        if (this.exports != null) {
            out.putByteArray(this.exports.data, 0, this.exports.length);
        }
        out.putShort(this.useCount);
        if (this.uses != null) {
            out.putByteArray(this.uses.data, 0, this.uses.length);
        }
        out.putShort(this.provideCount);
        if (this.provides != null) {
            out.putByteArray(this.provides.data, 0, this.provides.length);
        }
    }
}

