/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.PostDiscoveryFilter;

@API(value=API.Usage.Experimental)
public final class TagFilter {
    private TagFilter() {
    }

    public static PostDiscoveryFilter includeTags(String ... tags) {
        Preconditions.notNull((Object)tags, (String)"tags array must not be null");
        return TagFilter.includeTags(Arrays.asList(tags));
    }

    public static PostDiscoveryFilter includeTags(List<String> tags) {
        Preconditions.notEmpty(tags, (String)"tags list must not be null or empty");
        Preconditions.containsNoNullElements(tags, (String)"individual tags must not be null");
        return descriptor -> FilterResult.includedIf((boolean)TagFilter.trimmedTagsOf(descriptor).anyMatch(tags::contains));
    }

    public static PostDiscoveryFilter excludeTags(String ... tags) {
        Preconditions.notNull((Object)tags, (String)"tags array must not be null");
        return TagFilter.excludeTags(Arrays.asList(tags));
    }

    public static PostDiscoveryFilter excludeTags(List<String> tags) {
        Preconditions.notEmpty(tags, (String)"tags list must not be null or empty");
        Preconditions.containsNoNullElements(tags, (String)"individual tags must not be null");
        return descriptor -> FilterResult.includedIf((boolean)TagFilter.trimmedTagsOf(descriptor).noneMatch(tags::contains));
    }

    private static Stream<String> trimmedTagsOf(TestDescriptor descriptor) {
        return descriptor.getTags().stream().map(TestTag::getName).map(String::trim);
    }
}

