/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.util.Key;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.groovy.CheckResourcesTarget;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovyOutputConsumer;
import org.jetbrains.jps.incremental.groovy.GroovyResourceRootDescriptor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.module.JpsModule;

public class GroovyResourceChecker
extends TargetBuilder<GroovyResourceRootDescriptor, CheckResourcesTarget> {
    public static final Key<Boolean> CHECKING_RESOURCES_REBUILD = Key.create((String)"CHECKING_RESOURCES");

    public GroovyResourceChecker() {
        super(CheckResourcesTarget.TARGET_TYPES);
    }

    @NotNull
    public String getPresentableName() {
        if ("Groovy Resource Checker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker", "getPresentableName"));
        }
        return "Groovy Resource Checker";
    }

    public void build(@NotNull CheckResourcesTarget target, @NotNull DirtyFilesHolder<GroovyResourceRootDescriptor, CheckResourcesTarget> holder, final @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker", "build"));
        }
        if (context.getBuilderParameter(CHECKING_RESOURCES_REBUILD.toString()) == null) {
            return;
        }
        new ResourceCheckingGroovycRunner(target).doBuild(context, GroovyResourceChecker.singleModuleChunk(target.getModule()), holder, (Builder)this, new GroovyOutputConsumer(){

            @Override
            public void registerCompiledClass(BuildTarget<?> target, File srcFile, File outputFile, byte[] bytes) throws IOException {
                outputConsumer.registerOutputFile(outputFile, Collections.singleton(srcFile.getPath()));
            }
        });
    }

    @NotNull
    private static ModuleChunk singleModuleChunk(JpsModule module) {
        ModuleChunk moduleChunk = new ModuleChunk(Collections.singleton(new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION)));
        if (moduleChunk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker", "singleModuleChunk"));
        }
        return moduleChunk;
    }

    private static class ResourceCheckingGroovycRunner
    extends JpsGroovycRunner<GroovyResourceRootDescriptor, CheckResourcesTarget> {
        private final CheckResourcesTarget myTarget;

        public ResourceCheckingGroovycRunner(CheckResourcesTarget target) {
            super(false);
            this.myTarget = target;
        }

        @Override
        protected Map<CheckResourcesTarget, String> getCanonicalOutputs(CompileContext context, ModuleChunk chunk, Builder builder) {
            return Collections.singletonMap(this.myTarget, this.myTarget.getOutputRoot(context).getPath());
        }

        @Override
        protected boolean shouldProcessSourceFile(File file, GroovyResourceRootDescriptor sourceRoot, String path, JpsJavaCompilerConfiguration configuration) {
            return GroovyBuilder.isGroovyFile(path) && !configuration.getValidationExcludes().isExcluded(file);
        }

        @Override
        protected boolean checkChunkRebuildNeeded(CompileContext context, GroovycOutputParser parser) {
            return false;
        }

        @Override
        protected Collection<String> generateClasspath(CompileContext context, ModuleChunk chunk) {
            Collection<String> paths = super.generateClasspath(context, chunk);
            for (File resourceOutput : this.getVisibleResourceOutputs(context, this.myTarget.isTests())) {
                paths.add(resourceOutput.getPath());
            }
            return paths;
        }

        @NotNull
        private List<File> getVisibleResourceOutputs(CompileContext context, boolean tests) {
            ArrayList<File> resourceOutputs = new ArrayList<File>();
            JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)this.myTarget.getModule()).includedIn(JpsJavaClasspathKind.compile((boolean)tests)).recursively();
            for (JpsModule module : enumerator.getModules()) {
                resourceOutputs.addAll(new CheckResourcesTarget(module, CheckResourcesTarget.PRODUCTION).getOutputRoots(context));
                if (!tests) continue;
                resourceOutputs.addAll(new CheckResourcesTarget(module, CheckResourcesTarget.TESTS).getOutputRoots(context));
            }
            ArrayList<File> arrayList = resourceOutputs;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceChecker$ResourceCheckingGroovycRunner", "getVisibleResourceOutputs"));
            }
            return arrayList;
        }

        @Override
        protected GroovyResourceRootDescriptor findRoot(CompileContext context, File srcFile) {
            return (GroovyResourceRootDescriptor)context.getProjectDescriptor().getBuildRootIndex().findParentDescriptor(srcFile, CheckResourcesTarget.TARGET_TYPES, context);
        }

        @Override
        protected Set<CheckResourcesTarget> getTargets(ModuleChunk chunk) {
            return Collections.singleton(this.myTarget);
        }
    }
}

