/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependsOnGroupsInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z0-9_\\-\\(\\)]*)\"");
    public JDOMExternalizableStringList groups = new JDOMExternalizableStringList();
    @NonNls
    public static final String SHORT_NAME = "groupsTestNG";

    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection", "getGroupDisplayName"));
        }
        return "TestNG";
    }

    @NotNull
    public String getDisplayName() {
        if ("Groups problem" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection", "getDisplayName"));
        }
        return "Groups problem";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        LabeledComponent definedGroups = new LabeledComponent();
        definedGroups.setText("&Defined Groups");
        final JTextField textField = new JTextField(StringUtil.join((String[])ArrayUtil.toStringArray((Collection)this.groups), (String)","));
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DependsOnGroupsInspection.this.groups.clear();
                Object[] groupsFromString = textField.getText().split("[, ]");
                ContainerUtil.addAll((Collection)DependsOnGroupsInspection.this.groups, (Object[])groupsFromString);
            }
        });
        definedGroups.setComponent((JComponent)textField);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)definedGroups, "North");
        return optionsPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection", "checkClass"));
        }
        if (!psiClass.getContainingFile().isWritable()) {
            return null;
        }
        PsiAnnotation[] annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass);
        if (annotations.length == 0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiExpression initializer;
            PsiElement resolve;
            PsiAnnotationMemberValue value;
            PsiNameValuePair[] params;
            PsiNameValuePair dep = null;
            for (PsiNameValuePair param : params = annotation.getParameterList().getAttributes()) {
                if (param.getName() == null || !param.getName().matches("(groups|dependsOnGroups)")) continue;
                dep = param;
                break;
            }
            if (dep == null || (value = dep.getValue()) == null) continue;
            LOGGER.debug("Found " + dep.getName() + " with: " + value.getText());
            String text = value.getText();
            if (value instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static") && ((PsiField)resolve).hasModifierProperty("final") && (initializer = ((PsiField)resolve).getInitializer()) != null) {
                text = initializer.getText();
            }
            Matcher matcher = PATTERN.matcher(text);
            while (matcher.find()) {
                String methodName = matcher.group(1);
                if (this.groups.contains((Object)methodName)) continue;
                LOGGER.debug("group doesn't exist:" + methodName);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)annotation, "Group '" + methodName + "' is undefined.", (LocalQuickFix)new GroupNameQuickFix(methodName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                problemDescriptors.add(descriptor);
            }
        }
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private class GroupNameQuickFix
    implements LocalQuickFix {
        String myGroupName;

        public GroupNameQuickFix(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix", "<init>"));
            }
            this.myGroupName = groupName;
        }

        @NotNull
        public String getName() {
            String string = "Add '" + this.myGroupName + "' as a defined test group.";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("TestNG" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix", "getFamilyName"));
            }
            return "TestNG";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix", "applyFix"));
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix", "applyFix"));
            }
            DependsOnGroupsInspection.this.groups.add((Object)this.myGroupName);
            InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            InspectionProfileManager.getInstance().fireProfileChanged((InspectionProfile)inspectionProfile);
        }
    }
}

