/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.treeview;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.treeview.IndexTreeView;
import org.sonatype.nexus.index.treeview.TreeNode;
import org.sonatype.nexus.index.treeview.TreeNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexTreeView.class)
public class DefaultIndexTreeView
extends AbstractLogEnabled
implements IndexTreeView {
    @Requirement
    private NexusIndexer nexusIndexer;

    protected NexusIndexer getNexusIndexer() {
        return this.nexusIndexer;
    }

    @Override
    public TreeNode listNodes(TreeNodeFactory factory, String path) throws IOException {
        String name = null;
        if (!"/".equals(path)) {
            name = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            if (!(name = name.substring(name.lastIndexOf(47) + 1, name.length())).equals("/") && name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
        } else {
            name = "/";
        }
        TreeNode result = factory.createGNode(this, path, name);
        if ("/".equals(path)) {
            Set<String> rootGroups = factory.getIndexingContext().getRootGroups();
            for (String group : rootGroups) {
                if (group.length() <= 0) continue;
                result.getChildren().add(factory.createGNode(this, path + group + "/", group));
            }
        } else {
            Set<String> allGroups = factory.getIndexingContext().getAllGroups();
            this.listChildren(result, factory, allGroups);
        }
        return result;
    }

    protected void listChildren(TreeNode root, TreeNodeFactory factory, Set<String> allGroups) throws IOException {
        String path = root.getPath();
        HashMap<String, TreeNode> folders = new HashMap<String, TreeNode>();
        Set<ArtifactInfo> artifacts = this.getArtifacts(path, factory.getIndexingContext());
        for (ArtifactInfo ai : artifacts) {
            String versionKey = (Object)((Object)TreeNode.Type.V) + ":" + ai.artifactId + ":" + ai.version;
            TreeNode versionResource = (TreeNode)folders.get(versionKey);
            if (versionResource == null) {
                String artifactKey = (Object)((Object)TreeNode.Type.A) + ":" + ai.artifactId;
                TreeNode artifactResource = (TreeNode)folders.get(artifactKey);
                if (artifactResource == null) {
                    artifactResource = factory.createANode(this, ai, path + ai.artifactId + "/");
                    root.getChildren().add(artifactResource);
                    folders.put(artifactKey, artifactResource);
                }
                versionResource = factory.createVNode(this, ai, path + ai.artifactId + "/" + ai.version + "/");
                artifactResource.getChildren().add(versionResource);
                folders.put(versionKey, versionResource);
            }
            String nodePath = this.getPathForAi(path, ai);
            versionResource.getChildren().add(factory.createArtifactNode(this, ai, nodePath));
        }
        Set<String> groups = this.getGroups(path, allGroups);
        for (String group : groups) {
            TreeNode groupResource = root.findChildByPath(path + group + "/", TreeNode.Type.G);
            if (groupResource == null) {
                groupResource = factory.createGNode(this, path + group + "/", group);
                root.getChildren().add(groupResource);
                continue;
            }
            this.listChildren(groupResource, factory, allGroups);
        }
    }

    protected String getPathForAi(String path, ArtifactInfo ai) {
        StringBuffer sb = new StringBuffer(path).append(ai.artifactId).append("/").append(ai.version).append("/").append(ai.artifactId).append("-").append(ai.version);
        if (ai.classifier != null) {
            sb.append("-").append(ai.classifier);
        }
        sb.append(".").append(ai.fextension == null ? "jar" : ai.fextension);
        return sb.toString();
    }

    protected Set<String> getGroups(String path, Set<String> allGroups) {
        path = path.substring(1).replace('/', '.');
        int n = path.length();
        HashSet<String> result = new HashSet<String>();
        for (String group : allGroups) {
            if (!group.startsWith(path)) continue;
            int nextDot = (group = group.substring(n)).indexOf(46);
            if (nextDot > -1) {
                group = group.substring(0, nextDot);
            }
            if (group.length() <= 0 || result.contains(group)) continue;
            result.add(group);
        }
        return result;
    }

    protected Set<ArtifactInfo> getArtifacts(String path, IndexingContext indexingContext) throws IOException {
        Set<ArtifactInfo> result = null;
        String g = null;
        String a = null;
        String v = null;
        String wp = null;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!(result = this.getArtifactsByG(g = (wp = path).substring(1).replace('/', '.'), indexingContext)).isEmpty()) {
            return result;
        }
        if (path.lastIndexOf("/") > 0) {
            wp = path;
            a = wp.substring(wp.lastIndexOf("/") + 1, wp.length());
            g = wp.substring(1, wp.lastIndexOf("/")).replace('/', '.');
            result = this.getArtifactsByGA(g, a, indexingContext);
            if (!result.isEmpty()) {
                return result;
            }
            try {
                wp = path;
                v = wp.substring(wp.lastIndexOf("/") + 1, wp.length());
                wp = wp.substring(0, wp.lastIndexOf("/"));
                a = wp.substring(wp.lastIndexOf("/") + 1, wp.length());
                g = wp.substring(1, wp.lastIndexOf("/")).replace('/', '.');
                result = this.getArtifactsByGAV(g, a, v, indexingContext);
                if (!result.isEmpty()) {
                    return result;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return Collections.emptySet();
    }

    protected Set<ArtifactInfo> getArtifactsByG(String g, IndexingContext indexingContext) throws IOException {
        TermQuery q = new TermQuery(new Term("g", g));
        FlatSearchRequest searchRequest = new FlatSearchRequest((Query)q, indexingContext);
        FlatSearchResponse searchResponse = this.getNexusIndexer().searchFlat(searchRequest);
        return searchResponse.getResults();
    }

    protected Set<ArtifactInfo> getArtifactsByGA(String g, String a, IndexingContext indexingContext) throws IOException {
        BooleanQuery q = new BooleanQuery();
        q.add((Query)new TermQuery(new Term("g", g)), BooleanClause.Occur.MUST);
        q.add((Query)new TermQuery(new Term("a", a)), BooleanClause.Occur.MUST);
        FlatSearchRequest searchRequest = new FlatSearchRequest((Query)q, indexingContext);
        FlatSearchResponse searchResponse = this.getNexusIndexer().searchFlat(searchRequest);
        return searchResponse.getResults();
    }

    protected Set<ArtifactInfo> getArtifactsByGAV(String g, String a, String v, IndexingContext indexingContext) throws IOException {
        BooleanQuery q = new BooleanQuery();
        q.add((Query)new TermQuery(new Term("g", g)), BooleanClause.Occur.MUST);
        q.add((Query)new TermQuery(new Term("a", a)), BooleanClause.Occur.MUST);
        q.add((Query)new TermQuery(new Term("v", v)), BooleanClause.Occur.MUST);
        FlatSearchRequest searchRequest = new FlatSearchRequest((Query)q, indexingContext);
        FlatSearchResponse searchResponse = this.getNexusIndexer().searchFlat(searchRequest);
        return searchResponse.getResults();
    }
}

