/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgAbstractGlobalSingleRepoAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgTagCreateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgTagDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCreateTagAction
extends HgAbstractGlobalSingleRepoAction {
    public void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo, @Nullable String reference) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgCreateTagAction", "execute"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/action/HgCreateTagAction", "execute"));
        }
        final HgTagDialog dialog = new HgTagDialog(project, repositories, selectedRepo);
        if (dialog.showAndGet()) {
            try {
                new HgTagCreateCommand(project, dialog.getRepository(), dialog.getTagName(), reference).executeAsynchronously(new HgCommandResultHandler(){

                    @Override
                    public void process(@Nullable HgCommandResult result) {
                        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                            new HgCommandResultNotifier(project).notifyError(result, "Creation failed", "Tag creation [" + dialog.getTagName() + "] failed");
                        }
                    }
                });
            }
            catch (HgCommandException e) {
                HgErrorUtil.handleException(project, e);
            }
        }
    }

    @Override
    protected void execute(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/action/HgCreateTagAction", "execute"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/action/HgCreateTagAction", "execute"));
        }
        this.execute(project, repositories, selectedRepo, null);
    }
}

