/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLValueImpl;

public class YAMLCompoundValueImpl
extends YAMLValueImpl
implements YAMLCompoundValue {
    public YAMLCompoundValueImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLCompoundValueImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public String toString() {
        return "YAML compound value";
    }

    @Override
    @NotNull
    public String getTextValue() {
        PsiElement element;
        PsiElement psiElement = element = this.getTag() != null ? this.getTag().getNextSibling() : this.getFirstChild();
        while (element != null && !(element instanceof YAMLScalar)) {
            element = element.getNextSibling();
        }
        if (element != null) {
            String string = ((YAMLScalar)element).getTextValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLCompoundValueImpl", "getTextValue"));
            }
            return string;
        }
        String string = "<compoundValue:" + Integer.toHexString(this.getText().hashCode()) + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLCompoundValueImpl", "getTextValue"));
        }
        return string;
    }
}

