/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFix
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        String name = this.getClass().getSimpleName();
        String string = "XSLT " + name.replaceAll("Fix$", "").replaceAll("(\\p{Lower}+)(\\p{Upper})", "$1 $2");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/AbstractFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected static void moveTo(Editor editor, XmlTag xmlTag) {
        editor.getCaretModel().moveToOffset(xmlTag.getTextRange().getStartOffset());
    }

    protected static void deleteFromDocument(Editor editor, PsiElement dummy) {
        editor.getDocument().deleteString(dummy.getTextRange().getStartOffset(), dummy.getTextRange().getEndOffset());
    }

    protected static TemplateBuilderImpl createTemplateBuilder(XmlTag xmlTag) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)xmlTag.getProject()).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)xmlTag.getText(), LocalTimeCounter.currentTime(), true, false);
        return new TemplateBuilderImpl((PsiElement)psiFile);
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/AbstractFix", "isAvailable"));
        }
        if (this.requiresEditor() && editor == null) {
            return false;
        }
        return this.isAvailableImpl(project, editor, file);
    }

    protected abstract boolean isAvailableImpl(@NotNull Project var1, @Nullable Editor var2, PsiFile var3);

    protected abstract boolean requiresEditor();

    @Nullable
    public LocalQuickFix createQuickFix(boolean isOnTheFly) {
        final boolean requiresEditor = this.requiresEditor();
        if (requiresEditor && !isOnTheFly) {
            return null;
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = AbstractFix.this.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = AbstractFix.this.getFamilyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiFile psiFile;
                Editor editor;
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1", "applyFix"));
                }
                if (requiresEditor) {
                    DataContext dataContext = DataManager.getInstance().getDataContext();
                    editor = (Editor)LangDataKeys.EDITOR.getData(dataContext);
                    if (editor == null && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                        return;
                    }
                } else {
                    editor = null;
                }
                if (!AbstractFix.this.isAvailable(project, editor, psiFile = descriptor.getPsiElement().getContainingFile())) {
                    return;
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                    return;
                }
                try {
                    AbstractFix.this.invoke(project, editor, psiFile);
                }
                catch (IncorrectOperationException e) {
                    Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
                }
            }
        };
    }

    public static LocalQuickFix[] createFixes(LocalQuickFix ... fixes) {
        List result = ContainerUtil.findAll((Object[])fixes, localQuickFix -> localQuickFix != null);
        return result.toArray(new LocalQuickFix[result.size()]);
    }
}

