/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import javax.swing.JComponent;
import org.intellij.lang.xpath.xslt.associations.impl.AssociationsEditor;
import org.jetbrains.annotations.NotNull;

public class FileAssociationsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private final UIState myState;
    private AssociationsEditor myEditor;

    public FileAssociationsConfigurable(Project project) {
        this.myProject = project;
        this.myState = (UIState)ServiceManager.getService((Project)project, UIState.class);
    }

    public String getDisplayName() {
        return "XSLT File Associations";
    }

    @NotNull
    public String getHelpTopic() {
        if ("xslt.associations" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/FileAssociationsConfigurable", "getHelpTopic"));
        }
        return "xslt.associations";
    }

    public JComponent createComponent() {
        this.myEditor = (AssociationsEditor)new ReadAction<AssociationsEditor>(){

            protected void run(@NotNull Result<AssociationsEditor> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/xslt/associations/impl/FileAssociationsConfigurable$1", "run"));
                }
                result.setResult((Object)new AssociationsEditor(FileAssociationsConfigurable.this.myProject, FileAssociationsConfigurable.this.myState.state));
            }
        }.execute().getResultObject();
        return this.myEditor.getComponent();
    }

    public synchronized boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myEditor.apply();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public void reset() {
        this.myEditor.reset();
    }

    public synchronized void disposeUIResources() {
        if (this.myEditor != null) {
            this.myState.state = this.myEditor.getState();
            this.myEditor.dispose();
            this.myEditor = null;
        }
    }

    public AssociationsEditor getEditor() {
        return this.myEditor;
    }

    public static void editAssociations(Project project, PsiFile file) {
        FileAssociationsConfigurable instance = new FileAssociationsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)instance, () -> {
            AssociationsEditor editor = instance.getEditor();
            if (file != null) {
                editor.select(file);
            }
        });
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/FileAssociationsConfigurable", "getId"));
        }
        return string;
    }

    @State(name="XSLT-Support.FileAssociations.UIState", storages={@Storage(value="$WORKSPACE_FILE$")})
    public static class UIState
    implements PersistentStateComponent<TreeState> {
        private TreeState state;

        public TreeState getState() {
            return this.state != null ? this.state : new TreeState();
        }

        public void loadState(TreeState state) {
            this.state = state;
        }
    }
}

