/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import java.util.EnumSet;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbNodesStrictOpDepth;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNWCDbDeleteActualForBaseRecursive
extends SVNSqlJetDeleteStatement {
    private SVNWCDbNodesStrictOpDepth strictOpDepthSelect;
    private SelectFromNodesForPresence selectFromNodesForPresence;

    public SVNWCDbDeleteActualForBaseRecursive(SVNSqlJetDb sDb) throws SVNException {
        super(sDb, SVNWCDbSchema.ACTUAL_NODE);
        this.strictOpDepthSelect = new SVNWCDbNodesStrictOpDepth(sDb, 0L);
        this.selectFromNodesForPresence = new SelectFromNodesForPresence(sDb, 1L, EnumSet.of(ISVNWCDb.SVNWCDbStatus.Normal, ISVNWCDb.SVNWCDbStatus.Incomplete, ISVNWCDb.SVNWCDbStatus.NotPresent));
    }

    @Override
    protected Object[] getWhere() throws SVNException {
        return new Object[]{this.getBind(1)};
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        return this.strictOpDepthSelect.existsOpDepth((Long)this.getBind(1), this.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath)) && !this.selectFromNodesForPresence.existsOpDepth((Long)this.getBind(1), this.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath));
    }

    @Override
    protected String getPathScope() {
        return this.getBind(2).toString();
    }

    @Override
    protected boolean isStrictiDescendant() {
        return true;
    }

    private static class SelectFromNodesForPresence
    extends SVNSqlJetSelectStatement {
        private long minOpDepth;
        private EnumSet<ISVNWCDb.SVNWCDbStatus> presence;

        public SelectFromNodesForPresence(SVNSqlJetDb sDb, long minOpDepth, EnumSet<ISVNWCDb.SVNWCDbStatus> presence) throws SVNException {
            super(sDb, SVNWCDbSchema.NODES);
            this.minOpDepth = minOpDepth;
            this.presence = presence;
        }

        @Override
        protected boolean isFilterPassed() throws SVNException {
            return this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) >= this.minOpDepth && this.presence.contains((Object)SvnWcDbStatementUtil.getColumnPresence(this, SVNWCDbSchema.NODES__Fields.presence));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean existsOpDepth(Long wcId, String localRelpath) throws SVNException {
            try {
                this.bindLong(1, wcId);
                this.bindString(2, localRelpath);
                boolean bl = this.next();
                return bl;
            }
            finally {
                this.reset();
            }
        }
    }
}

