/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_e6e56f0.core.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jacoco.agent.rt.internal_e6e56f0.core.data.ExecutionData;
import org.jacoco.agent.rt.internal_e6e56f0.core.data.IExecutionDataVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionDataStore
implements IExecutionDataVisitor {
    private final Map<Long, ExecutionData> entries = new HashMap<Long, ExecutionData>();
    private final Set<String> names = new HashSet<String>();

    public void put(ExecutionData data) throws IllegalStateException {
        Long id = data.getId();
        ExecutionData entry = this.entries.get(id);
        if (entry == null) {
            this.entries.put(id, data);
            this.names.add(data.getName());
        } else {
            entry.merge(data);
        }
    }

    public void subtract(ExecutionData data) throws IllegalStateException {
        Long id = data.getId();
        ExecutionData entry = this.entries.get(id);
        if (entry != null) {
            entry.merge(data, false);
        }
    }

    public void subtract(ExecutionDataStore store) {
        for (ExecutionData data : store.getContents()) {
            this.subtract(data);
        }
    }

    public ExecutionData get(long id) {
        return this.entries.get(id);
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public ExecutionData get(Long id, String name, int probecount) {
        ExecutionData entry = this.entries.get(id);
        if (entry == null) {
            entry = new ExecutionData((long)id, name, probecount);
            this.entries.put(id, entry);
            this.names.add(name);
        } else {
            entry.assertCompatibility(id, name, probecount);
        }
        return entry;
    }

    public void reset() {
        for (ExecutionData executionData : this.entries.values()) {
            executionData.reset();
        }
    }

    public Collection<ExecutionData> getContents() {
        return this.entries.values();
    }

    public void accept(IExecutionDataVisitor visitor) {
        for (ExecutionData data : this.entries.values()) {
            visitor.visitClassExecution(data);
        }
    }

    @Override
    public void visitClassExecution(ExecutionData data) {
        this.put(data);
    }
}

