/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.intentions.conversions.strings.ConvertGStringToStringIntention;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.arithmetic.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrPropertySelection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrRangeType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.AnonymousFromMapGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ArgumentListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassItemGeneratorImpl;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClosureGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationSettings;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.Generator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.invocators.CustomMethodInvocator;

public class ExpressionGenerator
extends Generator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator");
    private final StringBuilder builder;
    private final GroovyPsiElementFactory factory;
    private final ExpressionContext context;

    public ExpressionGenerator(StringBuilder builder, ExpressionContext context) {
        this.builder = builder;
        this.context = context;
        this.factory = GroovyPsiElementFactory.getInstance(context.project);
    }

    public ExpressionGenerator(ExpressionContext context) {
        this.builder = new StringBuilder();
        this.context = context;
        this.factory = GroovyPsiElementFactory.getInstance(context.project);
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public ExpressionContext getContext() {
        return this.context;
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitClosure"));
        }
        new ClosureGenerator(this.builder, this.context).generate(closure);
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitExpression"));
        }
        LOG.error("this method should not be invoked");
    }

    @Override
    public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitMethodCallExpression"));
        }
        this.generateMethodCall(methodCallExpression);
    }

    private void generateMethodCall(GrMethodCall methodCallExpression) {
        GrExpression invoked = methodCallExpression.getInvokedExpression();
        GrExpression[] exprs = methodCallExpression.getExpressionArguments();
        GrNamedArgument[] namedArgs = methodCallExpression.getNamedArguments();
        GrClosableBlock[] clArgs = methodCallExpression.getClosureArguments();
        if (invoked instanceof GrReferenceExpression) {
            GroovyResolveResult resolveResult = ((GrReferenceExpression)invoked).advancedResolve();
            PsiElement resolved = resolveResult.getElement();
            if (resolved instanceof PsiMethod) {
                GrExpression qualifier = (GrExpression)((GrReferenceExpression)invoked).getQualifier();
                this.invokeMethodOn((PsiMethod)resolved, qualifier, exprs, namedArgs, clArgs, resolveResult.getSubstitutor(), methodCallExpression);
                return;
            }
            if (resolved == null) {
                GrExpression qualifier = (GrExpression)((GrReferenceExpression)invoked).getQualifier();
                GrExpression[] args = this.generateArgsForInvokeMethod(((GrReferenceExpression)invoked).getReferenceName(), exprs, namedArgs, clArgs, methodCallExpression);
                GenerationUtil.invokeMethodByName(qualifier, "invokeMethod", args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, this, methodCallExpression);
                return;
            }
        }
        GenerationUtil.invokeMethodByName(invoked, "call", exprs, namedArgs, clArgs, this, methodCallExpression);
    }

    private GrExpression[] generateArgsForInvokeMethod(String name, GrExpression[] exprs, GrNamedArgument[] namedArgs, GrClosableBlock[] clArgs, GroovyPsiElement psiContext) {
        GrExpression[] result = new GrExpression[2];
        result[0] = this.factory.createExpressionFromText("\"" + name + "\"");
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (namedArgs.length > 0) {
            builder.append('[');
            for (GroovyPsiElement groovyPsiElement : namedArgs) {
                builder.append(groovyPsiElement.getText()).append(',');
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append("],");
        }
        for (GroovyPsiElement groovyPsiElement : exprs) {
            builder.append(groovyPsiElement.getText()).append(',');
        }
        for (GroovyPsiElement groovyPsiElement : clArgs) {
            builder.append(groovyPsiElement.getText()).append(',');
        }
        if (namedArgs.length + exprs.length + clArgs.length > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("] as Object[]");
        result[1] = this.factory.createExpressionFromText(builder.toString(), psiContext);
        return result;
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        GrAnonymousClassDefinition anonymous;
        String varName;
        StringBuilder builder;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitNewExpression"));
        }
        boolean hasFieldInitialization = ExpressionGenerator.hasFieldInitialization(newExpression);
        PsiType type = newExpression.getType();
        if (hasFieldInitialization) {
            builder = new StringBuilder();
            varName = GenerationUtil.suggestVarName(type, newExpression, this.context);
            TypeWriter.writeType(builder, type, newExpression);
            builder.append(' ').append(varName).append(" = ");
        } else {
            varName = null;
            builder = this.builder;
        }
        GrTypeElement typeElement = newExpression.getTypeElement();
        GrArrayDeclaration arrayDeclaration = newExpression.getArrayDeclaration();
        GrCodeReferenceElement referenceElement = newExpression.getReferenceElement();
        builder.append("new ");
        if (typeElement != null) {
            PsiType builtIn = typeElement.getType();
            LOG.assertTrue(builtIn instanceof PsiPrimitiveType);
            PsiType boxed = TypesUtil.boxPrimitiveType(builtIn, newExpression.getManager(), newExpression.getResolveScope());
            TypeWriter.writeTypeForNew(builder, boxed, newExpression);
        } else if (referenceElement != null) {
            GenerationUtil.writeCodeReferenceElement(builder, referenceElement);
        }
        GrArgumentList argList = newExpression.getArgumentList();
        if (argList != null) {
            GroovyResolveResult clazzResult;
            PsiElement clazz;
            GrClosureSignature signature = null;
            GroovyResolveResult resolveResult = newExpression.advancedResolve();
            PsiElement constructor = resolveResult.getElement();
            if (constructor instanceof PsiMethod) {
                signature = GrClosureSignatureUtil.createSignature((PsiMethod)constructor, resolveResult.getSubstitutor());
            } else if (referenceElement != null && (clazz = (clazzResult = referenceElement.advancedResolve()).getElement()) instanceof PsiClass && ((PsiClass)clazz).getConstructors().length == 0) {
                signature = GrClosureSignatureUtil.createSignature(PsiParameter.EMPTY_ARRAY, null);
            }
            GrNamedArgument[] namedArgs = hasFieldInitialization ? GrNamedArgument.EMPTY_ARRAY : argList.getNamedArguments();
            new ArgumentListGenerator(builder, this.context).generate(signature, argList.getExpressionArguments(), namedArgs, GrClosableBlock.EMPTY_ARRAY, newExpression);
        }
        if ((anonymous = newExpression.getAnonymousClassDefinition()) != null) {
            this.writeTypeBody(builder, anonymous);
        }
        if (arrayDeclaration != null) {
            GrExpression[] boundExpressions = arrayDeclaration.getBoundExpressions();
            for (GrExpression grExpression : boundExpressions) {
                builder.append('[');
                grExpression.accept(this);
                builder.append(']');
            }
            if (boundExpressions.length == 0) {
                builder.append("[]");
            }
        }
        if (hasFieldInitialization) {
            builder.append(';');
            this.context.myStatements.add(builder.toString());
            GrNamedArgument[] namedArguments = argList.getNamedArguments();
            for (GroovyPsiElement groovyPsiElement : namedArguments) {
                String fieldName = groovyPsiElement.getLabelName();
                if (fieldName == null) {
                    GrArgumentLabel label = groovyPsiElement.getLabel();
                    LOG.info("cannot initialize field " + (label == null ? "<null>" : label.getText()));
                    continue;
                }
                GroovyResolveResult resolveResult = referenceElement.advancedResolve();
                PsiElement resolved = resolveResult.getElement();
                LOG.assertTrue(resolved instanceof PsiClass);
                this.initializeField(varName, type, (PsiClass)resolved, resolveResult.getSubstitutor(), fieldName, groovyPsiElement.getExpression());
            }
        }
    }

    private void initializeField(String varName, PsiType type, PsiClass resolved, PsiSubstitutor substitutor, String fieldName, GrExpression expression) {
        StringBuilder builder = new StringBuilder();
        PsiMethod setter = GroovyPropertyUtils.findPropertySetter(resolved, fieldName, false, true);
        if (setter != null) {
            GrVariableDeclaration var = this.factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, "", type, varName);
            GrReferenceExpression caller = this.factory.createReferenceExpressionFromText(varName, var);
            this.invokeMethodOn(setter, caller, new GrExpression[]{expression}, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, substitutor, expression);
        } else {
            builder.append(varName).append('.').append(fieldName).append(" = ");
            expression.accept(new ExpressionGenerator(builder, this.context));
        }
        this.context.myStatements.add(builder.toString());
    }

    public String toString() {
        return this.builder.toString();
    }

    private static boolean hasFieldInitialization(GrNewExpression newExpression) {
        GrArgumentList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        if (argumentList.getNamedArguments().length == 0) {
            return false;
        }
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement == null) {
            return false;
        }
        GroovyResolveResult resolveResult = newExpression.advancedResolve();
        PsiElement constructor = resolveResult.getElement();
        if (constructor instanceof PsiMethod) {
            return ((PsiMethod)constructor).getParameterList().getParametersCount() == 0;
        }
        PsiElement resolved = refElement.resolve();
        return resolved instanceof PsiClass;
    }

    private void writeTypeBody(StringBuilder builder, GrAnonymousClassDefinition anonymous) {
        builder.append("{\n");
        GeneratorClassNameProvider classNameProvider = new GeneratorClassNameProvider();
        ClassItemGeneratorImpl classItemGenerator = new ClassItemGeneratorImpl(this.context.extend());
        new ClassGenerator(classNameProvider, classItemGenerator).writeMembers(builder, anonymous);
        builder.append('}');
    }

    @Override
    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
        if (applicationStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationStatement", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitApplicationStatement"));
        }
        this.generateMethodCall(applicationStatement);
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitConditionalExpression"));
        }
        GrExpression condition = expression.getCondition();
        GrExpression thenBranch = expression.getThenBranch();
        GrExpression elseBranch = expression.getElseBranch();
        boolean elvis = expression instanceof GrElvisExpression;
        String var = elvis ? this.createVarByInitializer(condition) : null;
        PsiType type = condition.getType();
        if (type == null || PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(type))) {
            if (elvis) {
                this.builder.append(var);
            } else {
                condition.accept(this);
            }
        } else {
            GroovyResolveResult[] results = ResolveUtil.getMethodCandidates(type, "asBoolean", (PsiElement)expression, PsiType.EMPTY_ARRAY);
            GroovyResolveResult result = PsiImplUtil.extractUniqueResult(results);
            GenerationUtil.invokeMethodByResolveResult(elvis ? this.factory.createReferenceExpressionFromText(var, expression) : condition, result, "asBoolean", GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, this, expression);
        }
        this.builder.append('?');
        if (thenBranch != null) {
            if (elvis) {
                this.builder.append(var);
            } else {
                thenBranch.accept(this);
            }
        }
        this.builder.append(':');
        if (elseBranch != null) {
            elseBranch.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(final @NotNull GrAssignmentExpression expression) {
        GroovyResolveResult result;
        PsiElement resolved;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitAssignmentExpression"));
        }
        final GrExpression lValue = expression.getLValue();
        final GrExpression rValue = expression.getRValue();
        IElementType token = expression.getOperationTokenType();
        PsiElement realLValue = PsiUtil.skipParentheses(lValue, false);
        if (realLValue instanceof GrReferenceExpression && rValue != null) {
            GroovyResolveResult resolveResult = ((GrReferenceExpression)realLValue).advancedResolve();
            resolved = resolveResult.getElement();
            if (resolved instanceof GrVariable && this.context.analyzedVars.toWrap((GrVariable)resolved)) {
                this.writeAssignmentWithRefSetter((GrExpression)realLValue, expression);
                return;
            }
            if (resolved instanceof PsiMethod && resolveResult.isInvokedOnProperty()) {
                this.writeAssignmentWithSetter((GrExpression)((GrReferenceExpression)realLValue).getQualifier(), (PsiMethod)resolved, expression);
                return;
            }
            if (resolved == null || resolved instanceof GrBindingVariable) {
                GrExpression qualifier = (GrExpression)((GrReferenceExpression)realLValue).getQualifier();
                PsiType type = PsiImplUtil.getQualifierType((GrReferenceExpression)realLValue);
                GrExpression[] args = new GrExpression[]{this.factory.createExpressionFromText("\"" + ((GrReferenceExpression)realLValue).getReferenceName() + "\""), this.getRValue(expression)};
                GroovyResolveResult[] candidates = type != null ? ResolveUtil.getMethodCandidates(type, "setProperty", (PsiElement)expression, args[0].getType(), args[1].getType()) : GroovyResolveResult.EMPTY_ARRAY;
                PsiMethod method = PsiImplUtil.extractUniqueElement(candidates);
                if (method != null) {
                    this.writeAssignmentWithSetter(qualifier, method, args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, PsiSubstitutor.EMPTY, expression);
                    return;
                }
            }
        } else if (realLValue instanceof GrIndexProperty && (resolved = (result = PsiImplUtil.extractUniqueResult(((GrIndexProperty)realLValue).multiResolve(false))).getElement()) instanceof PsiMethod) {
            Object[] args = ((GrIndexProperty)realLValue).getArgumentList().getExpressionArguments();
            this.writeAssignmentWithSetter(((GrIndexProperty)realLValue).getInvokedExpression(), (PsiMethod)resolved, (GrExpression[])ArrayUtil.append((Object[])args, (Object)this.getRValue(expression)), GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, result.getSubstitutor(), expression);
            return;
        }
        PsiType lType = GenerationUtil.getDeclaredType(lValue, this.context);
        if (token == GroovyTokenTypes.mASSIGN) {
            lValue.accept(this);
            this.builder.append(" = ");
            if (rValue != null) {
                PsiType rType = GenerationUtil.getDeclaredType(rValue, this.context);
                GenerationUtil.wrapInCastIfNeeded(this.builder, GenerationUtil.getNotNullType(expression, lType), rType, expression, this.context, new StatementWriter(){

                    @Override
                    public void writeStatement(StringBuilder builder, ExpressionContext context) {
                        rValue.accept(ExpressionGenerator.this);
                    }
                });
            }
        } else {
            final GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(expression.multiResolve(false));
            final PsiElement resolved2 = resolveResult.getElement();
            if (resolved2 instanceof PsiMethod && !ExpressionGenerator.shouldNotReplaceOperatorWithMethod(lValue.getType(), rValue, expression.getOperationTokenType())) {
                lValue.accept(this);
                this.builder.append(" = ");
                PsiType rType = GenerationUtil.getDeclaredType((PsiMethod)resolved2, resolveResult.getSubstitutor(), this.context);
                GenerationUtil.wrapInCastIfNeeded(this.builder, GenerationUtil.getNotNullType(expression, lType), rType, expression, this.context, new StatementWriter(){

                    @Override
                    public void writeStatement(StringBuilder builder, ExpressionContext context) {
                        GrExpression[] grExpressionArray;
                        PsiMethod psiMethod = (PsiMethod)resolved2;
                        GrExpression grExpression = (GrExpression)lValue.copy();
                        if (rValue == null) {
                            grExpressionArray = GrExpression.EMPTY_ARRAY;
                        } else {
                            GrExpression[] grExpressionArray2 = new GrExpression[1];
                            grExpressionArray = grExpressionArray2;
                            grExpressionArray2[0] = rValue;
                        }
                        ExpressionGenerator.this.invokeMethodOn(psiMethod, grExpression, grExpressionArray, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), expression);
                    }
                });
            } else {
                this.writeSimpleBinaryExpression(expression.getOperationToken(), lValue, rValue);
            }
        }
    }

    private void writeAssignmentWithRefSetter(GrExpression ref, GrAssignmentExpression expression) {
        GrExpression rValue = this.getRValue(expression);
        if (PsiUtil.isExpressionUsed(expression)) {
            LOG.assertTrue(this.context.getRefSetterName(expression) != null);
            this.builder.append(this.context.getRefSetterName(expression)).append('(');
            ref.accept(this);
            this.builder.append(", ");
            if (rValue != null) {
                rValue.accept(this);
            }
            this.builder.append(')');
        } else {
            ref.accept(this);
            this.builder.append(".set(");
            if (rValue != null) {
                rValue.accept(this);
            }
            this.builder.append(')');
        }
    }

    @Nullable
    private GrExpression getRValue(GrAssignmentExpression expression) {
        GrExpression rValue = expression.getRValue();
        if (rValue == null) {
            return null;
        }
        GrExpression lValue = expression.getLValue();
        IElementType opToken = expression.getOperationTokenType();
        if (opToken == GroovyTokenTypes.mASSIGN) {
            return rValue;
        }
        Pair<String, IElementType> pair = GenerationUtil.getBinaryOperatorType(opToken);
        LOG.assertTrue(pair != null);
        return this.factory.createExpressionFromText(lValue.getText() + (String)pair.getFirst() + rValue.getText(), expression);
    }

    private void writeAssignmentWithSetter(GrExpression qualifier, PsiMethod setter, GrAssignmentExpression assignment) {
        GrExpression rValue = this.getRValue(assignment);
        LOG.assertTrue(rValue != null);
        this.writeAssignmentWithSetter(qualifier, setter, new GrExpression[]{rValue}, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, PsiSubstitutor.EMPTY, assignment);
    }

    private void writeAssignmentWithSetter(@Nullable GrExpression qualifier, @NotNull PsiMethod method, @NotNull GrExpression[] exprs, @NotNull GrNamedArgument[] namedArgs, @NotNull GrClosableBlock[] closures, @NotNull PsiSubstitutor substitutor, @NotNull GrAssignmentExpression assignment) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeAssignmentWithSetter"));
        }
        if (exprs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprs", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeAssignmentWithSetter"));
        }
        if (namedArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgs", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeAssignmentWithSetter"));
        }
        if (closures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closures", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeAssignmentWithSetter"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeAssignmentWithSetter"));
        }
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeAssignmentWithSetter"));
        }
        if (PsiUtil.isExpressionUsed(assignment)) {
            GrExpression rValue = assignment.getRValue();
            if (PsiUtil.isExpressionStatement(assignment) && PsiUtil.isReturnStatement(assignment) && rValue != null && ExpressionGenerator.isVarAccess(rValue)) {
                StringBuilder assignmentBuffer = new StringBuilder();
                new ExpressionGenerator(assignmentBuffer, this.context).invokeMethodOn(method, qualifier, exprs, namedArgs, closures, substitutor, assignment);
                assignmentBuffer.append(';');
                this.context.myStatements.add(assignmentBuffer.toString());
                rValue.accept(this);
            } else {
                GrExpression[] args;
                String setterName = this.context.getSetterName(method, assignment);
                if (method.hasModifierProperty("static")) {
                    args = exprs;
                } else {
                    args = new GrExpression[exprs.length + 1];
                    if (qualifier == null) {
                        qualifier = this.factory.createExpressionFromText("this", assignment);
                    }
                    args[0] = qualifier;
                    System.arraycopy(exprs, 0, args, 1, exprs.length);
                }
                GenerationUtil.invokeMethodByName(null, setterName, args, namedArgs, closures, this, assignment);
            }
        } else {
            this.invokeMethodOn(method, qualifier, exprs, namedArgs, closures, substitutor, assignment);
        }
    }

    private static boolean isVarAccess(@Nullable GrExpression expr) {
        PsiElement resolved;
        return expr instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expr).resolve()) instanceof PsiVariable;
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitBinaryExpression"));
        }
        GrExpression left = expression.getLeftOperand();
        GrExpression right = expression.getRightOperand();
        PsiType ltype = left.getType();
        PsiElement token = expression.getOperationToken();
        IElementType op = expression.getOperationTokenType();
        if (op == GroovyTokenTypes.mREGEX_FIND) {
            this.builder.append("java.util.regex.Pattern").append(".compile(");
            if (right != null) {
                right.accept(this);
            }
            this.builder.append(").matcher(");
            left.accept(this);
            this.builder.append(')');
            return;
        }
        if (op == GroovyTokenTypes.mREGEX_MATCH) {
            this.builder.append("java.util.regex.Pattern").append(".matches(");
            if (right != null) {
                right.accept(this);
            }
            this.builder.append(", ");
            left.accept(this);
            this.builder.append(')');
            return;
        }
        if ((op == GroovyTokenTypes.mEQUAL || op == GroovyTokenTypes.mNOT_EQUAL) && (GrInspectionUtil.isNull(left) || right != null && GrInspectionUtil.isNull(right))) {
            this.writeSimpleBinaryExpression(token, left, right);
            return;
        }
        if (op == GroovyTokenTypes.kIN && right instanceof GrReferenceExpression && InheritanceUtil.isInheritor((PsiType)right.getType(), (String)"java.lang.Class")) {
            PsiType type = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)right.getType(), (String)"java.lang.Class", (int)0, (boolean)true);
            this.writeInstanceof(left, type, expression);
            return;
        }
        if (ExpressionGenerator.shouldNotReplaceOperatorWithMethod(ltype, right, op)) {
            this.writeSimpleBinaryExpression(token, left, right);
            return;
        }
        GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(expression.multiResolve(false));
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiMethod) {
            if (right == null) {
                right = this.factory.createExpressionFromText("null");
            }
            if (op == GroovyTokenTypes.mNOT_EQUAL && "equals".equals(((PsiMethod)resolved).getName())) {
                this.builder.append('!');
            }
            this.invokeMethodOn((PsiMethod)resolved, left, new GrExpression[]{right}, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), expression);
            if (op == GroovyTokenTypes.mGE) {
                this.builder.append(" >= 0");
            } else if (op == GroovyTokenTypes.mGT) {
                this.builder.append(" > 0");
            } else if (op == GroovyTokenTypes.mLT) {
                this.builder.append(" < 0");
            } else if (op == GroovyTokenTypes.mLE) {
                this.builder.append(" <= 0");
            }
        } else {
            this.writeSimpleBinaryExpression(token, left, right);
        }
    }

    private static boolean shouldNotReplaceOperatorWithMethod(@Nullable PsiType ltype, @Nullable GrExpression right, IElementType op) {
        if (!GenerationSettings.replaceOperatorsWithMethodsForNumbers) {
            if ((op == GroovyTokenTypes.mPLUS || op == GroovyTokenTypes.mPLUS_ASSIGN) && ltype != null && TypesUtil.isClassType(ltype, "java.lang.String")) {
                return true;
            }
            if (TypesUtil.isNumericType(ltype) && (right == null || TypesUtil.isNumericType(right.getType()))) {
                return true;
            }
        }
        return op == GroovyTokenTypes.mLNOT && ExpressionGenerator.isBooleanType(ltype);
    }

    private static boolean isBooleanType(PsiType type) {
        return PsiType.BOOLEAN.equals((Object)type) || type != null && type.equalsToText("java.lang.Boolean");
    }

    private void writeSimpleBinaryExpression(PsiElement opToken, GrExpression left, GrExpression right) {
        left.accept(this);
        this.builder.append(' ');
        this.builder.append(opToken.getText());
        if (right != null) {
            this.builder.append(' ');
            right.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitUnaryExpression"));
        }
        boolean postfix = expression.isPostfix();
        GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(expression.multiResolve(false));
        PsiElement resolved = resolveResult.getElement();
        GrExpression operand = expression.getOperand();
        IElementType opType = expression.getOperationTokenType();
        if (resolved instanceof PsiMethod) {
            if ((opType == GroovyTokenTypes.mINC || opType == GroovyTokenTypes.mDEC) && (!postfix || expression.getParent() instanceof GrStatementOwner || expression.getParent() instanceof GrControlStatement) && this.generatePrefixIncDec((PsiMethod)resolved, operand, expression)) {
                return;
            }
            if (operand != null && ExpressionGenerator.shouldNotReplaceOperatorWithMethod(operand.getType(), null, expression.getOperationTokenType())) {
                ExpressionGenerator.writeSimpleUnary(operand, expression, this);
            } else {
                if (opType == GroovyTokenTypes.mLNOT) {
                    this.builder.append('!');
                }
                this.invokeMethodOn((PsiMethod)resolved, operand, GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), expression);
            }
        } else if (operand != null) {
            if (postfix) {
                operand.accept(this);
                this.builder.append(expression.getOperationToken().getText());
            } else {
                this.builder.append(expression.getOperationToken().getText());
                operand.accept(this);
            }
        }
    }

    private boolean generatePrefixIncDec(PsiMethod method, GrExpression operand, GrUnaryExpression unary) {
        if (!(operand instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)operand).getQualifier();
        GroovyResolveResult resolveResult = ((GrReferenceExpression)operand).advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)resolved)) {
            PsiType type;
            PsiMethod getter = (PsiMethod)resolved;
            String propertyName = GroovyPropertyUtils.getPropertyNameByGetter(getter);
            if (qualifier == null) {
                type = null;
            } else {
                type = qualifier.getType();
                if (type == null) {
                    return false;
                }
            }
            PsiMethod setter = GroovyPropertyUtils.findPropertySetter(type, propertyName, unary);
            if (setter == null) {
                return false;
            }
            ExpressionGenerator generator = new ExpressionGenerator(new StringBuilder(), this.context);
            if (ExpressionGenerator.shouldNotReplaceOperatorWithMethod(operand.getType(), null, unary.getOperationTokenType())) {
                ExpressionGenerator.writeSimpleUnary(operand, unary, generator);
            } else {
                generator.invokeMethodOn(method, operand, GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), unary);
            }
            GrExpression fromText = this.factory.createExpressionFromText(generator.toString(), unary);
            this.invokeMethodOn(setter, qualifier, new GrExpression[]{fromText}, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), unary);
        } else if (resolved instanceof PsiVariable) {
            boolean shouldInsertParentheses;
            ExpressionGenerator curGenerator;
            StringBuilder curBuilder;
            boolean wrap = this.context.analyzedVars.toWrap((PsiVariable)resolved);
            boolean doNeedExpression = PsiUtil.isExpressionUsed(unary);
            if (doNeedExpression && wrap) {
                curBuilder = new StringBuilder();
                curGenerator = new ExpressionGenerator(curBuilder, this.context);
            } else {
                curBuilder = this.builder;
                curGenerator = this;
            }
            boolean bl = shouldInsertParentheses = !wrap && doNeedExpression;
            if (shouldInsertParentheses) {
                curBuilder.append('(');
            }
            operand.accept(curGenerator);
            if (wrap) {
                curBuilder.append(".set(");
            } else {
                curBuilder.append(" = ");
            }
            if (ExpressionGenerator.shouldNotReplaceOperatorWithMethod(operand.getType(), null, unary.getOperationTokenType())) {
                ExpressionGenerator.writeSimpleUnary((GrExpression)operand.copy(), unary, curGenerator);
            } else {
                curGenerator.invokeMethodOn(method, (GrExpression)operand.copy(), GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), unary);
            }
            if (shouldInsertParentheses) {
                curBuilder.append(')');
            }
            if (wrap) {
                curBuilder.append(')');
                if (doNeedExpression) {
                    curBuilder.append(';');
                    this.context.myStatements.add(curBuilder.toString());
                    operand.accept(this);
                    this.builder.append(".get()");
                }
            }
        }
        return true;
    }

    private static void writeSimpleUnary(GrExpression operand, GrUnaryExpression unary, ExpressionGenerator generator) {
        String opTokenText = unary.getOperationToken().getText();
        boolean isPostfix = unary.isPostfix();
        if (!isPostfix) {
            generator.getBuilder().append(opTokenText);
        }
        operand.accept(generator);
        if (isPostfix) {
            generator.getBuilder().append(opTokenText);
        }
    }

    @Override
    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitLiteralExpression"));
        }
        TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(literal);
        boolean isChar = false;
        for (TypeConstraint constraint : constraints) {
            if (!(constraint instanceof SubtypeConstraint) || !PsiType.CHAR.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(constraint.getDefaultType()))) continue;
            isChar = true;
        }
        String text = literal.getText();
        if (text.startsWith("'''") || text.startsWith("\"\"\"")) {
            String string = GrStringUtil.removeQuotes(text).replace("\n", "\\n").replace("\r", "\\r");
            this.builder.append('\"').append(string).append('\"');
        } else if (text.startsWith("'")) {
            if (isChar) {
                this.builder.append(text);
            } else {
                this.builder.append('\"').append(StringUtil.escapeQuotes((String)StringUtil.trimEnd((String)text.substring(1, text.length()), (String)"'"))).append('\"');
            }
        } else if (text.startsWith("\"")) {
            if (isChar) {
                this.builder.append('\'').append(StringUtil.escapeQuotes((String)StringUtil.trimEnd((String)text.substring(1, text.length()), (String)"\""))).append('\'');
            } else {
                this.builder.append(text);
            }
        } else {
            this.builder.append(text);
        }
    }

    @Override
    public void visitGStringExpression(@NotNull GrString gstring) {
        if (gstring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gstring", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitGStringExpression"));
        }
        String newExprText = ConvertGStringToStringIntention.convertGStringLiteralToStringLiteral(gstring);
        GrExpression newExpr = this.factory.createExpressionFromText(newExprText, gstring);
        newExpr.accept(this);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitReferenceExpression"));
        }
        GrExpression qualifier = (GrExpression)referenceExpression.getQualifier();
        GroovyResolveResult resolveResult = referenceExpression.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        String referenceName = referenceExpression.getReferenceName();
        if (PsiUtil.isThisOrSuperRef(referenceExpression)) {
            this.writeThisOrSuperRef(referenceExpression, qualifier, referenceName);
            return;
        }
        if (ResolveUtil.isClassReference(referenceExpression)) {
            LOG.assertTrue(qualifier != null);
            qualifier.accept(this);
            return;
        }
        if (resolved instanceof PsiClass) {
            this.builder.append(((PsiClass)resolved).getQualifiedName());
            if (PsiUtil.isExpressionUsed(referenceExpression)) {
                this.builder.append(".class");
            }
            return;
        }
        if (resolved == null && qualifier == null && this.context.myUsedVarNames.contains(referenceName)) {
            this.builder.append(referenceName);
            return;
        }
        if (qualifier == null && (resolved == null || resolved instanceof GrBindingVariable || resolved instanceof LightElement && !(resolved instanceof ClosureSyntheticParameter)) && (referenceExpression.getParent() instanceof GrIndexProperty || !(referenceExpression.getParent() instanceof GrCall)) && PsiUtil.getContextClass(referenceExpression) instanceof GroovyScriptClass) {
            GrExpression thisExpr = this.factory.createExpressionFromText("this", referenceExpression);
            thisExpr.accept(this);
            this.builder.append(".getBinding().getProperty(\"").append(referenceExpression.getReferenceName()).append("\")");
            return;
        }
        IElementType type = referenceExpression.getDotTokenType();
        GrExpression qualifierToUse = qualifier;
        if (type == GroovyTokenTypes.mMEMBER_POINTER) {
            LOG.assertTrue(qualifier != null);
            this.builder.append("new ").append("org.codehaus.groovy.runtime.MethodClosure").append('(');
            qualifier.accept(this);
            this.builder.append(", \"").append(referenceName).append("\")");
            return;
        }
        if (type == GroovyTokenTypes.mOPTIONAL_DOT) {
            LOG.assertTrue(qualifier != null);
            String qualifierName = this.createVarByInitializer(qualifier);
            this.builder.append('(').append(qualifierName).append(" == null ? null : ");
            qualifierToUse = this.factory.createReferenceExpressionFromText(qualifierName, referenceExpression);
        }
        if (resolveResult.isInvokedOnProperty()) {
            LOG.assertTrue(resolved instanceof PsiMethod);
            LOG.assertTrue(GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)resolved));
            this.invokeMethodOn((PsiMethod)resolved, qualifierToUse, GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), referenceExpression);
        } else {
            if (qualifierToUse != null) {
                qualifierToUse.accept(this);
                this.builder.append('.');
            }
            if (resolved instanceof PsiNamedElement && !(resolved instanceof GrBindingVariable)) {
                String refName = ((PsiNamedElement)resolved).getName();
                if (resolved instanceof GrVariable && this.context.analyzedVars.toWrap((GrVariable)resolved)) {
                    this.builder.append(this.context.analyzedVars.toVarName((GrVariable)resolved));
                    if (!PsiUtil.isAccessedForWriting(referenceExpression)) {
                        this.builder.append(".get()");
                    }
                } else {
                    this.builder.append(refName);
                }
            } else if (referenceName != null) {
                if (PsiUtil.isAccessedForWriting(referenceExpression)) {
                    this.builder.append(referenceName);
                } else {
                    PsiClassType stringType = PsiType.getJavaLangString((PsiManager)referenceExpression.getManager(), (GlobalSearchScope)referenceExpression.getResolveScope());
                    PsiType qualifierType = PsiImplUtil.getQualifierType(referenceExpression);
                    GroovyResolveResult[] candidates = qualifierType != null ? ResolveUtil.getMethodCandidates(qualifierType, "getProperty", (PsiElement)referenceExpression, new PsiType[]{stringType}) : GroovyResolveResult.EMPTY_ARRAY;
                    PsiMethod method = PsiImplUtil.extractUniqueElement(candidates);
                    if (method != null) {
                        this.builder.append("getProperty(\"").append(referenceName).append("\")");
                    } else {
                        this.builder.append(referenceName);
                    }
                }
            } else {
                PsiElement nameElement = referenceExpression.getReferenceNameElement();
                if (nameElement instanceof GrExpression) {
                    ((GrExpression)nameElement).accept(this);
                } else if (nameElement != null) {
                    this.builder.append(nameElement.toString());
                }
            }
        }
        if (type == GroovyTokenTypes.mOPTIONAL_DOT) {
            this.builder.append(')');
        }
    }

    private void writeThisOrSuperRef(GrReferenceExpression referenceExpression, GrExpression qualifier, String referenceName) {
        if (!this.context.isInAnonymousContext() && qualifier != null) {
            qualifier.accept(this);
            this.builder.append('.');
            this.builder.append(referenceName);
        } else if (GenerationUtil.getWrappingImplicitClass(referenceExpression) != null) {
            if ("this".equals(referenceName)) {
                PsiElement _contextClass = referenceExpression.resolve();
                PsiClass contextClass = _contextClass instanceof PsiClass ? (PsiClass)_contextClass : null;
                GenerationUtil.writeThisReference(contextClass, this.builder, this.context);
            } else {
                PsiClass contextClass = PsiUtil.getContextClass(referenceExpression);
                GenerationUtil.writeSuperReference(contextClass, this.builder, this.context);
            }
        } else {
            this.builder.append(referenceName);
        }
    }

    private String createVarByInitializer(@NotNull GrExpression initializer) {
        PsiElement resolved;
        GrExpression qualifier;
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "createVarByInitializer"));
        }
        GrExpression inner = initializer;
        while (inner instanceof GrParenthesizedExpression) {
            inner = ((GrParenthesizedExpression)inner).getOperand();
        }
        if (inner != null) {
            initializer = inner;
        }
        if (initializer instanceof GrReferenceExpression && (qualifier = (GrExpression)((GrReferenceExpression)initializer).getQualifier()) == null && (resolved = ((GrReferenceExpression)initializer).resolve()) instanceof GrVariable && !(resolved instanceof GrField)) {
            return ((GrVariable)resolved).getName();
        }
        String name = GenerationUtil.suggestVarName(initializer, this.context);
        StringBuilder builder = new StringBuilder();
        builder.append("final ");
        TypeWriter.writeType(builder, initializer.getType(), initializer);
        builder.append(' ').append(name).append(" = ");
        initializer.accept(new ExpressionGenerator(builder, this.context));
        builder.append(';');
        this.context.myStatements.add(builder.toString());
        return name;
    }

    @Override
    public void visitCastExpression(@NotNull GrTypeCastExpression typeCastExpression) {
        if (typeCastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitCastExpression"));
        }
        GrTypeElement typeElement = typeCastExpression.getCastTypeElement();
        GrExpression operand = typeCastExpression.getOperand();
        this.generateCast(typeElement, operand);
    }

    private void generateCast(GrTypeElement typeElement, GrExpression operand) {
        boolean insertParentheses;
        this.builder.append('(');
        TypeWriter.writeType(this.builder, typeElement.getType(), typeElement);
        this.builder.append(')');
        boolean bl = insertParentheses = operand instanceof GrBinaryExpression && ((GrBinaryExpression)operand).getOperationTokenType() == GroovyTokenTypes.mEQUAL;
        if (insertParentheses) {
            this.builder.append('(');
        }
        if (operand != null) {
            operand.accept(this);
        }
        if (insertParentheses) {
            this.builder.append(')');
        }
    }

    @Override
    public void visitSafeCastExpression(@NotNull GrSafeCastExpression typeCastExpression) {
        if (typeCastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitSafeCastExpression"));
        }
        GrExpression operand = (GrExpression)PsiUtil.skipParenthesesIfSensibly(typeCastExpression.getOperand(), false);
        GrTypeElement typeElement = typeCastExpression.getCastTypeElement();
        if (operand instanceof GrListOrMap && ((GrListOrMap)operand).isMap() && typeElement != null) {
            AnonymousFromMapGenerator.writeAnonymousMap((GrListOrMap)operand, typeElement, this.builder, this.context);
            return;
        }
        PsiType type = typeElement.getType();
        if (operand instanceof GrListOrMap && !((GrListOrMap)operand).isMap() && type instanceof PsiArrayType) {
            this.builder.append("new ");
            GrExpression[] initializers = ((GrListOrMap)operand).getInitializers();
            if (initializers.length == 0) {
                TypeWriter.writeTypeForNew(this.builder, ((PsiArrayType)type).getComponentType(), typeCastExpression);
                this.builder.append("[0]");
            } else {
                TypeWriter.writeTypeForNew(this.builder, type, typeCastExpression);
                this.builder.append('{');
                for (GrExpression initializer : initializers) {
                    initializer.accept(this);
                    this.builder.append(", ");
                }
                if (initializers.length > 0) {
                    this.builder.delete(this.builder.length() - 2, this.builder.length());
                }
                this.builder.append('}');
            }
            return;
        }
        GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(typeCastExpression.multiResolve(false));
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiMethod) {
            GrExpression typeParam;
            try {
                typeParam = this.factory.createExpressionFromText(typeElement.getText(), typeCastExpression);
            }
            catch (IncorrectOperationException e) {
                this.generateCast(typeElement, operand);
                return;
            }
            this.invokeMethodOn((PsiMethod)resolved, operand, new GrExpression[]{typeParam}, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, resolveResult.getSubstitutor(), typeCastExpression);
        } else {
            this.generateCast(typeElement, operand);
        }
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitInstanceofExpression"));
        }
        GrExpression operand = expression.getOperand();
        GrTypeElement typeElement = expression.getTypeElement();
        this.writeInstanceof(operand, typeElement != null ? typeElement.getType() : null, expression);
    }

    private void writeInstanceof(@NotNull GrExpression operand, @Nullable PsiType type, @NotNull PsiElement context) {
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeInstanceof"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeInstanceof"));
        }
        operand.accept(this);
        this.builder.append(" instanceof ");
        if (type != null) {
            TypeWriter.writeType(this.builder, type, context);
        }
    }

    @Override
    public void visitBuiltinTypeClassExpression(@NotNull GrBuiltinTypeClassExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitBuiltinTypeClassExpression"));
        }
        PsiElement firstChild = expression.getFirstChild();
        LOG.assertTrue(firstChild != null);
        ASTNode node = firstChild.getNode();
        LOG.assertTrue(node != null);
        IElementType type = node.getElementType();
        String boxed = TypesUtil.getBoxedTypeName(type);
        this.builder.append(boxed);
        if (expression.getParent() instanceof GrIndexProperty) {
            this.builder.append("[]");
        }
        this.builder.append(".class");
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitParenthesizedExpression"));
        }
        this.builder.append('(');
        GrExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
        this.builder.append(')');
    }

    @Override
    public void visitPropertySelection(@NotNull GrPropertySelection expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitPropertySelection"));
        }
        expression.getQualifier().accept(this);
        this.builder.append('.');
        this.builder.append(expression.getReferenceNameElement().getText());
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        GroovyResolveResult candidate;
        PsiElement element;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitIndexProperty"));
        }
        GrExpression selectedExpression = expression.getInvokedExpression();
        PsiType thisType = selectedExpression.getType();
        GrArgumentList argList = expression.getArgumentList();
        if (argList.getAllArguments().length == 0) {
            PsiElement resolved;
            if (selectedExpression instanceof GrBuiltinTypeClassExpression) {
                selectedExpression.accept(this);
                return;
            }
            if (selectedExpression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)selectedExpression).resolve()) instanceof PsiClass) {
                this.builder.append(((PsiClass)resolved).getQualifiedName());
                this.builder.append("[].class");
                return;
            }
        }
        PsiType[] argTypes = PsiUtil.getArgumentTypes(argList);
        GrExpression[] exprArgs = argList.getExpressionArguments();
        GrNamedArgument[] namedArgs = argList.getNamedArguments();
        if (!(PsiImplUtil.isSimpleArrayAccess(thisType, argTypes, expression, PsiUtil.isLValue(expression)) || (element = (candidate = PsiImplUtil.extractUniqueResult(expression.multiResolve(false))).getElement()) == null && PsiUtil.isLValue(expression))) {
            PsiClass list;
            if (element instanceof GrGdkMethod && ((GrGdkMethod)element).getStaticMethod().getParameterList().getParameters()[0].getType().equalsToText("java.util.Map<K,V>")) {
                PsiClass map = JavaPsiFacade.getInstance((Project)this.context.project).findClass("java.util.Map", expression.getResolveScope());
                if (map != null) {
                    PsiMethod[] gets = map.findMethodsByName("get", false);
                    this.invokeMethodOn(gets[0], selectedExpression, exprArgs, namedArgs, GrClosableBlock.EMPTY_ARRAY, PsiSubstitutor.EMPTY, expression);
                    return;
                }
            } else if (element instanceof GrGdkMethod && ((GrGdkMethod)element).getStaticMethod().getParameterList().getParameters()[0].getType().equalsToText("java.util.List<T>") && (list = JavaPsiFacade.getInstance((Project)this.context.project).findClass("java.util.List", expression.getResolveScope())) != null) {
                PsiMethod[] gets = list.findMethodsByName("get", false);
                this.invokeMethodOn(gets[0], selectedExpression, exprArgs, namedArgs, GrClosableBlock.EMPTY_ARRAY, PsiSubstitutor.EMPTY, expression);
                return;
            }
            GenerationUtil.invokeMethodByResolveResult(selectedExpression, candidate, "getAt", exprArgs, namedArgs, GrClosableBlock.EMPTY_ARRAY, this, expression);
            return;
        }
        selectedExpression.accept(this);
        this.builder.append('[');
        GrExpression arg = exprArgs[0];
        arg.accept(this);
        this.builder.append(']');
    }

    public void invokeMethodOn(@NotNull PsiMethod method, @Nullable GrExpression caller, @NotNull GrExpression[] exprs, @NotNull GrNamedArgument[] namedArgs, @NotNull GrClosableBlock[] closures, @NotNull PsiSubstitutor substitutor, @NotNull GroovyPsiElement context) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "invokeMethodOn"));
        }
        if (exprs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprs", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "invokeMethodOn"));
        }
        if (namedArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgs", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "invokeMethodOn"));
        }
        if (closures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closures", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "invokeMethodOn"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "invokeMethodOn"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "invokeMethodOn"));
        }
        if (method instanceof GrGdkMethod) {
            if (CustomMethodInvocator.invokeMethodOn(this, (GrGdkMethod)method, caller, exprs, namedArgs, closures, substitutor, context)) {
                return;
            }
            GrExpression[] newArgs = new GrExpression[exprs.length + 1];
            System.arraycopy(exprs, 0, newArgs, 1, exprs.length);
            if (method.hasModifierProperty("static")) {
                newArgs[0] = this.factory.createExpressionFromText("null");
            } else {
                if (caller == null) {
                    caller = this.factory.createExpressionFromText("this", context);
                }
                newArgs[0] = caller;
            }
            this.invokeMethodOn(((GrGdkMethod)method).getStaticMethod(), null, newArgs, namedArgs, closures, substitutor, context);
            return;
        }
        if (method.hasModifierProperty("static") && caller == null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)context, (boolean)true)) {
                this.builder.append(containingClass.getQualifiedName()).append('.');
            }
        } else if (caller != null) {
            boolean castNeeded = GenerationUtil.isCastNeeded(caller, (PsiMember)method, this.context);
            if (castNeeded) {
                this.writeCastForMethod(caller, method, context);
            }
            caller.accept(this);
            if (castNeeded) {
                this.builder.append(')');
            }
            this.builder.append('.');
        }
        this.builder.append(method.getName());
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor);
        new ArgumentListGenerator(this.builder, this.context).generate(signature, exprs, namedArgs, closures, context);
    }

    private void writeCastForMethod(@NotNull GrExpression caller, @NotNull PsiMethod method, @NotNull GroovyPsiElement context) {
        if (caller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caller", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeCastForMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeCastForMethod"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "writeCastForMethod"));
        }
        PsiType type = ExpressionGenerator.inferCastType(caller, method, context);
        if (type == null) {
            return;
        }
        this.builder.append('(');
        this.builder.append('(');
        TypeWriter.writeType(this.builder, type, context);
        this.builder.append(')');
    }

    @Nullable
    private static PsiType inferCastType(@NotNull GrExpression caller, @NotNull PsiMethod method, @NotNull GroovyPsiElement context) {
        if (caller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caller", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "inferCastType"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "inferCastType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "inferCastType"));
        }
        PsiType type = caller.getType();
        if (type instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type).getConjuncts()) {
                GenerationUtil.CheckProcessElement processor = new GenerationUtil.CheckProcessElement((PsiElement)method);
                ResolveUtil.processAllDeclarations(conjunct, (PsiScopeProcessor)processor, false, (PsiElement)context);
                if (!processor.isFound()) continue;
                return conjunct;
            }
        }
        return type;
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        if (listOrMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrMap", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitListOrMap"));
        }
        PsiType type = listOrMap.getType();
        LOG.assertTrue(type instanceof GrLiteralClassType || type instanceof PsiArrayType || type instanceof PsiClassType);
        if (listOrMap.isMap()) {
            if (listOrMap.getNamedArguments().length == 0) {
                this.builder.append("new ");
                TypeWriter.writeTypeForNew(this.builder, type, listOrMap);
                this.builder.append("()");
            } else {
                String varName = this.generateMapVariableDeclaration(listOrMap, type);
                this.generateMapElementInsertions(listOrMap, varName);
                this.builder.append(varName);
            }
        } else {
            this.builder.append("new ");
            PsiType typeToUse = ExpressionGenerator.getTypeToUseByList(listOrMap, type);
            TypeWriter.writeTypeForNew(this.builder, typeToUse, listOrMap);
            if (typeToUse instanceof PsiArrayType) {
                if (listOrMap.getInitializers().length == 0) {
                    this.builder.replace(this.builder.length() - 2, this.builder.length(), "[0]");
                } else {
                    this.builder.append('{');
                    this.genInitializers(listOrMap);
                    this.builder.append('}');
                }
            } else if (listOrMap.getInitializers().length == 0) {
                this.builder.append("()");
            } else {
                this.builder.append("(java.util.Arrays.asList(");
                this.genInitializers(listOrMap);
                this.builder.append("))");
            }
        }
    }

    private static PsiType getTypeToUseByList(GrListOrMap listOrMap, PsiType type) {
        JavaPsiFacade facade;
        PsiClass arrayList;
        PsiClass resolved;
        PsiType iterable;
        if (ExpressionGenerator.isImplicitlyCastedToArray(listOrMap) && (iterable = ClosureParameterEnhancer.findTypeForIteration(listOrMap, (PsiElement)listOrMap)) != null) {
            return new PsiArrayType(iterable);
        }
        if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && "java.util.List".equals(resolved.getQualifiedName()) && (arrayList = (facade = JavaPsiFacade.getInstance((Project)listOrMap.getProject())).findClass("java.util.ArrayList", listOrMap.getResolveScope())) != null) {
            return facade.getElementFactory().createType(arrayList, ((PsiClassType)type).getParameters());
        }
        return type;
    }

    private static boolean isImplicitlyCastedToArray(GrListOrMap list) {
        PsiElement parent = list.getParent();
        GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(list);
        if (!(owner instanceof GrOpenBlock) || !(owner.getParent() instanceof GrMethod)) {
            return false;
        }
        if (!(parent instanceof GrReturnStatement) && !ControlFlowUtils.isReturnValue(list, owner)) {
            return false;
        }
        PsiType type = ((GrMethod)owner.getParent()).getReturnType();
        return type instanceof PsiArrayType;
    }

    private void generateMapElementInsertions(GrListOrMap listOrMap, String varName) {
        for (GrNamedArgument arg : listOrMap.getNamedArguments()) {
            StringBuilder insertion = new StringBuilder();
            insertion.append(varName).append(".put(");
            String stringKey = arg.getLabelName();
            if (stringKey != null) {
                insertion.append('\"').append(stringKey).append('\"');
            } else {
                GrExpression expression;
                GrArgumentLabel label = arg.getLabel();
                GrExpression grExpression = expression = label == null ? null : label.getExpression();
                if (expression != null) {
                    expression.accept(new ExpressionGenerator(insertion, this.context));
                }
            }
            insertion.append(", ");
            GrExpression expression = arg.getExpression();
            if (expression != null) {
                expression.accept(new ExpressionGenerator(insertion, this.context));
            }
            insertion.append(");");
            this.context.myStatements.add(insertion.toString());
        }
    }

    private String generateMapVariableDeclaration(GrListOrMap listOrMap, PsiType type) {
        StringBuilder declaration = new StringBuilder();
        TypeWriter.writeType(declaration, type, listOrMap);
        String varName = GenerationUtil.suggestVarName(type, listOrMap, this.context);
        declaration.append(' ').append(varName).append(" = new ");
        TypeWriter.writeTypeForNew(declaration, type, listOrMap);
        declaration.append('(');
        declaration.append(listOrMap.getNamedArguments().length);
        declaration.append(");");
        this.context.myStatements.add(declaration.toString());
        return varName;
    }

    private void genInitializers(GrListOrMap list) {
        GrExpression[] initializers;
        LOG.assertTrue(!list.isMap());
        for (GrExpression expr : initializers = list.getInitializers()) {
            expr.accept(this);
            this.builder.append(", ");
        }
        if (initializers.length > 0) {
            this.builder.delete(this.builder.length() - 2, this.builder.length());
        }
    }

    @Override
    public void visitRangeExpression(@NotNull GrRangeExpression range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/refactoring/convertToJava/ExpressionGenerator", "visitRangeExpression"));
        }
        PsiType type = range.getType();
        LOG.assertTrue(type instanceof GrRangeType);
        PsiClass resolved = ((GrRangeType)type).resolve();
        this.builder.append("new ");
        if (resolved == null || resolved.getQualifiedName() == "groovy.lang.Range") {
            this.builder.append("groovy.lang.ObjectRange");
        } else {
            this.builder.append(resolved.getQualifiedName());
        }
        this.builder.append('(');
        GrExpression left = range.getLeftOperand();
        left.accept(this);
        this.builder.append(", ");
        GrExpression right = range.getRightOperand();
        if (right != null) {
            right.accept(this);
        }
        this.builder.append(')');
    }
}

