/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrAnnotationArgumentListImpl
extends GroovyPsiElementImpl
implements GrAnnotationArgumentList {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationArgumentListImpl");

    public GrAnnotationArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationArgumentListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotationArgumentList(this);
    }

    public String toString() {
        return "Annotation arguments";
    }

    @Override
    @NotNull
    public GrAnnotationNameValuePair[] getAttributes() {
        ArrayList<GrAnnotationNameValuePair> result = new ArrayList<GrAnnotationNameValuePair>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrAnnotationNameValuePair)) continue;
            result.add((GrAnnotationNameValuePair)cur);
        }
        GrAnnotationNameValuePair[] grAnnotationNameValuePairArray = result.toArray(new GrAnnotationNameValuePair[result.size()]);
        if (grAnnotationNameValuePairArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationArgumentListImpl", "getAttributes"));
        }
        return grAnnotationNameValuePairArray;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first.getElementType() == GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR && last.getElementType() == GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR) {
            GrAnnotationNameValuePair pair;
            GrAnnotationNameValuePair[] nodes;
            ASTNode lparenth = this.getNode().getFirstChildNode();
            ASTNode rparenth = this.getNode().getLastChildNode();
            if (lparenth == null) {
                this.getNode().addLeaf(GroovyTokenTypes.mLPAREN, (CharSequence)"(", null);
            }
            if (rparenth == null) {
                this.getNode().addLeaf(GroovyTokenTypes.mRPAREN, (CharSequence)")", null);
            }
            if ((nodes = this.getAttributes()).length == 1 && (pair = nodes[0]).getName() == null) {
                String text = pair.getValue().getText();
                try {
                    GrAnnotation annotation = GroovyPsiElementFactory.getInstance(this.getProject()).createAnnotationFromText("@AAA(value = " + text + ")");
                    this.getNode().replaceChild(pair.getNode(), annotation.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (anchor == null && before != null) {
                anchor = before != false ? this.getNode().getLastChildNode() : this.getNode().getFirstChildNode();
            }
        }
        return super.addInternal(first, last, anchor, before);
    }
}

