/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.PathExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class Modifiers {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        boolean hasModifiers;
        PsiBuilder.Marker modifiersMarker;
        block3: {
            PsiBuilder.Marker modifierListItem;
            modifiersMarker = builder.mark();
            hasModifiers = false;
            while (true) {
                boolean parsed;
                modifierListItem = builder.mark();
                if (hasModifiers) {
                    ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                }
                boolean bl = parsed = Annotation.parse(builder, parser) || Modifiers.parseModifier(builder);
                if (!parsed) break;
                if (PathExpression.isQualificationDot(builder)) {
                    modifierListItem.rollbackTo();
                    break block3;
                }
                modifierListItem.drop();
                hasModifiers = true;
            }
            modifierListItem.rollbackTo();
        }
        modifiersMarker.done(GroovyElementTypes.MODIFIERS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        return hasModifiers;
    }

    public static boolean parseModifier(PsiBuilder builder) {
        if (TokenSets.MODIFIERS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }
}

