/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class ConvertMultilineStringToSingleLineIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertMultilineStringToSingleLineIntention.class);
    public static final String hint = GroovyIntentionsBundle.message("convert.multiline.string.to.single.line.intention.name", new Object[0]);

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrExpression old;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertMultilineStringToSingleLineIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertMultilineStringToSingleLineIntention", "processIntention"));
        }
        String quote = element.getText().substring(0, 1);
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        if (element instanceof GrLiteralImpl) {
            ConvertMultilineStringToSingleLineIntention.appendSimpleStringValue(element, buffer, quote);
            old = (GrExpression)element;
        } else {
            GrStringImpl gstring = (GrStringImpl)element;
            for (GroovyPsiElement child : gstring.getAllContentParts()) {
                if (child instanceof GrStringContent) {
                    ConvertMultilineStringToSingleLineIntention.appendSimpleStringValue(child, buffer, "\"");
                    continue;
                }
                if (!(child instanceof GrStringInjection)) continue;
                buffer.append(child.getText());
            }
            old = gstring;
        }
        buffer.append(quote);
        try {
            int offset = editor.getCaretModel().getOffset();
            TextRange range = old.getTextRange();
            int shift = range.getStartOffset() == offset ? 0 : (range.getStartOffset() == offset - 1 ? -1 : (range.getEndOffset() == offset ? -4 : (range.getEndOffset() == offset + 1 ? -3 : -2)));
            GrExpression newLiteral = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(buffer.toString());
            old.replaceWithExpression(newLiteral, true);
            if (shift != 0) {
                editor.getCaretModel().moveToOffset(offset + shift);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void appendSimpleStringValue(PsiElement element, StringBuilder buffer, String quote) {
        String text = GrStringUtil.removeQuotes(element.getText());
        if ("'".equals(quote)) {
            GrStringUtil.escapeAndUnescapeSymbols(text, "\n'", "", buffer);
        } else {
            GrStringUtil.escapeAndUnescapeSymbols(text, "\"\n", "", buffer);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof GrLiteral)) {
                    return false;
                }
                String text = element.getText();
                String quote = GrStringUtil.getStartQuote(text);
                return "'''".equals(quote) || "\"\"\"".equals(quote);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertMultilineStringToSingleLineIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

