/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrFieldAlreadyDefinedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrFieldAlreadyDefinedInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrFieldAlreadyDefinedInspection", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("field.already.defined", args);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("field.already.defined", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrFieldAlreadyDefinedInspection", "getDisplayName"));
        }
        return string;
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitField(@NotNull GrField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrFieldAlreadyDefinedInspection$MyVisitor", "visitField"));
            }
            super.visitField(field);
            PsiNamedElement duplicate = ResolveUtil.findDuplicate(field);
            if (duplicate instanceof GrField) {
                this.registerError(field.getNameIdentifierGroovy(), field.getName());
            }
        }
    }
}

