/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PasteMvnDependencyPreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if ("build.gradle".equals(file.getName()) && PasteMvnDependencyPreProcessor.isMvnDependency(text)) {
            String string = PasteMvnDependencyPreProcessor.toGradleDependency(text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    private static String toGradleDependency(String mavenDependency) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                Document document = builder.parse(new InputSource(new StringReader(mavenDependency)));
                String gradleDependency = PasteMvnDependencyPreProcessor.extractGradleDependency(document);
                return gradleDependency != null ? gradleDependency : mavenDependency;
            }
            catch (IOException | SAXException exception) {
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return mavenDependency;
    }

    @Nullable
    private static String extractGradleDependency(Document document) {
        String groupId = PasteMvnDependencyPreProcessor.getGroupId(document);
        String artifactId = PasteMvnDependencyPreProcessor.getArtifactId(document);
        String version = PasteMvnDependencyPreProcessor.getVersion(document);
        String scope = PasteMvnDependencyPreProcessor.getScope(document);
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            return null;
        }
        return scope + "'" + groupId + ":" + artifactId + ":" + version + "'";
    }

    private static String getScope(@NotNull Document document) {
        String scope;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "getScope"));
        }
        switch (scope = PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("scope"))) {
            case "test": {
                scope = "testCompile ";
                break;
            }
            case "compile": 
            case "runtime": {
                scope = scope + " ";
                break;
            }
            default: {
                scope = "compile ";
            }
        }
        return scope;
    }

    private static String getVersion(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "getVersion"));
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("version"));
    }

    private static String getArtifactId(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "getArtifactId"));
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("artifactId"));
    }

    private static String getGroupId(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "getGroupId"));
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("groupId"));
    }

    private static String firstOrEmpty(@NotNull NodeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor", "firstOrEmpty"));
        }
        Node first = list.item(0);
        return first != null ? first.getTextContent() : "";
    }

    private static boolean isMvnDependency(String text) {
        String trimmed = text.trim();
        return trimmed.startsWith("<dependency>") && trimmed.endsWith("</dependency>");
    }
}

