/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class JavaPerformanceDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(JavaPerformanceDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue PAINT_ALLOC = Issue.create("DrawAllocation", "Memory allocations within drawing code", "You should avoid allocating objects during a drawing or layout operation. These are called frequently, so a smooth UI can be interrupted by garbage collection pauses caused by the object allocations.\n\nThe way this is generally handled is to allocate the needed objects up front and to reuse them for each drawing operation.\n\nSome methods allocate memory on your behalf (such as `Bitmap.create`), and these should be handled in the same way.", Category.PERFORMANCE, 9, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_SPARSE_ARRAY = Issue.create("UseSparseArrays", "HashMap can be replaced with SparseArray", "For maps where the keys are of type integer, it's typically more efficient to use the Android `SparseArray` API. This check identifies scenarios where you might want to consider using `SparseArray` instead of `HashMap` for better performance.\n\nThis is *particularly* useful when the value types are primitives like ints, where you can use `SparseIntArray` and avoid auto-boxing the values from `int` to `Integer`.\n\nIf you need to construct a `HashMap` because you need to call an API outside of your control which requires a `Map`, you can suppress this warning using for example the `@SuppressLint` annotation.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_VALUE_OF = Issue.create("UseValueOf", "Should use `valueOf` instead of `new`", "You should not call the constructor for wrapper classes directly, such as`new Integer(42)`. Instead, call the `valueOf` factory method, such as `Integer.valueOf(42)`. This will typically use less memory because common integers such as 0 and 1 will share a single instance.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    static final String ON_MEASURE = "onMeasure";
    static final String ON_DRAW = "onDraw";
    static final String ON_LAYOUT = "onLayout";
    private static final String LAYOUT = "layout";
    private static final String HASH_MAP = "java.util.HashMap";
    private static final String SPARSE_ARRAY = "android.util.SparseArray";
    public static final String CLASS_CANVAS = "android.graphics.Canvas";

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(3);
        types.add(UCallExpression.class);
        types.add(UMethod.class);
        return types;
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new PerformanceVisitor(context);
    }

    private static String getUseValueOfErrorMessage(String typeName, String argument) {
        return String.format("Use `%1$s.valueOf(%2$s)` instead", typeName.substring(typeName.lastIndexOf(46) + 1), argument);
    }

    @Nullable
    public static String getReplacedType(@NonNull String message2, @NonNull TextFormat format) {
        int index = (message2 = format.toText(message2)).indexOf(46);
        if (index != -1 && message2.startsWith("Use ")) {
            return message2.substring(4, index);
        }
        return null;
    }

    private static class AssignmentTracker
    extends AbstractUastVisitor {
        private final Collection<String> mVariables;

        public AssignmentTracker(Collection<String> variables) {
            this.mVariables = variables;
        }

        @Override
        public boolean visitBinaryExpression(UBinaryExpression node) {
            if (UastExpressionUtils.isAssignment(node)) {
                UExpression left = node.getLeftOperand();
                if (left instanceof UQualifiedReferenceExpression) {
                    UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)left;
                    if (ref.getReceiver() instanceof UThisExpression || ref.getReceiver() instanceof USuperExpression) {
                        PsiElement resolved = ref.resolve();
                        if (resolved instanceof PsiField) {
                            this.mVariables.add(((PsiField)resolved).getName());
                        }
                    } else {
                        PsiElement resolved = ref.resolve();
                        if (resolved instanceof PsiField) {
                            this.mVariables.add(((PsiField)resolved).getName());
                        }
                    }
                } else if (left instanceof USimpleNameReferenceExpression) {
                    this.mVariables.add(((USimpleNameReferenceExpression)left).getIdentifier());
                }
            }
            return super.visitBinaryExpression(node);
        }
    }

    private static class PerformanceVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private final boolean mCheckMaps;
        private final boolean mCheckAllocations;
        private final boolean mCheckValueOf;
        private boolean mFlagAllocations;

        public PerformanceVisitor(JavaContext context) {
            this.mContext = context;
            this.mCheckAllocations = context.isEnabled(PAINT_ALLOC);
            this.mCheckMaps = context.isEnabled(USE_SPARSE_ARRAY);
            this.mCheckValueOf = context.isEnabled(USE_VALUE_OF);
        }

        @Override
        public boolean visitMethod(UMethod node) {
            this.mFlagAllocations = this.isBlockedAllocationMethod(node);
            return super.visitMethod(node);
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isConstructorCall(node)) {
                this.visitConstructorCallExpression(node);
            } else if (UastExpressionUtils.isMethodCall(node)) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitConstructorCallExpression(UCallExpression node) {
            PsiMethod method;
            String typeName = null;
            UReferenceExpression classReference2 = node.getClassReference();
            if ((this.mCheckMaps || this.mCheckValueOf) && classReference2 != null) {
                typeName = UastUtils.getQualifiedName(classReference2);
            }
            if (this.mCheckMaps) {
                if (JavaPerformanceDetector.HASH_MAP.equals(typeName)) {
                    this.checkHashMap(node);
                } else if (JavaPerformanceDetector.SPARSE_ARRAY.equals(typeName)) {
                    this.checkSparseArray(node);
                }
            }
            if (this.mCheckValueOf && typeName != null && (typeName.equals("java.lang.Integer") || typeName.equals("java.lang.Boolean") || typeName.equals("java.lang.Float") || typeName.equals("java.lang.Character") || typeName.equals("java.lang.Long") || typeName.equals("java.lang.Double") || typeName.equals("java.lang.Byte")) && node.getValueArgumentCount() == 1) {
                String argument = node.getValueArguments().get(0).asSourceString();
                this.mContext.report(USE_VALUE_OF, node, this.mContext.getUastLocation(node), JavaPerformanceDetector.getUseValueOfErrorMessage(typeName, argument));
            }
            if (this.mFlagAllocations && !(LintUtils.skipParentheses(node.getContainingElement()) instanceof UThrowExpression) && this.mCheckAllocations && (method = (PsiMethod)UastUtils.getParentOfType(node, UMethod.class)) != null && this.isBlockedAllocationMethod(method) && !PerformanceVisitor.isLazilyInitialized(node)) {
                this.reportAllocation(node);
            }
        }

        private void reportAllocation(UElement node) {
            this.mContext.report(PAINT_ALLOC, node, this.mContext.getUastLocation(node), "Avoid object allocations during draw/layout operations (preallocate and reuse instead)");
        }

        private void visitMethodCallExpression(UCallExpression node) {
            if (!this.mFlagAllocations) {
                return;
            }
            UExpression receiver2 = node.getReceiver();
            if (receiver2 == null) {
                return;
            }
            String functionName = node.getMethodName();
            if (functionName == null) {
                return;
            }
            if (functionName.equals("createBitmap") || functionName.equals("createScaledBitmap")) {
                PsiMethod method = node.resolve();
                if (method != null && JavaEvaluator.isMemberInClass((PsiMember)method, "android.graphics.Bitmap") && !PerformanceVisitor.isLazilyInitialized(node)) {
                    this.reportAllocation(node);
                }
            } else if (functionName.startsWith("decode")) {
                PsiMethod method = node.resolve();
                if (method != null && JavaEvaluator.isMemberInClass((PsiMember)method, "android.graphics.BitmapFactory") && !PerformanceVisitor.isLazilyInitialized(node)) {
                    this.reportAllocation(node);
                }
            } else if (functionName.equals("getClipBounds") && node.getValueArguments().isEmpty()) {
                this.mContext.report(PAINT_ALLOC, node, this.mContext.getUastLocation(node), "Avoid object allocations during draw operations: Use `Canvas.getClipBounds(Rect)` instead of `Canvas.getClipBounds()` which allocates a temporary `Rect`");
            }
        }

        private static boolean isLazilyInitialized(UElement node) {
            for (UElement curr = node.getContainingElement(); curr != null; curr = curr.getContainingElement()) {
                if (curr instanceof UMethod) {
                    return false;
                }
                if (!(curr instanceof UIfExpression)) continue;
                UIfExpression ifNode = (UIfExpression)curr;
                ArrayList<String> assignments = new ArrayList<String>();
                AssignmentTracker visitor = new AssignmentTracker(assignments);
                if (ifNode.getThenExpression() != null) {
                    ifNode.getThenExpression().accept(visitor);
                }
                if (!assignments.isEmpty()) {
                    ArrayList<String> references = new ArrayList<String>();
                    PerformanceVisitor.addReferencedVariables(references, ifNode.getCondition());
                    if (!references.isEmpty()) {
                        Sets.SetView intersection = Sets.intersection(new HashSet<String>(assignments), new HashSet<String>(references));
                        return !intersection.isEmpty();
                    }
                }
                return false;
            }
            return false;
        }

        private static void addReferencedVariables(@NonNull Collection<String> variables, @Nullable UExpression expression2) {
            if (expression2 instanceof UBinaryExpression) {
                UBinaryExpression binary = (UBinaryExpression)expression2;
                PerformanceVisitor.addReferencedVariables(variables, binary.getLeftOperand());
                PerformanceVisitor.addReferencedVariables(variables, binary.getRightOperand());
            } else if (expression2 instanceof UPrefixExpression) {
                UPrefixExpression unary = (UPrefixExpression)expression2;
                PerformanceVisitor.addReferencedVariables(variables, unary.getOperand());
            } else if (expression2 instanceof UParenthesizedExpression) {
                UParenthesizedExpression exp = (UParenthesizedExpression)expression2;
                PerformanceVisitor.addReferencedVariables(variables, exp.getExpression());
            } else if (expression2 instanceof USimpleNameReferenceExpression) {
                USimpleNameReferenceExpression reference = (USimpleNameReferenceExpression)expression2;
                variables.add(reference.getIdentifier());
            } else if (expression2 instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)expression2;
                UExpression receiver2 = ref.getReceiver();
                UExpression selector2 = ref.getSelector();
                if (receiver2 instanceof UThisExpression || receiver2 instanceof USuperExpression) {
                    String identifier;
                    String string = identifier = selector2 instanceof USimpleNameReferenceExpression ? ((USimpleNameReferenceExpression)selector2).getIdentifier() : null;
                    if (identifier != null) {
                        variables.add(identifier);
                    }
                }
            }
        }

        private boolean isBlockedAllocationMethod(@NonNull PsiMethod node) {
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            return PerformanceVisitor.isOnDrawMethod(evaluator, node) || PerformanceVisitor.isOnMeasureMethod(evaluator, node) || PerformanceVisitor.isOnLayoutMethod(evaluator, node) || PerformanceVisitor.isLayoutMethod(evaluator, node);
        }

        private static boolean isOnDrawMethod(@NonNull JavaEvaluator evaluator, @NonNull PsiMethod node) {
            return JavaPerformanceDetector.ON_DRAW.equals(node.getName()) && evaluator.parametersMatch(node, JavaPerformanceDetector.CLASS_CANVAS);
        }

        private static boolean isOnLayoutMethod(@NonNull JavaEvaluator evaluator, @NonNull PsiMethod node) {
            return JavaPerformanceDetector.ON_LAYOUT.equals(node.getName()) && evaluator.parametersMatch(node, "boolean", "int", "int", "int", "int");
        }

        private static boolean isOnMeasureMethod(@NonNull JavaEvaluator evaluator, @NonNull PsiMethod node) {
            return JavaPerformanceDetector.ON_MEASURE.equals(node.getName()) && evaluator.parametersMatch(node, "int", "int");
        }

        private static boolean isLayoutMethod(@NonNull JavaEvaluator evaluator, @NonNull PsiMethod node) {
            return JavaPerformanceDetector.LAYOUT.equals(node.getName()) && evaluator.parametersMatch(node, "int", "int", "int", "int");
        }

        private void checkHashMap(@NonNull UCallExpression node) {
            List<PsiType> types = node.getTypeArguments();
            if (types.size() == 2) {
                PsiType first = types.get(0);
                String typeName = first.getCanonicalText();
                int minSdk = this.mContext.getMainProject().getMinSdk();
                if ("java.lang.Integer".equals(typeName) || "java.lang.Byte".equals(typeName)) {
                    String valueType = types.get(1).getCanonicalText();
                    if (valueType.equals("java.lang.Integer")) {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), "Use new `SparseIntArray(...)` instead for better performance");
                    } else if (valueType.equals("java.lang.Long") && minSdk >= 18) {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), "Use `new SparseLongArray(...)` instead for better performance");
                    } else if (valueType.equals("java.lang.Boolean")) {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), "Use `new SparseBooleanArray(...)` instead for better performance");
                    } else {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), String.format("Use `new SparseArray<%1$s>(...)` instead for better performance", valueType.substring(valueType.lastIndexOf(46) + 1)));
                    }
                } else if ("java.lang.Long".equals(typeName) && (minSdk >= 16 || Boolean.TRUE == this.mContext.getMainProject().dependsOn("com.android.support:support-v4"))) {
                    boolean useBuiltin = minSdk >= 16;
                    String message2 = useBuiltin ? "Use `new LongSparseArray(...)` instead for better performance" : "Use `new android.support.v4.util.LongSparseArray(...)` instead for better performance";
                    this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), message2);
                }
            }
        }

        private void checkSparseArray(@NonNull UCallExpression node) {
            List<PsiType> types = node.getTypeArguments();
            if (types.size() == 1) {
                String valueType = types.get(0).getCanonicalText();
                if (valueType.equals("java.lang.Integer")) {
                    this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), "Use `new SparseIntArray(...)` instead for better performance");
                } else if (valueType.equals("java.lang.Boolean")) {
                    this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getUastLocation(node), "Use `new SparseBooleanArray(...)` instead for better performance");
                }
            }
        }
    }
}

