/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints.properties;

import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public class JavaExceptionBreakpointProperties
extends JavaBreakpointProperties<JavaExceptionBreakpointProperties> {
    public boolean NOTIFY_CAUGHT = true;
    public boolean NOTIFY_UNCAUGHT = true;
    @Attribute(value="class")
    public String myQualifiedName;
    @Attribute(value="package")
    public String myPackageName;
    private boolean myCatchFiltersEnabled = false;
    private ClassFilter[] myCatchClassFilters;
    private ClassFilter[] myCatchClassExclusionFilters;

    public JavaExceptionBreakpointProperties(String qualifiedName, String packageName) {
        this.myQualifiedName = qualifiedName;
        this.myPackageName = packageName;
    }

    public JavaExceptionBreakpointProperties() {
    }

    @Override
    @Nullable
    public JavaExceptionBreakpointProperties getState() {
        return this;
    }

    @Override
    public void loadState(JavaExceptionBreakpointProperties state) {
        super.loadState(state);
        this.NOTIFY_CAUGHT = state.NOTIFY_CAUGHT;
        this.NOTIFY_UNCAUGHT = state.NOTIFY_UNCAUGHT;
        this.myQualifiedName = state.myQualifiedName;
        this.myPackageName = state.myPackageName;
        this.setCatchFiltersEnabled(state.isCatchFiltersEnabled());
        this.myCatchClassFilters = state.getCatchClassFilters();
        this.myCatchClassExclusionFilters = state.getCatchClassExclusionFilters();
    }

    @OptionTag(value="catch-filters-enabled")
    public boolean isCatchFiltersEnabled() {
        return this.myCatchFiltersEnabled;
    }

    public boolean setCatchFiltersEnabled(boolean enabled) {
        boolean changed = this.myCatchFiltersEnabled != enabled;
        this.myCatchFiltersEnabled = enabled;
        return changed;
    }

    @Tag(value="catch-class-filters")
    @AbstractCollection(surroundWithTag=false)
    public final ClassFilter[] getCatchClassFilters() {
        return this.myCatchClassFilters != null ? this.myCatchClassFilters : ClassFilter.EMPTY_ARRAY;
    }

    public final boolean setCatchClassFilters(ClassFilter[] classFilters) {
        boolean changed = !JavaExceptionBreakpointProperties.filtersEqual(this.myCatchClassFilters, classFilters);
        this.myCatchClassFilters = classFilters;
        return changed;
    }

    @Tag(value="catch-class-exclusion-filters")
    @AbstractCollection(surroundWithTag=false)
    public ClassFilter[] getCatchClassExclusionFilters() {
        return this.myCatchClassExclusionFilters != null ? this.myCatchClassExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public boolean setCatchClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        boolean changed = !JavaExceptionBreakpointProperties.filtersEqual(this.myCatchClassExclusionFilters, classExclusionFilters);
        this.myCatchClassExclusionFilters = classExclusionFilters;
        return changed;
    }
}

