/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Url;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

public final class Location {
    private final Url url;
    private final Script script;
    private final int line;
    private final int column;

    public Location(@NotNull Url url, int line, int column) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/Location", "<init>"));
        }
        this.url = url;
        this.line = line;
        this.column = column;
        this.script = null;
    }

    public Location(@NotNull Script script, int line, int column) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/Location", "<init>"));
        }
        this.url = script.getUrl();
        this.line = line;
        this.column = column;
        this.script = script;
    }

    public Location(@NotNull Url url, int line) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/Location", "<init>"));
        }
        this(url, line, -1);
    }

    @NotNull
    public Location withoutColumn() {
        Location location = this.script == null ? new Location(this.url, this.line) : new Location(this.script, this.line, -1);
        if (location == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Location", "withoutColumn"));
        }
        return location;
    }

    @NotNull
    public Url getUrl() {
        Url url = this.url;
        if (url == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Location", "getUrl"));
        }
        return url;
    }

    @Nullable
    public Script getScript() {
        return this.script;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.column == location.column && this.line == location.line && this.url.equals(location.url);
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = 31 * result2 + this.line;
        result2 = 31 * result2 + this.column;
        return result2;
    }
}

