/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDefineImpl;
import org.intellij.plugins.relaxNG.inspections.BaseInspection;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedDefineInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unused Define" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection", "getDisplayName"));
        }
        return "Unused Define";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("UnusedDefine" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection", "getShortName"));
        }
        return "UnusedDefine";
    }

    @Override
    @NotNull
    public RncElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection", "buildVisitor"));
        }
        MyElementVisitor myElementVisitor = new MyElementVisitor(holder);
        if (myElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection", "buildVisitor"));
        }
        return myElementVisitor;
    }

    private static final class MyElementVisitor
    extends RncElementVisitor {
        private final ProblemsHolder myHolder;
        private final XmlElementVisitor myXmlVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                this.visitXmlTag(tag);
            }
        };

        public MyElementVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        protected void superVisitElement(PsiElement element) {
            element.accept((PsiElementVisitor)this.myXmlVisitor);
        }

        @Override
        public void visitDefine(RncDefine pattern) {
            RncGrammar grammar = (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)pattern, RncGrammar.class);
            PsiFile file2 = pattern.getContainingFile();
            if (grammar != null ? MyElementVisitor.processRncUsages(pattern, new LocalSearchScope((PsiElement)grammar)) : MyElementVisitor.processRncUsages(pattern, new LocalSearchScope((PsiElement)file2))) {
                return;
            }
            PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file2, (PsiElementProcessor<XmlFile>)collector);
            if (MyElementVisitor.processRncUsages(pattern, new LocalSearchScope(collector.toArray()))) {
                return;
            }
            ASTNode astNode = ((RncDefineImpl)pattern).getNameNode();
            this.myHolder.registerProblem(astNode.getPsi(), "Unreferenced define", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyFix<RncDefine>(pattern)});
        }

        private static boolean processRncUsages(PsiElement tag, LocalSearchScope scope) {
            Query query = ReferencesSearch.search((PsiElement)tag, (SearchScope)scope);
            for (PsiReference reference : query) {
                PsiElement e = reference.getElement();
                RncDefine t = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)e, RncDefine.class, (boolean)false);
                if (t != null && PsiTreeUtil.isAncestor((PsiElement)tag, (PsiElement)t, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        public void visitXmlTag(XmlTag tag) {
            PsiFile file2 = tag.getContainingFile();
            if (file2.getFileType() != StdFileTypes.XML) {
                return;
            }
            if (!tag.getLocalName().equals("define")) {
                return;
            }
            if (!tag.getNamespace().equals("http://relaxng.org/ns/structure/1.0")) {
                return;
            }
            if (tag.getAttribute("combine") != null) {
                return;
            }
            XmlAttribute attr = tag.getAttribute("name");
            if (attr == null) {
                return;
            }
            XmlAttributeValue value = attr.getValueElement();
            if (value == null) {
                return;
            }
            String s = value.getValue();
            if (s == null || s.length() == 0) {
                return;
            }
            PsiElement parent = value.getParent();
            if (!(parent instanceof XmlAttribute)) {
                return;
            }
            if (!"name".equals(((XmlAttribute)parent).getName())) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof XmlTag)) {
                return;
            }
            DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (element == null) {
                return;
            }
            RngGrammar rngGrammar = (RngGrammar)element.getParentOfType(RngGrammar.class, true);
            if (rngGrammar != null ? MyElementVisitor.processUsages((PsiElement)tag, value, new LocalSearchScope((PsiElement)rngGrammar.getXmlTag())) : MyElementVisitor.processUsages((PsiElement)tag, value, new LocalSearchScope((PsiElement)file2))) {
                return;
            }
            PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file2, (PsiElementProcessor<XmlFile>)collector);
            if (MyElementVisitor.processUsages((PsiElement)tag, value, new LocalSearchScope(collector.toArray()))) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)value, "Unreferenced define", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyFix<XmlTag>(tag)});
        }

        private static boolean processUsages(PsiElement tag, XmlAttributeValue value, LocalSearchScope scope) {
            Query query = ReferencesSearch.search((PsiElement)tag, (SearchScope)scope, (boolean)true);
            for (PsiReference reference : query) {
                XmlTag t;
                PsiElement e = reference.getElement();
                if (e == value || (t = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class)) == null || PsiTreeUtil.isAncestor((PsiElement)tag, (PsiElement)t, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        private static class MyFix<T extends PsiElement>
        implements LocalQuickFix {
            private final T myTag;

            public MyFix(T tag) {
                this.myTag = tag;
            }

            @NotNull
            public String getFamilyName() {
                if ("Remove define" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix", "getFamilyName"));
                }
                return "Remove define";
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix", "applyFix"));
                }
                try {
                    if (this.myTag.isValid()) {
                        this.myTag.delete();
                    }
                }
                catch (IncorrectOperationException e) {
                    Logger.getInstance((String)UnusedDefineInspection.class.getName()).error((Throwable)e);
                }
            }
        }
    }
}

