/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CStyleCommentPredicate;
import org.jetbrains.annotations.NotNull;

public class ChangeToEndOfLineCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CStyleCommentPredicate cStyleCommentPredicate = new CStyleCommentPredicate();
        if (cStyleCommentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/comment/ChangeToEndOfLineCommentIntention", "getElementPredicate"));
        }
        return cStyleCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/comment/ChangeToEndOfLineCommentIntention", "processIntention"));
        }
        PsiComment comment = (PsiComment)element;
        Project project2 = comment.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiElement parent = comment.getParent();
        assert (parent != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String commentText = comment.getText();
        PsiElement whitespace = comment.getNextSibling();
        String text = commentText.substring(2, commentText.length() - 2);
        String[] lines = text.split("\n");
        for (int i2 = lines.length - 1; i2 >= 1; --i2) {
            PsiComment nextComment = factory.createCommentFromText("//" + lines[i2].trim(), parent);
            parent.addAfter((PsiElement)nextComment, (PsiElement)comment);
            if (whitespace == null) continue;
            PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project2);
            PsiElement newWhiteSpace = parserFacade.createWhiteSpaceFromText(whitespace.getText());
            parent.addAfter(newWhiteSpace, (PsiElement)comment);
        }
        PsiComment newComment = factory.createCommentFromText("//" + lines[0], parent);
        PsiElement replacedComment = comment.replace((PsiElement)newComment);
        codeStyleManager.reformat(replacedComment);
    }
}

