/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SynchronizedMethodInspection
extends BaseInspection {
    public boolean m_includeNativeMethods = true;
    public boolean ignoreSynchronizedSuperMethods = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronized.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizedMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method2 = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("synchronized.method.problem.descriptor", method2.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizedMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method2 = (PsiMethod)infos[0];
        if (method2.getBody() == null) {
            return null;
        }
        return new SynchronizedMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizedMethodVisitor();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("synchronized.method.include.option", new Object[0]), "m_includeNativeMethods");
        panel2.addCheckbox(InspectionGadgetsBundle.message("synchronized.method.ignore.synchronized.super.option", new Object[0]), "ignoreSynchronizedSuperMethods");
        return panel2;
    }

    private class SynchronizedMethodVisitor
    extends BaseInspectionVisitor {
        private SynchronizedMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodVisitor", "visitMethod"));
            }
            if (!method2.hasModifierProperty("synchronized")) {
                return;
            }
            if (!SynchronizedMethodInspection.this.m_includeNativeMethods && method2.hasModifierProperty("native")) {
                return;
            }
            if (SynchronizedMethodInspection.this.ignoreSynchronizedSuperMethods) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
                    if (!superMethod.hasModifierProperty("synchronized")) continue;
                    return;
                }
            }
            this.registerModifierError("synchronized", (PsiModifierListOwner)method2, method2);
        }
    }

    private static class SynchronizedMethodFix
    extends InspectionGadgetsFix {
        private SynchronizedMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("synchronized.method.move.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String replacementText;
            PsiElement nameElement = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)nameElement.getParent();
            assert (modifierList != null);
            PsiMethod method2 = (PsiMethod)modifierList.getParent();
            modifierList.setModifierProperty("synchronized", false);
            assert (method2 != null);
            PsiCodeBlock body = method2.getBody();
            if (body == null) {
                return;
            }
            String text = body.getText();
            if (method2.hasModifierProperty("static")) {
                PsiClass containingClass = method2.getContainingClass();
                assert (containingClass != null);
                String className = containingClass.getName();
                replacementText = "{ synchronized(" + className + ".class){" + text.substring(1) + '}';
            } else {
                replacementText = "{ synchronized(this){" + text.substring(1) + '}';
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiCodeBlock block = elementFactory.createCodeBlockFromText(replacementText, null);
            body.replace((PsiElement)block);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
            codeStyleManager.reformat((PsiElement)method2);
        }
    }
}

