/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterTypeCanBeSpecifiedInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaParameterTypeCanBeSpecifiedInspection.class.getName()));

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.descriptor", infos);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InferLambdaParameterTypeVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InferLambdaParameterTypeFix(infos);
    }

    private static void doFix(@NotNull Project project2, @NotNull PsiLambdaExpression lambdaExpression) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "doFix"));
        }
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "doFix"));
        }
        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
        String buf = LambdaParameterTypeCanBeSpecifiedInspection.getInferredTypes(functionalInterfaceType, lambdaExpression, true);
        PsiMethod methodFromText = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText("void foo" + buf, (PsiElement)lambdaExpression);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(lambdaExpression.getParameterList().replace((PsiElement)methodFromText.getParameterList()));
    }

    @Nullable
    private static String getInferredTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression, boolean useFQN) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        LOG.assertTrue(interfaceMethod != null);
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = lambdaExpression.getParameterList().getParameters();
        if (parameters.length != lambdaParameters.length) {
            return null;
        }
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter parameter = parameters[i2];
            PsiType psiType = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult).substitute(parameter.getType());
            if (!PsiTypesUtil.isDenotableType((PsiType)psiType)) {
                return null;
            }
            if (psiType != null) {
                buf.append(useFQN ? psiType.getCanonicalText() : psiType.getPresentableText()).append(" ").append(lambdaParameters[i2].getName());
            } else {
                buf.append(lambdaParameters[i2].getName());
            }
            if (i2 >= parameters.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    private static class InferLambdaParameterTypeFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        public InferLambdaParameterTypeFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.quickfix", this.myInfos);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection$InferLambdaParameterTypeFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection$InferLambdaParameterTypeFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiLambdaExpression) {
                LambdaParameterTypeCanBeSpecifiedInspection.doFix(project2, (PsiLambdaExpression)element);
            }
        }
    }

    private static class InferLambdaParameterTypeVisitor
    extends BaseInspectionVisitor {
        private InferLambdaParameterTypeVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            String inferredTypesText;
            super.visitLambdaExpression(lambdaExpression);
            PsiParameter[] parameters = lambdaExpression.getParameterList().getParameters();
            if (parameters.length == 0) {
                return;
            }
            for (PsiParameter parameter : parameters) {
                if (parameter.getTypeElement() == null) continue;
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null && LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) != null && LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)functionalInterfaceType) && (inferredTypesText = LambdaParameterTypeCanBeSpecifiedInspection.getInferredTypes(functionalInterfaceType, lambdaExpression, false)) != null) {
                this.registerError((PsiElement)lambdaExpression, inferredTypesText);
            }
        }
    }
}

