/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallUtils {
    @NonNls
    private static final Set<String> regexMethodNames = new HashSet<String>(5);

    private MethodCallUtils() {
    }

    @Nullable
    public static String getMethodName(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "getMethodName"));
        }
        PsiReferenceExpression method2 = expression.getMethodExpression();
        return method2.getReferenceName();
    }

    @Nullable
    public static PsiType getTargetType(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "getTargetType"));
        }
        PsiReferenceExpression method2 = expression.getMethodExpression();
        PsiExpression qualifierExpression = method2.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        return qualifierExpression.getType();
    }

    public static boolean isEqualsCall(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"equals".equals(name)) {
            return false;
        }
        PsiMethod method2 = expression.resolveMethod();
        return MethodUtils.isEquals(method2);
    }

    public static boolean isSimpleCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "isSimpleCallToMethod"));
        }
        if (parameterTypeStrings == null) {
            return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, null);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)expression.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
        GlobalSearchScope scope = expression.getResolveScope();
        for (int i2 = 0; i2 < parameterTypeStrings.length; ++i2) {
            String parameterTypeString = parameterTypeStrings[i2];
            parameterTypes[i2] = factory.createTypeByFQClassName(parameterTypeString, scope);
        }
        return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiExpression qualifier;
        String referenceName;
        Matcher matcher;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "isCallToMethod"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(referenceName = methodExpression.getReferenceName())).matches()) {
            return false;
        }
        PsiMethod method2 = expression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        if (calledOnClassName != null && (qualifier = methodExpression.getQualifierExpression()) != null) {
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, calledOnClassName)) {
                return false;
            }
            return MethodUtils.methodMatches(method2, null, returnType, methodNamePattern, parameterTypes);
        }
        return MethodUtils.methodMatches(method2, calledOnClassName, returnType, methodNamePattern, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        String referenceName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "isCallToMethod"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        if (methodName != null && !methodName.equals(referenceName = methodExpression.getReferenceName())) {
            return false;
        }
        PsiMethod method2 = expression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        return MethodUtils.methodMatches(method2, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToRegexMethod(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!regexMethodNames.contains(name)) {
            return false;
        }
        PsiMethod method2 = expression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className = containingClass.getQualifiedName();
        return "java.lang.String".equals(className) || "java.util.regex.Pattern".equals(className);
    }

    public static boolean isCallDuringObjectConstruction(PsiMethodCallExpression expression) {
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (member == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || containingClass.hasModifierProperty("final")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            PsiClassInitializer classInitializer = (PsiClassInitializer)member;
            if (!classInitializer.hasModifierProperty("static")) {
                return true;
            }
        } else {
            PsiField field;
            if (member instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)member;
                if (method2.isConstructor()) {
                    return true;
                }
                if (CloneUtils.isClone(method2)) {
                    return true;
                }
                if (MethodUtils.simpleMethodMatches(method2, null, "void", "readObject", "java.io.ObjectInputStream")) {
                    return true;
                }
                return MethodUtils.simpleMethodMatches(method2, null, "void", "readObjectNoData", new String[0]);
            }
            if (member instanceof PsiField && !(field = (PsiField)member).hasModifierProperty("static")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodCallOnVariable(@NotNull PsiMethodCallExpression expression, @NotNull PsiVariable variable, @NotNull String methodName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "isMethodCallOnVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/MethodCallUtils", "isMethodCallOnVariable"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/siyeh/ig/psiutils/MethodCallUtils", "isMethodCallOnVariable"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!methodName.equals(name)) {
            return false;
        }
        PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement element = referenceExpression.resolve();
        return variable.equals(element);
    }

    @Nullable
    public static PsiMethod findMethodWithReplacedArgument(@NotNull PsiCall call, @NotNull PsiExpression target, @NotNull PsiExpression replacement) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/psiutils/MethodCallUtils", "findMethodWithReplacedArgument"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/MethodCallUtils", "findMethodWithReplacedArgument"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/siyeh/ig/psiutils/MethodCallUtils", "findMethodWithReplacedArgument"));
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] expressions = argumentList.getExpressions();
        int index = -1;
        for (int i2 = 0; i2 < expressions.length; ++i2) {
            PsiExpression expression = expressions[i2];
            if (expression != target) continue;
            index = i2;
        }
        if (index < 0) {
            return null;
        }
        PsiCall copy = (PsiCall)call.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        assert (copyArgumentList != null);
        PsiExpression[] arguments = copyArgumentList.getExpressions();
        arguments[index].replace((PsiElement)replacement);
        return copy.resolveMethod();
    }

    public static boolean isSuperMethodCall(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethod method2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "isSuperMethodCall"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodCallUtils", "isSuperMethodCall"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression target = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (!(target instanceof PsiSuperExpression)) {
            return false;
        }
        PsiMethod targetMethod = expression.resolveMethod();
        return targetMethod != null && MethodSignatureUtil.areSignaturesEqual((PsiMethod)targetMethod, (PsiMethod)method2);
    }

    public static boolean containsSuperMethodCall(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodCallUtils", "containsSuperMethodCall"));
        }
        SuperCallVisitor visitor = new SuperCallVisitor(method2);
        method2.accept((PsiElementVisitor)visitor);
        return visitor.isSuperCallFound();
    }

    public static boolean callWithNonConstantString(@NotNull PsiMethodCallExpression expression, boolean considerStaticFinalConstant, String className, String ... methodNames) {
        PsiField field;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils", "callWithNonConstantString"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        boolean found = false;
        for (String name : methodNames) {
            if (!name.equals(methodName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        PsiMethod method2 = expression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)className)) {
            return false;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression argument = ParenthesesUtils.stripParentheses(ExpressionUtils.getFirstExpressionInList(argumentList));
        if (argument == null) {
            return false;
        }
        PsiType type = argument.getType();
        if (type == null || !type.equalsToText("java.lang.String")) {
            return false;
        }
        if (considerStaticFinalConstant && argument instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiField && (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final")) {
            return false;
        }
        return !PsiUtil.isConstantExpression((PsiExpression)argument);
    }

    static {
        regexMethodNames.add("compile");
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod myMethod;
        private boolean mySuperCallFound;

        public SuperCallVisitor(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/MethodCallUtils$SuperCallVisitor", "<init>"));
            }
            this.myMethod = method2;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/MethodCallUtils$SuperCallVisitor", "visitElement"));
            }
            if (!this.mySuperCallFound) {
                super.visitElement(element);
            }
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiExpression condition = statement2.getCondition();
            Object result2 = ExpressionUtils.computeConstantExpression(condition);
            if (result2 != null && result2.equals(Boolean.FALSE)) {
                return;
            }
            super.visitIfStatement(statement2);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/MethodCallUtils$SuperCallVisitor", "visitMethodCallExpression"));
            }
            if (this.mySuperCallFound) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (MethodCallUtils.isSuperMethodCall(expression, this.myMethod)) {
                this.mySuperCallFound = true;
            }
        }

        boolean isSuperCallFound() {
            return this.mySuperCallFound;
        }
    }
}

