/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeOrAfterIsPublicVoidNoArgInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BeforeOrAfterWithIncorrectSignature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection", "getID"));
        }
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeOrAfterIsPublicVoidNoArgVisitor();
    }

    private static class BeforeOrAfterIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeOrAfterIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection$BeforeOrAfterIsPublicVoidNoArgVisitor", "visitMethod"));
            }
            if (!TestUtils.isJUnit4BeforeOrAfterMethod(method2)) {
                return;
            }
            PsiType returnType = method2.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method2.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                this.registerMethodError(method2, new Object[0]);
            } else if (!returnType.equals(PsiType.VOID)) {
                this.registerMethodError(method2, new Object[0]);
            } else if (!method2.hasModifierProperty("public")) {
                this.registerMethodError(method2, new Object[0]);
            } else if (method2.hasModifierProperty("static")) {
                this.registerMethodError(method2, new Object[0]);
            }
        }
    }
}

