/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase;
import org.jetbrains.annotations.NotNull;

public class BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection
extends BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 1) {
            return null;
        }
        Object name = infos[0];
        if (!(name instanceof String)) {
            return null;
        }
        return new MakePublicStaticVoidFix((String)name);
    }

    private static class MakePublicStaticVoidFix
    extends InspectionGadgetsFix {
        private final String myName;

        public MakePublicStaticVoidFix(String name) {
            this.myName = name;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            final PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            if (!(method2 == null || PsiType.VOID.equals((Object)method2.getReturnType()) && method2.hasModifierProperty("public") && method2.hasModifierProperty("static"))) {
                ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, method2, false, "public", method2.getName(), (PsiType)PsiType.VOID, new ParameterInfoImpl[0]){

                    @Override
                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        if (usages == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$MakePublicStaticVoidFix$1", "performRefactoring"));
                        }
                        super.performRefactoring(usages);
                        PsiModifierList modifierList = method2.getModifierList();
                        if (!modifierList.hasModifierProperty("static")) {
                            modifierList.setModifierProperty("static", true);
                        }
                    }
                };
                csp.run();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix modifiers" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$MakePublicStaticVoidFix", "getFamilyName"));
            }
            return "Fix modifiers";
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$MakePublicStaticVoidFix", "getName"));
            }
            return string;
        }
    }
}

