/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class FieldHasSetterButNoGetterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.has.setter.but.no.getter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.has.setter.but.no.getter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHasSetterButNoGetterVisitor();
    }

    private static class FieldHasSetterButNoGetterVisitor
    extends BaseInspectionVisitor {
        private FieldHasSetterButNoGetterVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection$FieldHasSetterButNoGetterVisitor", "visitField"));
            }
            String propertyName = PropertyUtil.suggestPropertyName((PsiField)field);
            boolean isStatic = field.hasModifierProperty("static");
            PsiClass containingClass = field.getContainingClass();
            PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
            if (setter == null) {
                return;
            }
            PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
            if (getter != null) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

