/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspectionBase
extends BaseInspection {
    public boolean ignoreEmptySuperMethods;
    final ExternalizableStringSet annotations = new ExternalizableStringSet("javax.annotation.OverridingMethodsMustInvokeSuper");
    boolean onlyReportWhenAnnotated = true;

    @NotNull
    public String getID() {
        if ("MethodDoesntCallSuperMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "getID"));
        }
        return "MethodDoesntCallSuperMethod";
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.onlyReportWhenAnnotated) {
            node.addContent(new Element("option").setAttribute("name", "onlyReportWhenAnnotated").setAttribute("value", String.valueOf(this.onlyReportWhenAnnotated)));
        }
        if (!this.annotations.hasDefaultValues()) {
            Element element = new Element("option").setAttribute("name", "annotations");
            Element valueElement = new Element("value");
            this.annotations.writeExternal(valueElement);
            node.addContent(element.addContent(valueElement));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        this.onlyReportWhenAnnotated = false;
        for (Element option : node.getChildren("option")) {
            Element value;
            if ("onlyReportWhenAnnotated".equals(option.getAttributeValue("name"))) {
                this.onlyReportWhenAnnotated = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (!"annotations".equals(option.getAttributeValue("name")) || (value = option.getChild("value")) == null) continue;
            this.annotations.readExternal(value);
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            String superClassName;
            PsiClass superClass;
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$RefusedBequestVisitor", "visitMethod"));
            }
            super.visitMethod(method2);
            PsiCodeBlock body = method2.getBody();
            if (body == null) {
                return;
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            PsiMethod leastConcreteSuperMethod = this.getDirectSuperMethod(method2);
            if (leastConcreteSuperMethod == null) {
                return;
            }
            String methodName = method2.getName();
            if (!"clone".equals(methodName) && (superClass = leastConcreteSuperMethod.getContainingClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            if (RefusedBequestInspectionBase.this.ignoreEmptySuperMethods) {
                PsiMethod superMethod;
                PsiElement element = leastConcreteSuperMethod.getNavigationElement();
                PsiMethod psiMethod = superMethod = element instanceof PsiMethod ? (PsiMethod)element : leastConcreteSuperMethod;
                if (MethodUtils.isTrivial(superMethod, true)) {
                    return;
                }
            }
            if (!(!RefusedBequestInspectionBase.this.onlyReportWhenAnnotated || CloneUtils.isClone(method2) || this.isJUnitSetUpOrTearDown(method2) || MethodUtils.isFinalize(method2) || AnnotationUtil.isAnnotated((PsiModifierListOwner)leastConcreteSuperMethod, (Collection)((Object)RefusedBequestInspectionBase.this.annotations)))) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if ((aClass != null && aClass.hasModifierProperty("final") || method2.hasModifierProperty("final")) && MethodUtils.isTrivial(method2, true)) {
                return;
            }
            if (MethodCallUtils.containsSuperMethodCall(method2)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }

        private boolean isJUnitSetUpOrTearDown(PsiMethod method2) {
            String name = method2.getName();
            if (!"setUp".equals(name) && !"tearDown".equals(name)) {
                return false;
            }
            if (method2.getParameterList().getParametersCount() != 0) {
                return false;
            }
            PsiClass aClass = method2.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase");
        }

        @Nullable
        private PsiMethod getDirectSuperMethod(PsiMethod method2) {
            PsiMethod superMethod = MethodUtils.getSuper(method2);
            if (superMethod == null || superMethod.hasModifierProperty("abstract")) {
                return null;
            }
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass == null || containingClass.isInterface()) {
                return null;
            }
            return superMethod;
        }
    }
}

