/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.exceptions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryStatementWithMultipleResourcesInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.statement.with.multiple.resources.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SplitTryWithResourcesVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SplitTryWithResourcesFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCatchSection[] catchSections;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection", "doFixImpl"));
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element.getParent();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null || resourceList.getResourceVariablesCount() <= 1) {
            return;
        }
        StringBuilder newTryStatementText = new StringBuilder();
        int count = 0;
        for (PsiResourceListElement resource : resourceList) {
            if (count > 0) {
                newTryStatementText.append("{\n");
            }
            ++count;
            newTryStatementText.append("try (").append(resource.getText()).append(")");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        newTryStatementText.append(tryBlock.getText());
        for (int i2 = 1; i2 < count; ++i2) {
            newTryStatementText.append("\n}");
        }
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            newTryStatementText.append(catchSection.getText());
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatementText.append("finally").append(finallyBlock.getText());
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)tryStatement, newTryStatementText.toString());
    }

    private static boolean isAcceptable(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        return resourceList.getResourceVariablesCount() > 1;
    }

    private static class SplitTryWithResourcesFix
    extends InspectionGadgetsFix {
        private SplitTryWithResourcesFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            TryStatementWithMultipleResourcesInspection.doFixImpl(descriptor.getPsiElement());
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("try.statement.with.multiple.resources.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/TryStatementWithMultipleResourcesInspection$SplitTryWithResourcesFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class SplitTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private SplitTryWithResourcesVisitor() {
        }

        public void visitKeyword(PsiKeyword keyword) {
            super.visitKeyword(keyword);
            if (this.isOnTheFly() && keyword.getTokenType() == JavaTokenType.TRY_KEYWORD && TryStatementWithMultipleResourcesInspection.isAcceptable((PsiElement)keyword)) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            super.visitResourceList(resourceList);
            if (TryStatementWithMultipleResourcesInspection.isAcceptable((PsiElement)resourceList)) {
                this.registerError((PsiElement)resourceList, new Object[0]);
            }
        }
    }
}

