/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class TextLabelInSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("text.label.in.switch.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("text.label.in.switch.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TextLabelInSwitchStatementVisitor();
    }

    private static class TextLabelInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private TextLabelInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            PsiStatement[] statements;
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection$TextLabelInSwitchStatementVisitor", "visitSwitchStatement"));
            }
            super.visitSwitchStatement(statement2);
            PsiCodeBlock body = statement2.getBody();
            if (body == null) {
                return;
            }
            for (PsiStatement statement1 : statements = body.getStatements()) {
                this.checkForLabel(statement1);
            }
        }

        private void checkForLabel(PsiStatement statement2) {
            if (!(statement2 instanceof PsiLabeledStatement)) {
                return;
            }
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiIdentifier label = labeledStatement.getLabelIdentifier();
            this.registerError((PsiElement)label, new Object[0]);
        }
    }
}

