/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullArgumentToVariableArgMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConfusingArgumentToVarargsMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection", "getID"));
        }
        return "ConfusingArgumentToVarargsMethod";
    }

    @Nullable
    public String getAlternativeID() {
        return "NullArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("null.argument.to.var.arg.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("null.argument.to.var.arg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        PsiType type1 = (PsiType)infos[1];
        PsiType type2 = (PsiType)infos[2];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new DelegatingFix((LocalQuickFix)new AddTypeCastFix(type1, argument)), new DelegatingFix((LocalQuickFix)new AddTypeCastFix(type2, argument))};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NullArgumentToVariableArgVisitor();
    }

    private static class NullArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private NullArgumentToVariableArgVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            boolean checkArray;
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection$NullArgumentToVariableArgVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(call);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            PsiType type = lastArgument.getType();
            if (PsiType.NULL.equals((Object)type)) {
                checkArray = false;
            } else if (type instanceof PsiArrayType) {
                checkArray = true;
            } else {
                return;
            }
            PsiMethod method2 = call.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != arguments.length) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiType type1 = lastParameter.getType();
            if (!(type1 instanceof PsiEllipsisType)) {
                return;
            }
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type1;
            PsiType arrayType = ellipsisType.toArrayType();
            PsiType componentType = ellipsisType.getComponentType();
            if (checkArray) {
                if (!componentType.equals(TypeUtils.getObjectType((PsiElement)call))) {
                    return;
                }
                if (type.isAssignableFrom(arrayType) || !arrayType.isAssignableFrom(type)) {
                    return;
                }
            }
            this.registerError((PsiElement)lastArgument, lastArgument, componentType, arrayType);
        }
    }
}

