/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CovariantEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("covariant.equals.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CovariantEqualsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("covariant.equals.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CovariantEqualsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CovariantEqualsVisitor();
    }

    private static class CovariantEqualsVisitor
    extends BaseInspectionVisitor {
        private CovariantEqualsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiMethod[] methods;
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/CovariantEqualsInspection$CovariantEqualsVisitor", "visitMethod"));
            }
            String name = method2.getName();
            if (!"equals".equals(name)) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType argType = parameters[0].getType();
            if (TypeUtils.isJavaLangObject(argType)) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (PsiMethod method1 : methods = aClass.findMethodsByName("equals", false)) {
                if (!MethodUtils.isEquals(method1)) continue;
                return;
            }
            if (SuperMethodsSearch.search((PsiMethod)method2, null, (boolean)true, (boolean)false).findFirst() != null) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

