/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ComparableImplementedButEqualsNotOverriddenInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareToAndEqualsNotPairedVisitor();
    }

    private static class CompareToAndEqualsNotPairedVisitor
    extends BaseInspectionVisitor {
        private CompareToAndEqualsNotPairedVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiMethod[] equalsMethods;
            GlobalSearchScope scope;
            super.visitClass(aClass);
            PsiMethod[] methods = aClass.findMethodsByName("compareTo", false);
            if (methods.length == 0) {
                return;
            }
            Project project2 = aClass.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass comparableClass = psiFacade.findClass("java.lang.Comparable", scope = aClass.getResolveScope());
            if (comparableClass == null) {
                return;
            }
            if (!aClass.isInheritor(comparableClass, true)) {
                return;
            }
            PsiMethod compareToMethod = comparableClass.getMethods()[0];
            boolean foundCompareTo = false;
            for (PsiMethod method2 : methods) {
                if (!MethodSignatureUtil.isSuperMethod((PsiMethod)compareToMethod, (PsiMethod)method2)) continue;
                foundCompareTo = true;
                break;
            }
            if (!foundCompareTo) {
                return;
            }
            for (PsiMethod equalsMethod : equalsMethods = aClass.findMethodsByName("equals", false)) {
                if (!MethodUtils.isEquals(equalsMethod)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

